import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 */
export interface CfnBudgetProps {
    /**
     * `AWS::Budgets::Budget.Budget`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget
     * @external
     */
    readonly budget: CfnBudget.BudgetDataProperty | cdk.IResolvable;
    /**
     * `AWS::Budgets::Budget.NotificationsWithSubscribers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers
     * @external
     */
    readonly notificationsWithSubscribers?: Array<CfnBudget.NotificationWithSubscribersProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 */
export declare class CfnBudget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Budgets::Budget";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBudget;
    /**
     * `AWS::Budgets::Budget.Budget`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget
     * @external
     */
    budget: CfnBudget.BudgetDataProperty | cdk.IResolvable;
    /**
     * `AWS::Budgets::Budget.NotificationsWithSubscribers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers
     * @external
     */
    notificationsWithSubscribers: Array<CfnBudget.NotificationWithSubscribersProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Budgets::Budget`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBudgetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 */
export declare namespace CfnBudget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html
     * @external
     */
    interface BudgetDataProperty {
        /**
         * `CfnBudget.BudgetDataProperty.BudgetLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetlimit
         * @external
         */
        readonly budgetLimit?: CfnBudget.SpendProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.BudgetName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetname
         * @external
         */
        readonly budgetName?: string;
        /**
         * `CfnBudget.BudgetDataProperty.BudgetType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgettype
         * @external
         */
        readonly budgetType: string;
        /**
         * `CfnBudget.BudgetDataProperty.CostFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costfilters
         * @external
         */
        readonly costFilters?: any | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.CostTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costtypes
         * @external
         */
        readonly costTypes?: CfnBudget.CostTypesProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.PlannedBudgetLimits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-plannedbudgetlimits
         * @external
         */
        readonly plannedBudgetLimits?: any | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.TimePeriod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeperiod
         * @external
         */
        readonly timePeriod?: CfnBudget.TimePeriodProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.TimeUnit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeunit
         * @external
         */
        readonly timeUnit: string;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 */
export declare namespace CfnBudget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html
     * @external
     */
    interface CostTypesProperty {
        /**
         * `CfnBudget.CostTypesProperty.IncludeCredit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includecredit
         * @external
         */
        readonly includeCredit?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeDiscount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includediscount
         * @external
         */
        readonly includeDiscount?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeOtherSubscription`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeothersubscription
         * @external
         */
        readonly includeOtherSubscription?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeRecurring`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerecurring
         * @external
         */
        readonly includeRecurring?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeRefund`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerefund
         * @external
         */
        readonly includeRefund?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeSubscription`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesubscription
         * @external
         */
        readonly includeSubscription?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeSupport`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesupport
         * @external
         */
        readonly includeSupport?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeTax`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includetax
         * @external
         */
        readonly includeTax?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeUpfront`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeupfront
         * @external
         */
        readonly includeUpfront?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.UseAmortized`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useamortized
         * @external
         */
        readonly useAmortized?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.UseBlended`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useblended
         * @external
         */
        readonly useBlended?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 */
export declare namespace CfnBudget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html
     * @external
     */
    interface NotificationProperty {
        /**
         * `CfnBudget.NotificationProperty.ComparisonOperator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-comparisonoperator
         * @external
         */
        readonly comparisonOperator: string;
        /**
         * `CfnBudget.NotificationProperty.NotificationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-notificationtype
         * @external
         */
        readonly notificationType: string;
        /**
         * `CfnBudget.NotificationProperty.Threshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-threshold
         * @external
         */
        readonly threshold: number;
        /**
         * `CfnBudget.NotificationProperty.ThresholdType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-thresholdtype
         * @external
         */
        readonly thresholdType?: string;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 */
export declare namespace CfnBudget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html
     * @external
     */
    interface NotificationWithSubscribersProperty {
        /**
         * `CfnBudget.NotificationWithSubscribersProperty.Notification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-notification
         * @external
         */
        readonly notification: CfnBudget.NotificationProperty | cdk.IResolvable;
        /**
         * `CfnBudget.NotificationWithSubscribersProperty.Subscribers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-subscribers
         * @external
         */
        readonly subscribers: Array<CfnBudget.SubscriberProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 */
export declare namespace CfnBudget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html
     * @external
     */
    interface SpendProperty {
        /**
         * `CfnBudget.SpendProperty.Amount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-amount
         * @external
         */
        readonly amount: number;
        /**
         * `CfnBudget.SpendProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-unit
         * @external
         */
        readonly unit: string;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 */
export declare namespace CfnBudget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html
     * @external
     */
    interface SubscriberProperty {
        /**
         * `CfnBudget.SubscriberProperty.Address`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-address
         * @external
         */
        readonly address: string;
        /**
         * `CfnBudget.SubscriberProperty.SubscriptionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-subscriptiontype
         * @external
         */
        readonly subscriptionType: string;
    }
}
/**
 * A CloudFormation `AWS::Budgets::Budget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 * @external
 * @cloudformationResource AWS::Budgets::Budget
 */
export declare namespace CfnBudget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html
     * @external
     */
    interface TimePeriodProperty {
        /**
         * `CfnBudget.TimePeriodProperty.End`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-end
         * @external
         */
        readonly end?: string;
        /**
         * `CfnBudget.TimePeriodProperty.Start`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-start
         * @external
         */
        readonly start?: string;
    }
}
