/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseTaskOptions
implements Serializable {
    private final Map<String, Double> resources;

    public BaseTaskOptions(Map<String, Double> resources) {
        if (resources == null) {
            throw new IllegalArgumentException("Resources map should not be null!");
        }
        Map<String, Double> filteredResources = this.validateAndFilterResources(resources);
        this.resources = Collections.unmodifiableMap(filteredResources);
    }

    private Map<String, Double> validateAndFilterResources(Map<String, Double> resources) {
        HashMap<String, Double> filtered = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : resources.entrySet()) {
            String name = entry.getKey();
            Double value = entry.getValue();
            this.validateResourceValue(name, value);
            this.validateIntegerConstraint(name, value);
            if (value == 0.0) continue;
            filtered.put(name, value);
        }
        return filtered;
    }

    private void validateResourceValue(String name, Double value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(String.format("Resource name and value should not be null. Specified resource: %s = %s.", name, value));
        }
        if (value < 0.0) {
            throw new IllegalArgumentException(String.format("Resource values should be non negative. Specified resource: %s = %s.", name, value));
        }
    }

    private void validateIntegerConstraint(String name, Double value) {
        if (value >= 1.0 && value % 1.0 != 0.0) {
            throw new IllegalArgumentException(String.format("A resource value should be an integer if it is greater than 1.0. Specified resource: %s = %s", name, value));
        }
    }

    public Map<String, Double> getResources() {
        return this.resources;
    }
}

