"""
Module for handling HTTP exceptions.

This module provides a base class `HTTPException` for representing and raising HTTP-related exceptions.
The exception includes an HTTP status code and an optional custom error message. If no custom message is provided,
the default phrase associated with the HTTP status code is used.

Attributes:
    VERSION (str): Version of the module.

Classes:
    HTTPException: Base class for all HTTP exceptions.

"""

VERSION: str = "1.0.0"

from http import HTTPStatus
from typing import Self

class HTTPException(Exception):
    """Base class for all HTTP exceptions."""
    def __init__(self: Self, status: HTTPStatus, message: str | None = None) -> Self:
        """
        Initialize the HTTPException.

        Args:
            status (HTTPStatus): The HTTP status code.
            message (str | None): Optional custom error message. Defaults to None.
        """
        self.status: HTTPStatus = status
        self.message: str = message or status.phrase
        super().__init__(f"{self.message} ({status.value})")
