"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Architecture = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Architectures supported by AWS Lambda.
 *
 * @stability stable
 */
class Architecture {
    constructor(archName, dockerPlatform) {
        this.name = archName;
        this.dockerPlatform = dockerPlatform;
    }
    /**
     * Used to specify a custom architecture name.
     *
     * Use this if the architecture name is not yet supported by the CDK.
     *
     * @param name the architecture name as recognized by AWS Lambda.
     * @param dockerPlatform the platform to use for this architecture when building with Docker.
     * @stability stable
     */
    static custom(name, dockerPlatform) {
        return new Architecture(name, dockerPlatform !== null && dockerPlatform !== void 0 ? dockerPlatform : 'linux/amd64');
    }
}
exports.Architecture = Architecture;
_a = JSII_RTTI_SYMBOL_1;
Architecture[_a] = { fqn: "@aws-cdk/aws-lambda.Architecture", version: "1.138.2" };
/**
 * 64 bit architecture with x86 instruction set.
 *
 * @stability stable
 */
Architecture.X86_64 = new Architecture('x86_64', 'linux/amd64');
/**
 * 64 bit architecture with the ARM instruction set.
 *
 * @stability stable
 */
Architecture.ARM_64 = new Architecture('arm64', 'linux/arm64');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXJjaGl0ZWN0dXJlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXJjaGl0ZWN0dXJlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFDQSxNQUFhLFlBQVk7SUFrQnZCLFlBQW9CLFFBQWdCLEVBQUUsY0FBc0I7UUFDMUQsSUFBSSxDQUFDLElBQUksR0FBRyxRQUFRLENBQUM7UUFDckIsSUFBSSxDQUFDLGNBQWMsR0FBRyxjQUFjLENBQUM7S0FDdEM7Ozs7Ozs7Ozs7SUFiTSxNQUFNLENBQUMsTUFBTSxDQUFDLElBQVksRUFBRSxjQUF1QjtRQUN4RCxPQUFPLElBQUksWUFBWSxDQUFDLElBQUksRUFBRSxjQUFjLGFBQWQsY0FBYyxjQUFkLGNBQWMsR0FBSSxhQUFhLENBQUMsQ0FBQztLQUNoRTs7QUFWSCxvQ0FzQkM7Ozs7Ozs7O0FBcEJ3QixtQkFBTSxHQUFHLElBQUksWUFBWSxDQUFDLFFBQVEsRUFBRSxhQUFhLENBQUMsQ0FBQzs7Ozs7O0FBR25ELG1CQUFNLEdBQUcsSUFBSSxZQUFZLENBQUMsT0FBTyxFQUFFLGFBQWEsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQXJjaGl0ZWN0dXJlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgWDg2XzY0ID0gbmV3IEFyY2hpdGVjdHVyZSgneDg2XzY0JywgJ2xpbnV4L2FtZDY0Jyk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFSTV82NCA9IG5ldyBBcmNoaXRlY3R1cmUoJ2FybTY0JywgJ2xpbnV4L2FybTY0Jyk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGN1c3RvbShuYW1lOiBzdHJpbmcsIGRvY2tlclBsYXRmb3JtPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIG5ldyBBcmNoaXRlY3R1cmUobmFtZSwgZG9ja2VyUGxhdGZvcm0gPz8gJ2xpbnV4L2FtZDY0Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBkb2NrZXJQbGF0Zm9ybTogc3RyaW5nO1xuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoYXJjaE5hbWU6IHN0cmluZywgZG9ja2VyUGxhdGZvcm06IHN0cmluZykge1xuICAgIHRoaXMubmFtZSA9IGFyY2hOYW1lO1xuICAgIHRoaXMuZG9ja2VyUGxhdGZvcm0gPSBkb2NrZXJQbGF0Zm9ybTtcbiAgfVxufVxuIl19