"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flatten = exports.flatMap = exports.addAlias = void 0;
const alias_1 = require("./alias");
function addAlias(scope, version, aliasName, options = {}) {
    return new alias_1.Alias(scope, `Alias${aliasName}`, {
        aliasName,
        version,
        ...options,
    });
}
exports.addAlias = addAlias;
/**
 * Map a function over an array and concatenate the results
 */
function flatMap(xs, fn) {
    return flatten(xs.map(fn));
}
exports.flatMap = flatMap;
/**
 * Flatten a list of lists into a list of elements
 */
function flatten(xs) {
    return Array.prototype.concat.apply([], xs);
}
exports.flatten = flatten;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsbUNBQThDO0FBRzlDLFNBQWdCLFFBQVEsQ0FBQyxLQUFnQixFQUFFLE9BQWlCLEVBQUUsU0FBaUIsRUFBRSxVQUF3QixFQUFFO0lBQ3pHLE9BQU8sSUFBSSxhQUFLLENBQUMsS0FBSyxFQUFFLFFBQVEsU0FBUyxFQUFFLEVBQUU7UUFDM0MsU0FBUztRQUNULE9BQU87UUFDUCxHQUFHLE9BQU87S0FDWCxDQUFDLENBQUM7QUFDTCxDQUFDO0FBTkQsNEJBTUM7QUFFRDs7R0FFRztBQUNILFNBQWdCLE9BQU8sQ0FBTyxFQUFPLEVBQUUsRUFBOEI7SUFDbkUsT0FBTyxPQUFPLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0FBQzdCLENBQUM7QUFGRCwwQkFFQztBQUVEOztHQUVHO0FBQ0gsU0FBZ0IsT0FBTyxDQUFJLEVBQVM7SUFDbEMsT0FBTyxLQUFLLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzlDLENBQUM7QUFGRCwwQkFFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQWxpYXMsIEFsaWFzT3B0aW9ucyB9IGZyb20gJy4vYWxpYXMnO1xuaW1wb3J0IHsgSVZlcnNpb24gfSBmcm9tICcuL2xhbWJkYS12ZXJzaW9uJztcblxuZXhwb3J0IGZ1bmN0aW9uIGFkZEFsaWFzKHNjb3BlOiBDb25zdHJ1Y3QsIHZlcnNpb246IElWZXJzaW9uLCBhbGlhc05hbWU6IHN0cmluZywgb3B0aW9uczogQWxpYXNPcHRpb25zID0ge30pIHtcbiAgcmV0dXJuIG5ldyBBbGlhcyhzY29wZSwgYEFsaWFzJHthbGlhc05hbWV9YCwge1xuICAgIGFsaWFzTmFtZSxcbiAgICB2ZXJzaW9uLFxuICAgIC4uLm9wdGlvbnMsXG4gIH0pO1xufVxuXG4vKipcbiAqIE1hcCBhIGZ1bmN0aW9uIG92ZXIgYW4gYXJyYXkgYW5kIGNvbmNhdGVuYXRlIHRoZSByZXN1bHRzXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBmbGF0TWFwPFQsIFU+KHhzOiBUW10sIGZuOiAoKHg6IFQsIGk6IG51bWJlcikgPT4gVVtdKSk6IFVbXSB7XG4gIHJldHVybiBmbGF0dGVuKHhzLm1hcChmbikpO1xufVxuXG4vKipcbiAqIEZsYXR0ZW4gYSBsaXN0IG9mIGxpc3RzIGludG8gYSBsaXN0IG9mIGVsZW1lbnRzXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBmbGF0dGVuPFQ+KHhzOiBUW11bXSk6IFRbXSB7XG4gIHJldHVybiBBcnJheS5wcm90b3R5cGUuY29uY2F0LmFwcGx5KFtdLCB4cyk7XG59XG4iXX0=