"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)


class DedicatedEndpointSpecBetaTypedDict(TypedDict):
    r"""Dedicated endpoint specification."""

    autoscaling_cooldown: int
    r"""The cooldown period in seconds between scaling operations."""
    autoscaling_max: int
    r"""The maximum number of replicas allowed."""
    autoscaling_min: int
    r"""The minimum number of replicas to maintain."""
    creator_id: str
    r"""The ID of the user who created the endpoint."""
    gpu_type: str
    r"""The type of GPU to use for the endpoint."""
    max_batch_size: int
    r"""The maximum batch size for inference requests."""
    name: str
    r"""The name of the endpoint."""
    num_gpu: int
    r"""The number of GPUs to use per replica."""
    project_id: str
    r"""The ID of the project that owns the endpoint."""
    team_id: str
    r"""The ID of the team that owns the endpoint."""
    tokenizer_add_special_tokens: bool
    r"""Whether to add special tokens in tokenizer input."""
    tokenizer_skip_special_tokens: bool
    r"""Whether to skip special tokens in tokenizer output."""
    curr_replica_cnt: NotRequired[Nullable[int]]
    r"""The current number of replicas."""
    desired_replica_cnt: NotRequired[Nullable[int]]
    r"""The desired number of replicas."""
    instance_id: NotRequired[Nullable[str]]
    r"""The ID of the instance."""
    max_input_length: NotRequired[Nullable[int]]
    r"""The maximum allowed input length."""
    updated_replica_cnt: NotRequired[Nullable[int]]
    r"""The updated number of replicas."""


class DedicatedEndpointSpecBeta(BaseModel):
    r"""Dedicated endpoint specification."""

    autoscaling_cooldown: Annotated[int, pydantic.Field(alias="autoscalingCooldown")]
    r"""The cooldown period in seconds between scaling operations."""

    autoscaling_max: Annotated[int, pydantic.Field(alias="autoscalingMax")]
    r"""The maximum number of replicas allowed."""

    autoscaling_min: Annotated[int, pydantic.Field(alias="autoscalingMin")]
    r"""The minimum number of replicas to maintain."""

    creator_id: Annotated[str, pydantic.Field(alias="creatorId")]
    r"""The ID of the user who created the endpoint."""

    gpu_type: Annotated[str, pydantic.Field(alias="gpuType")]
    r"""The type of GPU to use for the endpoint."""

    max_batch_size: Annotated[int, pydantic.Field(alias="maxBatchSize")]
    r"""The maximum batch size for inference requests."""

    name: str
    r"""The name of the endpoint."""

    num_gpu: Annotated[int, pydantic.Field(alias="numGpu")]
    r"""The number of GPUs to use per replica."""

    project_id: Annotated[str, pydantic.Field(alias="projectId")]
    r"""The ID of the project that owns the endpoint."""

    team_id: Annotated[str, pydantic.Field(alias="teamId")]
    r"""The ID of the team that owns the endpoint."""

    tokenizer_add_special_tokens: Annotated[
        bool, pydantic.Field(alias="tokenizerAddSpecialTokens")
    ]
    r"""Whether to add special tokens in tokenizer input."""

    tokenizer_skip_special_tokens: Annotated[
        bool, pydantic.Field(alias="tokenizerSkipSpecialTokens")
    ]
    r"""Whether to skip special tokens in tokenizer output."""

    curr_replica_cnt: Annotated[
        OptionalNullable[int], pydantic.Field(alias="currReplicaCnt")
    ] = UNSET
    r"""The current number of replicas."""

    desired_replica_cnt: Annotated[
        OptionalNullable[int], pydantic.Field(alias="desiredReplicaCnt")
    ] = UNSET
    r"""The desired number of replicas."""

    instance_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="instanceId")
    ] = UNSET
    r"""The ID of the instance."""

    max_input_length: Annotated[
        OptionalNullable[int], pydantic.Field(alias="maxInputLength")
    ] = UNSET
    r"""The maximum allowed input length."""

    updated_replica_cnt: Annotated[
        OptionalNullable[int], pydantic.Field(alias="updatedReplicaCnt")
    ] = UNSET
    r"""The updated number of replicas."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "currReplicaCnt",
            "desiredReplicaCnt",
            "instanceId",
            "maxInputLength",
            "updatedReplicaCnt",
        ]
        nullable_fields = [
            "currReplicaCnt",
            "desiredReplicaCnt",
            "instanceId",
            "maxInputLength",
            "updatedReplicaCnt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
