"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .autoscalingpolicy import AutoscalingPolicy, AutoscalingPolicyTypedDict
from .endpointadvancedconfig import (
    EndpointAdvancedConfig,
    EndpointAdvancedConfigTypedDict,
)
from .endpointsimplescaleconfig import (
    EndpointSimplescaleConfig,
    EndpointSimplescaleConfigTypedDict,
)


class DedicatedEndpointUpdateBodyTypedDict(TypedDict):
    r"""Dedicated endpoint update request."""

    advanced: NotRequired[Nullable[EndpointAdvancedConfigTypedDict]]
    r"""The advanced configuration of the endpoint."""
    autoscaling_policy: NotRequired[Nullable[AutoscalingPolicyTypedDict]]
    r"""The auto scaling configuration of the endpoint."""
    hf_model_repo: NotRequired[Nullable[str]]
    r"""HF ID of the model."""
    hf_model_repo_revision: NotRequired[Nullable[str]]
    r"""HF commit hash of the model."""
    instance_option_id: NotRequired[Nullable[str]]
    r"""The ID of the instance option."""
    name: NotRequired[Nullable[str]]
    r"""The name of the endpoint."""
    new_version_comment: NotRequired[Nullable[str]]
    r"""Comment for the new version."""
    simplescale: NotRequired[Nullable[EndpointSimplescaleConfigTypedDict]]
    r"""The simple scaling configuration of the endpoint."""


class DedicatedEndpointUpdateBody(BaseModel):
    r"""Dedicated endpoint update request."""

    advanced: OptionalNullable[EndpointAdvancedConfig] = UNSET
    r"""The advanced configuration of the endpoint."""

    autoscaling_policy: Annotated[
        OptionalNullable[AutoscalingPolicy], pydantic.Field(alias="autoscalingPolicy")
    ] = UNSET
    r"""The auto scaling configuration of the endpoint."""

    hf_model_repo: Annotated[
        OptionalNullable[str], pydantic.Field(alias="hfModelRepo")
    ] = UNSET
    r"""HF ID of the model."""

    hf_model_repo_revision: Annotated[
        OptionalNullable[str], pydantic.Field(alias="hfModelRepoRevision")
    ] = UNSET
    r"""HF commit hash of the model."""

    instance_option_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="instanceOptionId")
    ] = UNSET
    r"""The ID of the instance option."""

    name: OptionalNullable[str] = UNSET
    r"""The name of the endpoint."""

    new_version_comment: Annotated[
        OptionalNullable[str], pydantic.Field(alias="newVersionComment")
    ] = UNSET
    r"""Comment for the new version."""

    simplescale: OptionalNullable[EndpointSimplescaleConfig] = UNSET
    r"""The simple scaling configuration of the endpoint."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "advanced",
            "autoscalingPolicy",
            "hfModelRepo",
            "hfModelRepoRevision",
            "instanceOptionId",
            "name",
            "newVersionComment",
            "simplescale",
        ]
        nullable_fields = [
            "advanced",
            "autoscalingPolicy",
            "hfModelRepo",
            "hfModelRepoRevision",
            "instanceOptionId",
            "name",
            "newVersionComment",
            "simplescale",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
