"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Optional

from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)


class EndpointAdvancedConfigTypedDict(TypedDict):
    r"""Endpoint advanced config."""

    tokenizer_add_special_tokens: bool
    tokenizer_skip_special_tokens: bool
    enable_content_logging: NotRequired[Nullable[bool]]
    max_batch_size: NotRequired[int]
    max_input_length: NotRequired[Nullable[int]]
    max_token_count: NotRequired[int]


class EndpointAdvancedConfig(BaseModel):
    r"""Endpoint advanced config."""

    tokenizer_add_special_tokens: bool

    tokenizer_skip_special_tokens: bool

    enable_content_logging: OptionalNullable[bool] = UNSET

    max_batch_size: Optional[int] = 256

    max_input_length: OptionalNullable[int] = UNSET

    max_token_count: Optional[int] = 2560

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "enable_content_logging",
            "max_batch_size",
            "max_input_length",
            "max_token_count",
        ]
        nullable_fields = ["enable_content_logging", "max_input_length"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
