"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Any, Dict

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)


class FileInitUploadResponseTypedDict(TypedDict):
    r"""Initiate file upload response."""

    file_id: str
    r"""ID of the file."""
    aws: NotRequired[Nullable[Dict[str, Any]]]
    r"""AWS fields to be uploaded with file."""
    upload_url: NotRequired[Nullable[str]]
    r"""Upload URL of the file. `None` if the file is already uploaded."""


class FileInitUploadResponse(BaseModel):
    r"""Initiate file upload response."""

    file_id: Annotated[str, pydantic.Field(alias="fileId")]
    r"""ID of the file."""

    aws: OptionalNullable[Dict[str, Any]] = UNSET
    r"""AWS fields to be uploaded with file."""

    upload_url: Annotated[OptionalNullable[str], pydantic.Field(alias="uploadUrl")] = (
        UNSET
    )
    r"""Upload URL of the file. `None` if the file is already uploaded."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["aws", "uploadUrl"]
        nullable_fields = ["aws", "uploadUrl"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
