"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import List

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .splitinfo import SplitInfo, SplitInfoTypedDict


class ListSplitsResponseTypedDict(TypedDict):
    r"""List splits response."""

    data: List[SplitInfoTypedDict]
    r"""List of items."""
    next_cursor: NotRequired[Nullable[bytes]]
    r"""Next cursor to use for pagination. `None` indicates no more items to fetch."""


class ListSplitsResponse(BaseModel):
    r"""List splits response."""

    data: List[SplitInfo]
    r"""List of items."""

    next_cursor: Annotated[
        OptionalNullable[bytes], pydantic.Field(alias="nextCursor")
    ] = UNSET
    r"""Next cursor to use for pagination. `None` indicates no more items to fetch."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["nextCursor"]
        nullable_fields = ["nextCursor"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
