"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import List, Literal

import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)
from friendli_core.utils import validate_const

from .chatusage import ChatUsage, ChatUsageTypedDict
from .streamedchatchoice import StreamedChatChoice, StreamedChatChoiceTypedDict


class StreamedChatDataTypedDict(TypedDict):
    choices: List[StreamedChatChoiceTypedDict]
    created: int
    r"""The Unix timestamp (in seconds) for when the token sampled."""
    id: str
    r"""A unique ID of the chat completion."""
    object: Literal["chat.completion.chunk"]
    r"""The object type, which is always set to `chat.completion.chunk`."""
    model: NotRequired[Nullable[str]]
    r"""The model to generate the completion. For dedicated endpoints, it returns the endpoint id."""
    usage: NotRequired[Nullable[ChatUsageTypedDict]]


class StreamedChatData(BaseModel):
    choices: List[StreamedChatChoice]

    created: int
    r"""The Unix timestamp (in seconds) for when the token sampled."""

    id: str
    r"""A unique ID of the chat completion."""

    OBJECT: Annotated[
        Annotated[
            Literal["chat.completion.chunk"],
            AfterValidator(validate_const("chat.completion.chunk")),
        ],
        pydantic.Field(alias="object"),
    ] = "chat.completion.chunk"
    r"""The object type, which is always set to `chat.completion.chunk`."""

    model: OptionalNullable[str] = UNSET
    r"""The model to generate the completion. For dedicated endpoints, it returns the endpoint id."""

    usage: OptionalNullable[ChatUsage] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["model", "usage"]
        nullable_fields = ["model", "usage"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
