"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateCaptureAmountTypedDict(TypedDict):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCaptureAmount(BaseModel):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCaptureMetadata2TypedDict(TypedDict):
    pass


class CreateCaptureMetadata2(BaseModel):
    pass


CreateCaptureMetadataTypedDict = TypeAliasType(
    "CreateCaptureMetadataTypedDict",
    Union[CreateCaptureMetadata2TypedDict, str, List[Any]],
)


CreateCaptureMetadata = TypeAliasType(
    "CreateCaptureMetadata", Union[CreateCaptureMetadata2, str, List[Any]]
)


class CreateCaptureRequestBodyTypedDict(TypedDict):
    description: NotRequired[str]
    r"""The description of the capture."""
    amount: NotRequired[Nullable[CreateCaptureAmountTypedDict]]
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""
    metadata: NotRequired[Nullable[CreateCaptureMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class CreateCaptureRequestBody(BaseModel):
    description: Optional[str] = None
    r"""The description of the capture."""

    amount: OptionalNullable[CreateCaptureAmount] = UNSET
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    metadata: OptionalNullable[CreateCaptureMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "amount", "metadata"]
        nullable_fields = ["amount", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateCaptureRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    request_body: NotRequired[CreateCaptureRequestBodyTypedDict]


class CreateCaptureRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    request_body: Annotated[
        Optional[CreateCaptureRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateCaptureCapturesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateCaptureCapturesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateCaptureCapturesLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateCaptureCapturesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateCaptureCapturesLinks(BaseModel):
    documentation: Optional[CreateCaptureCapturesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateCaptureCapturesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreateCaptureCapturesLinks], pydantic.Field(alias="_links")
    ] = None


class CreateCaptureCapturesResponseBody(Exception):
    r"""An error response object."""

    data: CreateCaptureCapturesResponseBodyData

    def __init__(self, data: CreateCaptureCapturesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateCaptureCapturesResponseBodyData)


class CreateCaptureDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateCaptureDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateCaptureLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateCaptureDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateCaptureLinks(BaseModel):
    documentation: Optional[CreateCaptureDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateCaptureResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[CreateCaptureLinks], pydantic.Field(alias="_links")] = (
        None
    )


class CreateCaptureResponseBody(Exception):
    r"""An error response object."""

    data: CreateCaptureResponseBodyData

    def __init__(self, data: CreateCaptureResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateCaptureResponseBodyData)
