"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateOrderRefundAmountTypedDict(TypedDict):
    r"""The amount that you want to refund. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are partially refunding an order line which has a non-zero `discountAmount`.

    The amount you can refund depends on various properties of the order line and the create order refund request. The maximum that can be refunded is `unit price x quantity to ship`.

    The minimum amount depends on the discount applied to the line, the quantity already refunded or shipped, the amounts already refunded or shipped and the quantity you want to refund.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically. The error will contain the `extra.minimumAmount` and `extra.maximumAmount` properties that allow you pick the right amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundAmount(BaseModel):
    r"""The amount that you want to refund. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are partially refunding an order line which has a non-zero `discountAmount`.

    The amount you can refund depends on various properties of the order line and the create order refund request. The maximum that can be refunded is `unit price x quantity to ship`.

    The minimum amount depends on the discount applied to the line, the quantity already refunded or shipped, the amounts already refunded or shipped and the quantity you want to refund.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically. The error will contain the `extra.minimumAmount` and `extra.maximumAmount` properties that allow you pick the right amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundLinesTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The ID of the order line you wish to refund. For example: `odl_jp31jz`."""
    quantity: NotRequired[int]
    r"""The number of items that should be refunded for this order line. When this parameter is omitted, the whole order line will be refunded.

    Must be less than the number of items already refunded for this order line.
    """
    amount: NotRequired[CreateOrderRefundAmountTypedDict]
    r"""The amount that you want to refund. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are partially refunding an order line which has a non-zero `discountAmount`.

    The amount you can refund depends on various properties of the order line and the create order refund request. The maximum that can be refunded is `unit price x quantity to ship`.

    The minimum amount depends on the discount applied to the line, the quantity already refunded or shipped, the amounts already refunded or shipped and the quantity you want to refund.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically. The error will contain the `extra.minimumAmount` and `extra.maximumAmount` properties that allow you pick the right amount.
    """


class CreateOrderRefundLines(BaseModel):
    id: Optional[str] = None
    r"""The ID of the order line you wish to refund. For example: `odl_jp31jz`."""

    quantity: Optional[int] = None
    r"""The number of items that should be refunded for this order line. When this parameter is omitted, the whole order line will be refunded.

    Must be less than the number of items already refunded for this order line.
    """

    amount: Optional[CreateOrderRefundAmount] = None
    r"""The amount that you want to refund. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are partially refunding an order line which has a non-zero `discountAmount`.

    The amount you can refund depends on various properties of the order line and the create order refund request. The maximum that can be refunded is `unit price x quantity to ship`.

    The minimum amount depends on the discount applied to the line, the quantity already refunded or shipped, the amounts already refunded or shipped and the quantity you want to refund.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically. The error will contain the `extra.minimumAmount` and `extra.maximumAmount` properties that allow you pick the right amount.
    """


class CreateOrderRefundMetadata2TypedDict(TypedDict):
    pass


class CreateOrderRefundMetadata2(BaseModel):
    pass


CreateOrderRefundMetadataTypedDict = TypeAliasType(
    "CreateOrderRefundMetadataTypedDict",
    Union[CreateOrderRefundMetadata2TypedDict, str, List[Any]],
)


CreateOrderRefundMetadata = TypeAliasType(
    "CreateOrderRefundMetadata", Union[CreateOrderRefundMetadata2, str, List[Any]]
)


class CreateOrderRefundRequestBodyTypedDict(TypedDict):
    lines: List[CreateOrderRefundLinesTypedDict]
    r"""A refund can optionally be linked to specific order lines.

    The lines will show the `quantity`, `discountAmount`, `vatAmount`, and `totalAmount` refunded. If the line was partially refunded, these values will be different from the values in response from the [Get payment](get-payment) endpoint.
    """
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    metadata: NotRequired[Nullable[CreateOrderRefundMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """


class CreateOrderRefundRequestBody(BaseModel):
    lines: List[CreateOrderRefundLines]
    r"""A refund can optionally be linked to specific order lines.

    The lines will show the `quantity`, `discountAmount`, `vatAmount`, and `totalAmount` refunded. If the line was partially refunded, these values will be different from the values in response from the [Get payment](get-payment) endpoint.
    """

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    metadata: OptionalNullable[CreateOrderRefundMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    testmode: OptionalNullable[bool] = False
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "metadata", "testmode"]
        nullable_fields = ["metadata", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateOrderRefundRequestTypedDict(TypedDict):
    order_id: str
    r"""Provide the ID of the related order."""
    request_body: NotRequired[CreateOrderRefundRequestBodyTypedDict]


class CreateOrderRefundRequest(BaseModel):
    order_id: Annotated[
        str,
        pydantic.Field(alias="orderId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related order."""

    request_body: Annotated[
        Optional[CreateOrderRefundRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateOrderRefundRefundsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateOrderRefundRefundsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateOrderRefundRefundsResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateOrderRefundRefundsResponseDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateOrderRefundRefundsResponseLinks(BaseModel):
    documentation: Optional[CreateOrderRefundRefundsResponseDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateOrderRefundRefundsResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreateOrderRefundRefundsResponseLinks], pydantic.Field(alias="_links")
    ] = None


class CreateOrderRefundRefundsResponseResponseBody(Exception):
    r"""An error response object."""

    data: CreateOrderRefundRefundsResponseResponseBodyData

    def __init__(self, data: CreateOrderRefundRefundsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, CreateOrderRefundRefundsResponseResponseBodyData
        )


class CreateOrderRefundRefundsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateOrderRefundRefundsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateOrderRefundRefundsLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateOrderRefundRefundsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateOrderRefundRefundsLinks(BaseModel):
    documentation: Optional[CreateOrderRefundRefundsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateOrderRefundRefundsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreateOrderRefundRefundsLinks], pydantic.Field(alias="_links")
    ] = None


class CreateOrderRefundRefundsResponseBody(Exception):
    r"""An error response object."""

    data: CreateOrderRefundRefundsResponseBodyData

    def __init__(self, data: CreateOrderRefundRefundsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateOrderRefundRefundsResponseBodyData)


class CreateOrderRefundUnitPriceTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundUnitPrice(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundTotalAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundTotalAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundLinesOutputTypedDict(TypedDict):
    resource: NotRequired[str]
    id: NotRequired[str]
    r"""The ID of the order line you wish to refund. For example: `odl_jp31jz`."""
    order_id: NotRequired[str]
    quantity: NotRequired[int]
    r"""The number of items that should be refunded for this order line. When this parameter is omitted, the whole order line will be refunded.

    Must be less than the number of items already refunded for this order line.
    """
    unit_price: NotRequired[CreateOrderRefundUnitPriceTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_amount: NotRequired[CreateOrderRefundTotalAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class CreateOrderRefundLinesOutput(BaseModel):
    resource: Optional[str] = None

    id: Optional[str] = None
    r"""The ID of the order line you wish to refund. For example: `odl_jp31jz`."""

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None

    quantity: Optional[int] = None
    r"""The number of items that should be refunded for this order line. When this parameter is omitted, the whole order line will be refunded.

    Must be less than the number of items already refunded for this order line.
    """

    unit_price: Annotated[
        Optional[CreateOrderRefundUnitPrice], pydantic.Field(alias="unitPrice")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_amount: Annotated[
        Optional[CreateOrderRefundTotalAmount], pydantic.Field(alias="totalAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class CreateOrderRefundMetadataRefunds2TypedDict(TypedDict):
    pass


class CreateOrderRefundMetadataRefunds2(BaseModel):
    pass


CreateOrderRefundRefundsMetadataTypedDict = TypeAliasType(
    "CreateOrderRefundRefundsMetadataTypedDict",
    Union[CreateOrderRefundMetadataRefunds2TypedDict, str, List[Any]],
)


CreateOrderRefundRefundsMetadata = TypeAliasType(
    "CreateOrderRefundRefundsMetadata",
    Union[CreateOrderRefundMetadataRefunds2, str, List[Any]],
)


class CreateOrderRefundSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundOrderTypedDict(TypedDict):
    r"""The API resource URL of the [order](get-order) that this refund belongs to, if applicable."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundOrder(BaseModel):
    r"""The API resource URL of the [order](get-order) that this refund belongs to, if applicable."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[CreateOrderRefundSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    order: NotRequired[CreateOrderRefundOrderTypedDict]
    r"""The API resource URL of the [order](get-order) that this refund belongs to, if applicable."""
    settlement: NotRequired[Nullable[CreateOrderRefundSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""
    documentation: NotRequired[CreateOrderRefundDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateOrderRefundLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[CreateOrderRefundSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    order: Optional[CreateOrderRefundOrder] = None
    r"""The API resource URL of the [order](get-order) that this refund belongs to, if applicable."""

    settlement: OptionalNullable[CreateOrderRefundSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    documentation: Optional[CreateOrderRefundDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "order", "settlement", "documentation"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateOrderRefundResponseBodyTypedDict(TypedDict):
    r"""The newly created refund object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie will always refer to the refund by this ID. Example: `re_4qqhO89gsT`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    lines: NotRequired[List[CreateOrderRefundLinesOutputTypedDict]]
    r"""A refund can optionally be linked to specific order lines.

    The lines will show the `quantity`, `discountAmount`, `vatAmount`, and `totalAmount` refunded. If the line was partially refunded, these values will be different from the values in response from the [Get payment](get-payment) endpoint.
    """
    metadata: NotRequired[Nullable[CreateOrderRefundRefundsMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    order_id: NotRequired[str]
    r"""The unique identifier of the order this refund was created for. For example: `ord_8wmqcHMN4U`. Not present if the refund was not created for an order."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this refund was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the refund is not settled (yet)."""
    status: NotRequired[str]
    r"""Refunds may take some time to get confirmed. For a full overview of possible states, see the guide on refund statuses."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[CreateOrderRefundLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class CreateOrderRefundResponseBody(BaseModel):
    r"""The newly created refund object."""

    resource: Optional[str] = "refund"
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie will always refer to the refund by this ID. Example: `re_4qqhO89gsT`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    lines: Optional[List[CreateOrderRefundLinesOutput]] = None
    r"""A refund can optionally be linked to specific order lines.

    The lines will show the `quantity`, `discountAmount`, `vatAmount`, and `totalAmount` refunded. If the line was partially refunded, these values will be different from the values in response from the [Get payment](get-payment) endpoint.
    """

    metadata: OptionalNullable[CreateOrderRefundRefundsMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None
    r"""The unique identifier of the order this refund was created for. For example: `ord_8wmqcHMN4U`. Not present if the refund was not created for an order."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this refund was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the refund is not settled (yet)."""

    status: Optional[str] = None
    r"""Refunds may take some time to get confirmed. For a full overview of possible states, see the guide on refund statuses."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[CreateOrderRefundLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "description",
            "lines",
            "metadata",
            "orderId",
            "settlementId",
            "status",
            "createdAt",
            "_links",
        ]
        nullable_fields = ["metadata", "settlementId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
