"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreatePaymentLinkAmountTypedDict(TypedDict):
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentLinkAmount(BaseModel):
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentLinkRequestBodyTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the customer's bank or card statement when possible."""
    amount: NotRequired[Nullable[CreatePaymentLinkAmountTypedDict]]
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an amount."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided, the customer will be shown a generic message after completing the payment."""
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    reusable: NotRequired[Nullable[bool]]
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """
    expires_at: NotRequired[Nullable[str]]
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front, the payment link will not expire automatically."""
    allowed_methods: NotRequired[Nullable[List[Any]]]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is not provided or is an empty array, all enabled payment methods will be available.

    Possible values: `applepay` `bancomatpay` `bancontact` `banktransfer` `belfius` `blik` `creditcard` `eps` `giftcard` `ideal` `kbc` `mybank` `paybybank` `paypal` `paysafecard` `pointofsale` `przelewy24` `satispay` `trustly` `twint`
    """


class CreatePaymentLinkRequestBody(BaseModel):
    description: Optional[str] = None
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the customer's bank or card statement when possible."""

    amount: OptionalNullable[CreatePaymentLinkAmount] = UNSET
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an amount."""

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided, the customer will be shown a generic message after completing the payment."""

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """

    profile_id: Annotated[OptionalNullable[str], pydantic.Field(alias="profileId")] = (
        UNSET
    )
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    reusable: OptionalNullable[bool] = False
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front, the payment link will not expire automatically."""

    allowed_methods: Annotated[
        OptionalNullable[List[Any]], pydantic.Field(alias="allowedMethods")
    ] = UNSET
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is not provided or is an empty array, all enabled payment methods will be available.

    Possible values: `applepay` `bancomatpay` `bancontact` `banktransfer` `belfius` `blik` `creditcard` `eps` `giftcard` `ideal` `kbc` `mybank` `paybybank` `paypal` `paysafecard` `pointofsale` `przelewy24` `satispay` `trustly` `twint`
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "amount",
            "redirectUrl",
            "webhookUrl",
            "profileId",
            "reusable",
            "expiresAt",
            "allowedMethods",
        ]
        nullable_fields = [
            "amount",
            "redirectUrl",
            "webhookUrl",
            "profileId",
            "reusable",
            "expiresAt",
            "allowedMethods",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentLinkPaymentLinksDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreatePaymentLinkPaymentLinksDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreatePaymentLinkPaymentLinksLinksTypedDict(TypedDict):
    documentation: NotRequired[CreatePaymentLinkPaymentLinksDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentLinkPaymentLinksLinks(BaseModel):
    documentation: Optional[CreatePaymentLinkPaymentLinksDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentLinkPaymentLinksResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreatePaymentLinkPaymentLinksLinks], pydantic.Field(alias="_links")
    ] = None


class CreatePaymentLinkPaymentLinksResponseBody(Exception):
    r"""An error response object."""

    data: CreatePaymentLinkPaymentLinksResponseBodyData

    def __init__(self, data: CreatePaymentLinkPaymentLinksResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, CreatePaymentLinkPaymentLinksResponseBodyData
        )


class CreatePaymentLinkDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreatePaymentLinkDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreatePaymentLinkLinksTypedDict(TypedDict):
    documentation: NotRequired[CreatePaymentLinkDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentLinkLinks(BaseModel):
    documentation: Optional[CreatePaymentLinkDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentLinkResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreatePaymentLinkLinks], pydantic.Field(alias="_links")
    ] = None


class CreatePaymentLinkResponseBody(Exception):
    r"""An error response object."""

    data: CreatePaymentLinkResponseBodyData

    def __init__(self, data: CreatePaymentLinkResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreatePaymentLinkResponseBodyData)
