"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreatePaymentAmountTypedDict(TypedDict):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmount(BaseModel):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentUnitPriceTypedDict(TypedDict):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentUnitPrice(BaseModel):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentDiscountAmountTypedDict(TypedDict):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentDiscountAmount(BaseModel):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentPaymentsAmountTypedDict(TypedDict):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentPaymentsAmount(BaseModel):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RecurringTypedDict(TypedDict):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... months` `... weeks` `... days`
    """
    description: NotRequired[str]
    r"""A description of the recurring item. If not present, the main description of the item will be used."""
    amount: NotRequired[CreatePaymentPaymentsAmountTypedDict]
    r"""Total amount and currency of the recurring item."""
    times: NotRequired[int]
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""
    start_date: NotRequired[Nullable[str]]
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""


class Recurring(BaseModel):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... months` `... weeks` `... days`
    """

    description: Optional[str] = None
    r"""A description of the recurring item. If not present, the main description of the item will be used."""

    amount: Optional[CreatePaymentPaymentsAmount] = None
    r"""Total amount and currency of the recurring item."""

    times: Optional[int] = None
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""

    start_date: Annotated[OptionalNullable[str], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "amount", "times", "startDate"]
        nullable_fields = ["startDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentTotalAmountTypedDict(TypedDict):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentTotalAmount(BaseModel):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentVatAmountTypedDict(TypedDict):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentVatAmount(BaseModel):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentLinesTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: CreatePaymentUnitPriceTypedDict
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """
    total_amount: CreatePaymentTotalAmountTypedDict
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """
    type: NotRequired[str]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.

    Possible values: `physical` `digital` `shipping_fee` `discount` `store_credit` `gift_card` `surcharge` `tip` (default: `physical`)
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[CreatePaymentDiscountAmountTypedDict]
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""
    recurring: NotRequired[RecurringTypedDict]
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and not as a float, to ensure the correct number of decimals are passed."""
    vat_amount: NotRequired[CreatePaymentVatAmountTypedDict]
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[Any]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the [Integrating Vouchers](integrating-vouchers) guide for more information.

    Possible values: `meal` `eco` `gift` `sport_culture`
    """
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""


class CreatePaymentLines(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[CreatePaymentUnitPrice, pydantic.Field(alias="unitPrice")]
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    total_amount: Annotated[
        CreatePaymentTotalAmount, pydantic.Field(alias="totalAmount")
    ]
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    type: Optional[str] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.

    Possible values: `physical` `digital` `shipping_fee` `discount` `store_credit` `gift_card` `surcharge` `tip` (default: `physical`)
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[CreatePaymentDiscountAmount], pydantic.Field(alias="discountAmount")
    ] = None
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    recurring: Optional[Recurring] = None
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and not as a float, to ensure the correct number of decimals are passed."""

    vat_amount: Annotated[
        Optional[CreatePaymentVatAmount], pydantic.Field(alias="vatAmount")
    ] = None
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[Any]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the [Integrating Vouchers](integrating-vouchers) guide for more information.

    Possible values: `meal` `eco` `gift` `sport_culture`
    """

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""


class CreatePaymentBillingAddressTypedDict(TypedDict):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment method `in3`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment method `in3`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment method `in3`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment method `in3`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment method `in3`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment method `in3`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment method `in3`.
    """


class CreatePaymentBillingAddress(BaseModel):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment method `in3`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment method `in3`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment method `in3`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment method `in3`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment method `in3`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment method `in3`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment method `in3`.
    """


class CreatePaymentShippingAddressTypedDict(TypedDict):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers."""
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers."""
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number."""
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system."""
    email: NotRequired[str]
    r"""A valid e-mail address."""
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name."""
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class CreatePaymentShippingAddress(BaseModel):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers."""

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers."""

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number."""

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system."""

    email: Optional[str] = None
    r"""A valid e-mail address."""

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name."""

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class CreatePaymentMetadata2TypedDict(TypedDict):
    pass


class CreatePaymentMetadata2(BaseModel):
    pass


CreatePaymentMetadataTypedDict = TypeAliasType(
    "CreatePaymentMetadataTypedDict",
    Union[CreatePaymentMetadata2TypedDict, str, List[Any]],
)


CreatePaymentMetadata = TypeAliasType(
    "CreatePaymentMetadata", Union[CreatePaymentMetadata2, str, List[Any]]
)


class CreatePaymentPaymentsRequestAmountTypedDict(TypedDict):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentPaymentsRequestAmount(BaseModel):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    amount: NotRequired[CreatePaymentPaymentsRequestAmountTypedDict]
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """
    description: NotRequired[str]
    r"""The description of the application fee. This will appear on settlement reports towards both you and the connected merchant."""


class ApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    amount: Optional[CreatePaymentPaymentsRequestAmount] = None
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    description: Optional[str] = None
    r"""The description of the application fee. This will appear on settlement reports towards both you and the connected merchant."""


class CreatePaymentPaymentsRequestRequestBodyAmountTypedDict(TypedDict):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentPaymentsRequestRequestBodyAmount(BaseModel):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class DestinationTypedDict(TypedDict):
    r"""The destination of this portion of the payment."""

    type: NotRequired[str]
    r"""The type of destination. Currently only the destination type `organization` is supported.

    Possible values: `organization`
    """
    organization_id: NotRequired[str]
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be routed to."""


class Destination(BaseModel):
    r"""The destination of this portion of the payment."""

    type: Optional[str] = None
    r"""The type of destination. Currently only the destination type `organization` is supported.

    Possible values: `organization`
    """

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be routed to."""


class RoutingTypedDict(TypedDict):
    amount: NotRequired[CreatePaymentPaymentsRequestRequestBodyAmountTypedDict]
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""
    destination: NotRequired[DestinationTypedDict]
    r"""The destination of this portion of the payment."""
    release_date: NotRequired[Nullable[str]]
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """


class Routing(BaseModel):
    amount: Optional[CreatePaymentPaymentsRequestRequestBodyAmount] = None
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    destination: Optional[Destination] = None
    r"""The destination of this portion of the payment."""

    release_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="releaseDate")
    ] = UNSET
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "destination", "releaseDate"]
        nullable_fields = ["releaseDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentRequestBodyTypedDict(TypedDict):
    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible. We truncate the description automatically according to the limits of the used payment method. The description is also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office. This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255 characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """
    amount: CreatePaymentAmountTypedDict
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """
    redirect_url: Nullable[str]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """
    lines: NotRequired[Nullable[List[CreatePaymentLinesTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment method `voucher`.
    """
    billing_address: NotRequired[CreatePaymentBillingAddressTypedDict]
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`.
    """
    shipping_address: NotRequired[CreatePaymentShippingAddressTypedDict]
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """
    locale: NotRequired[Nullable[str]]
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897 locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the customer use a local bank account greatly increases the conversion and speed of payment.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `fr_FR` `fr_BE` `de_DE` `de_AT` `de_CH` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """
    method: NotRequired[Nullable[str]]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment method and your customer will skip the selection screen and is sent directly to the chosen payment method. The parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen but will only show the methods specified in the array. For example, you can use this functionality to only show payment methods from a specific country to your customer `['bancontact', 'belfius']`.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `mbway` `multibanco` `mybank` `payconiq` `paypal` `paysafecard` `pointofsale` `przelewy24` `satispay` `trustly` `twint` `voucher`
    """
    issuer: NotRequired[Nullable[str]]
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """
    metadata: NotRequired[Nullable[CreatePaymentMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    capture_mode: NotRequired[Nullable[str]]
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    By default, the customer's card or bank account is immediately charged when they complete the payment.

    Some payment methods also allow placing a hold on the card or bank account. This hold or 'authorization' can then at a later point either be 'captured' or canceled.

    To enable this way of working, set the capture mode to `manual` and capture the payment manually using the [Create capture endpoint](create-capture).

    Possible values: `automatic` `manual` (default: `automatic`)
    """
    capture_delay: NotRequired[Nullable[str]]
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """
    application_fee: NotRequired[ApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """
    routing: NotRequired[Nullable[List[RoutingTypedDict]]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee` parameter.
    """
    sequence_type: NotRequired[Nullable[str]]
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account are set up correctly for recurring payments.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of the customer's accounts should be credited.
    """
    customer_id: NotRequired[Nullable[str]]
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """


class CreatePaymentRequestBody(BaseModel):
    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible. We truncate the description automatically according to the limits of the used payment method. The description is also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office. This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255 characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """

    amount: CreatePaymentAmount
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    redirect_url: Annotated[Nullable[str], pydantic.Field(alias="redirectUrl")]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """

    lines: OptionalNullable[List[CreatePaymentLines]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment method `voucher`.
    """

    billing_address: Annotated[
        Optional[CreatePaymentBillingAddress], pydantic.Field(alias="billingAddress")
    ] = None
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`.
    """

    shipping_address: Annotated[
        Optional[CreatePaymentShippingAddress], pydantic.Field(alias="shippingAddress")
    ] = None
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    locale: OptionalNullable[str] = UNSET
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897 locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the customer use a local bank account greatly increases the conversion and speed of payment.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `fr_FR` `fr_BE` `de_DE` `de_AT` `de_CH` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """

    method: OptionalNullable[str] = UNSET
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment method and your customer will skip the selection screen and is sent directly to the chosen payment method. The parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen but will only show the methods specified in the array. For example, you can use this functionality to only show payment methods from a specific country to your customer `['bancontact', 'belfius']`.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `mbway` `multibanco` `mybank` `payconiq` `paypal` `paysafecard` `pointofsale` `przelewy24` `satispay` `trustly` `twint` `voucher`
    """

    issuer: OptionalNullable[str] = UNSET
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """

    metadata: OptionalNullable[CreatePaymentMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    capture_mode: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureMode")
    ] = UNSET
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    By default, the customer's card or bank account is immediately charged when they complete the payment.

    Some payment methods also allow placing a hold on the card or bank account. This hold or 'authorization' can then at a later point either be 'captured' or canceled.

    To enable this way of working, set the capture mode to `manual` and capture the payment manually using the [Create capture endpoint](create-capture).

    Possible values: `automatic` `manual` (default: `automatic`)
    """

    capture_delay: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureDelay")
    ] = UNSET
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """

    application_fee: Annotated[
        Optional[ApplicationFee], pydantic.Field(alias="applicationFee")
    ] = None
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    routing: OptionalNullable[List[Routing]] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee` parameter.
    """

    sequence_type: Annotated[
        OptionalNullable[str], pydantic.Field(alias="sequenceType")
    ] = UNSET
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account are set up correctly for recurring payments.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of the customer's accounts should be credited.
    """

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """

    profile_id: Annotated[OptionalNullable[str], pydantic.Field(alias="profileId")] = (
        UNSET
    )
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    testmode: OptionalNullable[bool] = False
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cancelUrl",
            "webhookUrl",
            "lines",
            "billingAddress",
            "shippingAddress",
            "locale",
            "method",
            "issuer",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "applicationFee",
            "routing",
            "sequenceType",
            "mandateId",
            "customerId",
            "profileId",
            "testmode",
        ]
        nullable_fields = [
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "locale",
            "method",
            "issuer",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "routing",
            "sequenceType",
            "mandateId",
            "customerId",
            "profileId",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentRequestTypedDict(TypedDict):
    include: NotRequired[Nullable[str]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `details.qrCode`: Include a QR code object. Only available for iDEAL, Bancontact and bank transfer payments.
    """
    request_body: NotRequired[CreatePaymentRequestBodyTypedDict]


class CreatePaymentRequest(BaseModel):
    include: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `details.qrCode`: Include a QR code object. Only available for iDEAL, Bancontact and bank transfer payments.
    """

    request_body: Annotated[
        Optional[CreatePaymentRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["include", "RequestBody"]
        nullable_fields = ["include"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentPaymentsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreatePaymentPaymentsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreatePaymentPaymentsLinksTypedDict(TypedDict):
    documentation: NotRequired[CreatePaymentPaymentsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentPaymentsLinks(BaseModel):
    documentation: Optional[CreatePaymentPaymentsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentPaymentsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreatePaymentPaymentsLinks], pydantic.Field(alias="_links")
    ] = None


class CreatePaymentPaymentsResponseBody(Exception):
    r"""An error response object."""

    data: CreatePaymentPaymentsResponseBodyData

    def __init__(self, data: CreatePaymentPaymentsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreatePaymentPaymentsResponseBodyData)


class CreatePaymentDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreatePaymentDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreatePaymentLinksTypedDict(TypedDict):
    documentation: NotRequired[CreatePaymentDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentLinks(BaseModel):
    documentation: Optional[CreatePaymentDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[CreatePaymentLinks], pydantic.Field(alias="_links")] = (
        None
    )


class CreatePaymentResponseBody(Exception):
    r"""An error response object."""

    data: CreatePaymentResponseBodyData

    def __init__(self, data: CreatePaymentResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreatePaymentResponseBodyData)
