"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateProfileRequestBodyTypedDict(TypedDict):
    name: str
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""
    website: str
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""
    email: str
    r"""The email address associated with the profile's trade name or brand."""
    phone: str
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[Nullable[str]]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[List[Any]]
    r"""A list of countries where you expect that the majority of the profile's customers reside, in ISO 3166-1 alpha-2 format."""
    business_category: NotRequired[str]
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types#business-category) for all possible options."""


class CreateProfileRequestBody(BaseModel):
    name: str
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""

    website: str
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""

    email: str
    r"""The email address associated with the profile's trade name or brand."""

    phone: str
    r"""The phone number associated with the profile's trade name or brand."""

    description: OptionalNullable[str] = UNSET
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        Optional[List[Any]], pydantic.Field(alias="countriesOfActivity")
    ] = None
    r"""A list of countries where you expect that the majority of the profile's customers reside, in ISO 3166-1 alpha-2 format."""

    business_category: Annotated[
        Optional[str], pydantic.Field(alias="businessCategory")
    ] = None
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types#business-category) for all possible options."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "countriesOfActivity", "businessCategory"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateProfileDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateProfileDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateProfileLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateProfileDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateProfileLinks(BaseModel):
    documentation: Optional[CreateProfileDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateProfileResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[CreateProfileLinks], pydantic.Field(alias="_links")] = (
        None
    )


class CreateProfileResponseBody(Exception):
    r"""An error response object."""

    data: CreateProfileResponseBodyData

    def __init__(self, data: CreateProfileResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateProfileResponseBodyData)
