"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Any, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateRefundAmountTypedDict(TypedDict):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundAmount(BaseModel):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundMetadata2TypedDict(TypedDict):
    pass


class CreateRefundMetadata2(BaseModel):
    pass


CreateRefundMetadataTypedDict = TypeAliasType(
    "CreateRefundMetadataTypedDict",
    Union[CreateRefundMetadata2TypedDict, str, List[Any]],
)


CreateRefundMetadata = TypeAliasType(
    "CreateRefundMetadata", Union[CreateRefundMetadata2, str, List[Any]]
)


class CreateRefundRefundsAmountTypedDict(TypedDict):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundRefundsAmount(BaseModel):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class SourceTypedDict(TypedDict):
    r"""Where the funds will be pulled back from."""

    type: NotRequired[str]
    r"""The type of source. Currently only the source type `organization` is supported.

    Possible values: `organization`
    """
    organization_id: NotRequired[str]
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled back from."""


class Source(BaseModel):
    r"""Where the funds will be pulled back from."""

    type: Optional[str] = None
    r"""The type of source. Currently only the source type `organization` is supported.

    Possible values: `organization`
    """

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled back from."""


class RoutingReversalsTypedDict(TypedDict):
    amount: NotRequired[CreateRefundRefundsAmountTypedDict]
    r"""The amount that will be pulled back."""
    source: NotRequired[SourceTypedDict]
    r"""Where the funds will be pulled back from."""


class RoutingReversals(BaseModel):
    amount: Optional[CreateRefundRefundsAmount] = None
    r"""The amount that will be pulled back."""

    source: Optional[Source] = None
    r"""Where the funds will be pulled back from."""


class CreateRefundRequestBodyTypedDict(TypedDict):
    amount: CreateRefundAmountTypedDict
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    metadata: NotRequired[Nullable[CreateRefundMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    reverse_routing: NotRequired[Nullable[bool]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants, by providing the `routing` object during [payment creation](create-payment).

    When creating refunds for these *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back the funds that were routed to the connected merchant(s), you can set this parameter to `true` when issuing a full refund.

    For more fine-grained control and for partial refunds, use the `routingReversals` parameter instead.
    """
    routing_reversals: NotRequired[Nullable[List[RoutingReversalsTypedDict]]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """


class CreateRefundRequestBody(BaseModel):
    amount: CreateRefundAmount
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    metadata: OptionalNullable[CreateRefundMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    reverse_routing: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="reverseRouting")
    ] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants, by providing the `routing` object during [payment creation](create-payment).

    When creating refunds for these *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back the funds that were routed to the connected merchant(s), you can set this parameter to `true` when issuing a full refund.

    For more fine-grained control and for partial refunds, use the `routingReversals` parameter instead.
    """

    routing_reversals: Annotated[
        OptionalNullable[List[RoutingReversals]],
        pydantic.Field(alias="routingReversals"),
    ] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """

    testmode: OptionalNullable[bool] = False
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "metadata",
            "reverseRouting",
            "routingReversals",
            "testmode",
        ]
        nullable_fields = ["metadata", "reverseRouting", "routingReversals", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateRefundRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    request_body: NotRequired[CreateRefundRequestBodyTypedDict]


class CreateRefundRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    request_body: Annotated[
        Optional[CreateRefundRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateRefundRefundsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateRefundRefundsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateRefundRefundsResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateRefundRefundsResponseDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundRefundsResponseLinks(BaseModel):
    documentation: Optional[CreateRefundRefundsResponseDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundRefundsResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreateRefundRefundsResponseLinks], pydantic.Field(alias="_links")
    ] = None


class CreateRefundRefundsResponseResponseBody(Exception):
    r"""An error response object."""

    data: CreateRefundRefundsResponseResponseBodyData

    def __init__(self, data: CreateRefundRefundsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, CreateRefundRefundsResponseResponseBodyData
        )


class CreateRefundRefundsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateRefundRefundsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateRefundRefundsLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateRefundRefundsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundRefundsLinks(BaseModel):
    documentation: Optional[CreateRefundRefundsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundRefundsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[CreateRefundRefundsLinks], pydantic.Field(alias="_links")
    ] = None


class CreateRefundRefundsResponseBody(Exception):
    r"""An error response object."""

    data: CreateRefundRefundsResponseBodyData

    def __init__(self, data: CreateRefundRefundsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateRefundRefundsResponseBodyData)


class CreateRefundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class CreateRefundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class CreateRefundLinksTypedDict(TypedDict):
    documentation: NotRequired[CreateRefundDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundLinks(BaseModel):
    documentation: Optional[CreateRefundDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[CreateRefundLinks], pydantic.Field(alias="_links")] = None


class CreateRefundResponseBody(Exception):
    r"""An error response object."""

    data: CreateRefundResponseBodyData

    def __init__(self, data: CreateRefundResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateRefundResponseBodyData)
