"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetBalanceRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetBalanceRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetBalanceBalancesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetBalanceBalancesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetBalanceBalancesLinksTypedDict(TypedDict):
    documentation: NotRequired[GetBalanceBalancesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceBalancesLinks(BaseModel):
    documentation: Optional[GetBalanceBalancesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceBalancesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetBalanceBalancesLinks], pydantic.Field(alias="_links")
    ] = None


class GetBalanceBalancesResponseBody(Exception):
    r"""An error response object."""

    data: GetBalanceBalancesResponseBodyData

    def __init__(self, data: GetBalanceBalancesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetBalanceBalancesResponseBodyData)


class TransferThresholdTypedDict(TypedDict):
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds this threshold, the complete balance will be paid out to the transfer destination according to the configured frequency."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TransferThreshold(BaseModel):
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds this threshold, the complete balance will be paid out to the transfer destination according to the configured frequency."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TransferDestinationTypedDict(TypedDict):
    r"""The destination where the available amount will be automatically transferred to according to the configured transfer frequency."""

    type: NotRequired[str]
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account

    Possible values: `bank-account`
    """
    bank_account: NotRequired[str]
    r"""The configured bank account number of the beneficiary the balance amount is to be transferred to."""
    beneficiary_name: NotRequired[str]
    r"""The full name of the beneficiary the balance amount is to be transferred to."""


class TransferDestination(BaseModel):
    r"""The destination where the available amount will be automatically transferred to according to the configured transfer frequency."""

    type: Optional[str] = None
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account

    Possible values: `bank-account`
    """

    bank_account: Annotated[Optional[str], pydantic.Field(alias="bankAccount")] = None
    r"""The configured bank account number of the beneficiary the balance amount is to be transferred to."""

    beneficiary_name: Annotated[
        Optional[str], pydantic.Field(alias="beneficiaryName")
    ] = None
    r"""The full name of the beneficiary the balance amount is to be transferred to."""


class AvailableAmountTypedDict(TypedDict):
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AvailableAmount(BaseModel):
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingAmountTypedDict(TypedDict):
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a few days to clear."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingAmount(BaseModel):
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a few days to clear."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetBalanceSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetBalanceSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[GetBalanceDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetBalanceLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetBalanceSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[GetBalanceDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetBalanceResponseBodyTypedDict(TypedDict):
    r"""The balance object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a balance object. Will always contain the string `balance` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this balance. Example: `bal_gVMhHKqSSRYJyPsuoPNFH`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    currency: NotRequired[str]
    r"""The balance's ISO 4217 currency code."""
    description: NotRequired[str]
    r"""The description or name of the balance. Can be used to denote the purpose of the balance."""
    status: NotRequired[str]
    r"""The status of the balance.

    * `active` — The balance is operational and ready to be used.
    * `inactive` — The account is being validated by our team, or the balance has been blocked. Contact us for more information.

    Possible values: `active` `inactive`
    """
    transfer_frequency: NotRequired[str]
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer destination.

    * `daily` — Every business day
    * `twice-a-week` — Every Tuesday and Friday
    * `every-monday` — Every Monday
    * `every-tuesday` — Every Tuesday
    * `every-wednesday` — Every Wednesday
    * `every-thursday` — Every Thursday
    * `every-friday` — Every Friday
    * `twice-a-month` — On the first and the fifteenth of the month
    * `monthly` — On the first of the month
    * `never` — Automatic settlements are paused for this balance

    Settlements created during weekends or on bank holidays will take place on the next business day.

    Possible values: `daily` `twice-a-week` `every-monday` `every-tuesday` `every-wednesday` `every-thursday` `every-friday` `twice-a-month` `monthly` `never`
    """
    transfer_threshold: NotRequired[TransferThresholdTypedDict]
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds this threshold, the complete balance will be paid out to the transfer destination according to the configured frequency."""
    transfer_reference: NotRequired[Nullable[str]]
    r"""The transfer reference set to be included in all the transfers for this balance."""
    transfer_destination: NotRequired[TransferDestinationTypedDict]
    r"""The destination where the available amount will be automatically transferred to according to the configured transfer frequency."""
    available_amount: NotRequired[AvailableAmountTypedDict]
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""
    pending_amount: NotRequired[PendingAmountTypedDict]
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a few days to clear."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetBalanceLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetBalanceResponseBody(BaseModel):
    r"""The balance object."""

    resource: Optional[str] = "balance"
    r"""Indicates the response contains a balance object. Will always contain the string `balance` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this balance. Example: `bal_gVMhHKqSSRYJyPsuoPNFH`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    currency: Optional[str] = None
    r"""The balance's ISO 4217 currency code."""

    description: Optional[str] = None
    r"""The description or name of the balance. Can be used to denote the purpose of the balance."""

    status: Optional[str] = None
    r"""The status of the balance.

    * `active` — The balance is operational and ready to be used.
    * `inactive` — The account is being validated by our team, or the balance has been blocked. Contact us for more information.

    Possible values: `active` `inactive`
    """

    transfer_frequency: Annotated[
        Optional[str], pydantic.Field(alias="transferFrequency")
    ] = None
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer destination.

    * `daily` — Every business day
    * `twice-a-week` — Every Tuesday and Friday
    * `every-monday` — Every Monday
    * `every-tuesday` — Every Tuesday
    * `every-wednesday` — Every Wednesday
    * `every-thursday` — Every Thursday
    * `every-friday` — Every Friday
    * `twice-a-month` — On the first and the fifteenth of the month
    * `monthly` — On the first of the month
    * `never` — Automatic settlements are paused for this balance

    Settlements created during weekends or on bank holidays will take place on the next business day.

    Possible values: `daily` `twice-a-week` `every-monday` `every-tuesday` `every-wednesday` `every-thursday` `every-friday` `twice-a-month` `monthly` `never`
    """

    transfer_threshold: Annotated[
        Optional[TransferThreshold], pydantic.Field(alias="transferThreshold")
    ] = None
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds this threshold, the complete balance will be paid out to the transfer destination according to the configured frequency."""

    transfer_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="transferReference")
    ] = UNSET
    r"""The transfer reference set to be included in all the transfers for this balance."""

    transfer_destination: Annotated[
        Optional[TransferDestination], pydantic.Field(alias="transferDestination")
    ] = None
    r"""The destination where the available amount will be automatically transferred to according to the configured transfer frequency."""

    available_amount: Annotated[
        Optional[AvailableAmount], pydantic.Field(alias="availableAmount")
    ] = None
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    pending_amount: Annotated[
        Optional[PendingAmount], pydantic.Field(alias="pendingAmount")
    ] = None
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a few days to clear."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[GetBalanceLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "currency",
            "description",
            "status",
            "transferFrequency",
            "transferThreshold",
            "transferReference",
            "transferDestination",
            "availableAmount",
            "pendingAmount",
            "createdAt",
            "_links",
        ]
        nullable_fields = ["transferReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
