"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetMethodRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    locale: NotRequired[str]
    r"""Passing a locale will translate the payment method name in the corresponding language.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """
    currency: NotRequired[str]
    r"""If provided, the `minimumAmount` and `maximumAmount` will be converted to the given currency. An error is returned if the currency is not supported by the payment method."""
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve the payment method for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    include: NotRequired[Nullable[str]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available.
    * `pricing`: Include pricing for the payment method.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetMethodRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    locale: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Passing a locale will translate the payment method name in the corresponding language.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """

    currency: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If provided, the `minimumAmount` and `maximumAmount` will be converted to the given currency. An error is returned if the currency is not supported by the payment method."""

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve the payment method for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    include: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available.
    * `pricing`: Include pricing for the payment method.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["locale", "currency", "profileId", "include", "testmode"]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetMethodMethodsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetMethodMethodsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetMethodMethodsResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[GetMethodMethodsResponseDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetMethodMethodsResponseLinks(BaseModel):
    documentation: Optional[GetMethodMethodsResponseDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetMethodMethodsResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetMethodMethodsResponseLinks], pydantic.Field(alias="_links")
    ] = None


class GetMethodMethodsResponseResponseBody(Exception):
    r"""An error response object."""

    data: GetMethodMethodsResponseResponseBodyData

    def __init__(self, data: GetMethodMethodsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetMethodMethodsResponseResponseBodyData)


class GetMethodMethodsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetMethodMethodsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetMethodMethodsLinksTypedDict(TypedDict):
    documentation: NotRequired[GetMethodMethodsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetMethodMethodsLinks(BaseModel):
    documentation: Optional[GetMethodMethodsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetMethodMethodsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetMethodMethodsLinks], pydantic.Field(alias="_links")
    ] = None


class GetMethodMethodsResponseBody(Exception):
    r"""An error response object."""

    data: GetMethodMethodsResponseBodyData

    def __init__(self, data: GetMethodMethodsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetMethodMethodsResponseBodyData)


class MinimumAmountTypedDict(TypedDict):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class MinimumAmount(BaseModel):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class MaximumAmountTypedDict(TypedDict):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class MaximumAmount(BaseModel):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class Image(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class FixedTypedDict(TypedDict):
    r"""The fixed price charged per payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class Fixed(BaseModel):
    r"""The fixed price charged per payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PricingTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a category of cards (`American Express`). If a `locale` is provided, the description may be translated."""
    fixed: NotRequired[FixedTypedDict]
    r"""The fixed price charged per payment."""
    variable: NotRequired[str]
    r"""The variable price charged per payment, as a percentage string."""
    fee_region: NotRequired[str]
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as returned in the [Payments API](get-payment)."""


class Pricing(BaseModel):
    description: Optional[str] = None
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a category of cards (`American Express`). If a `locale` is provided, the description may be translated."""

    fixed: Optional[Fixed] = None
    r"""The fixed price charged per payment."""

    variable: Optional[str] = None
    r"""The variable price charged per payment, as a percentage string."""

    fee_region: Annotated[Optional[str], pydantic.Field(alias="feeRegion")] = None
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as returned in the [Payments API](get-payment)."""


class GetMethodImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class GetMethodImage(BaseModel):
    r"""URLs of images representing the issuer."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class IssuersTypedDict(TypedDict):
    resource: NotRequired[str]
    id: NotRequired[str]
    name: NotRequired[str]
    r"""The full name of the issuer."""
    image: NotRequired[GetMethodImageTypedDict]
    r"""URLs of images representing the issuer."""


class Issuers(BaseModel):
    resource: Optional[str] = "issuer"

    id: Optional[str] = None

    name: Optional[str] = None
    r"""The full name of the issuer."""

    image: Optional[GetMethodImage] = None
    r"""URLs of images representing the issuer."""


class GetMethodSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetMethodSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetMethodDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetMethodDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetMethodLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetMethodSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[GetMethodDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetMethodLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetMethodSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[GetMethodDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetMethodResponseBodyTypedDict(TypedDict):
    r"""The payment method object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this endpoint."""
    id: NotRequired[str]
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment method selection screen will be skipped.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `trustly` `twint` `voucher`
    """
    description: NotRequired[str]
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: NotRequired[MinimumAmountTypedDict]
    r"""The minimum payment amount required to use this payment method."""
    maximum_amount: NotRequired[Nullable[MaximumAmountTypedDict]]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""
    image: NotRequired[ImageTypedDict]
    r"""URLs of images representing the payment method."""
    status: NotRequired[str]
    r"""The payment method's activation status for this profile.

    Possible values:
    * `activated`: The payment method is activated and ready for use.
    * `pending-boarding`: Mollie is waiting for you to finish onboarding in the Merchant Dashboard before the payment method can be activated.
    * `pending-review`: Mollie needs to review your request for this payment method before it can be activated.
    * `pending-external`: Activation of this payment method relies on you taking action with an external party, for example signing up with PayPal or a giftcard issuer.
    * `rejected`: Your request for this payment method was rejected. Whenever Mollie rejects such a request, you will always be informed via email.
    * `null`: This payment method was not requested.
    """
    pricing: NotRequired[List[PricingTypedDict]]
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on your account."""
    issuers: NotRequired[List[IssuersTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant for iDEAL, KBC/CBC, gift cards, and vouchers."""
    links: NotRequired[GetMethodLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetMethodResponseBody(BaseModel):
    r"""The payment method object."""

    resource: Optional[str] = "method"
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this endpoint."""

    id: Optional[str] = None
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment method selection screen will be skipped.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `trustly` `twint` `voucher`
    """

    description: Optional[str] = None
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[
        Optional[MinimumAmount], pydantic.Field(alias="minimumAmount")
    ] = None
    r"""The minimum payment amount required to use this payment method."""

    maximum_amount: Annotated[
        OptionalNullable[MaximumAmount], pydantic.Field(alias="maximumAmount")
    ] = UNSET
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    image: Optional[Image] = None
    r"""URLs of images representing the payment method."""

    status: Optional[str] = None
    r"""The payment method's activation status for this profile.

    Possible values:
    * `activated`: The payment method is activated and ready for use.
    * `pending-boarding`: Mollie is waiting for you to finish onboarding in the Merchant Dashboard before the payment method can be activated.
    * `pending-review`: Mollie needs to review your request for this payment method before it can be activated.
    * `pending-external`: Activation of this payment method relies on you taking action with an external party, for example signing up with PayPal or a giftcard issuer.
    * `rejected`: Your request for this payment method was rejected. Whenever Mollie rejects such a request, you will always be informed via email.
    * `null`: This payment method was not requested.
    """

    pricing: Optional[List[Pricing]] = None
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on your account."""

    issuers: Optional[List[Issuers]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant for iDEAL, KBC/CBC, gift cards, and vouchers."""

    links: Annotated[Optional[GetMethodLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "description",
            "minimumAmount",
            "maximumAmount",
            "image",
            "status",
            "pricing",
            "issuers",
            "_links",
        ]
        nullable_fields = ["maximumAmount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
