"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import FieldMetadata, PathParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentListRoutesRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""


class PaymentListRoutesRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""


class PaymentListRoutesDelayedRoutingDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class PaymentListRoutesDelayedRoutingDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class PaymentListRoutesDelayedRoutingLinksTypedDict(TypedDict):
    documentation: NotRequired[PaymentListRoutesDelayedRoutingDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class PaymentListRoutesDelayedRoutingLinks(BaseModel):
    documentation: Optional[PaymentListRoutesDelayedRoutingDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class PaymentListRoutesDelayedRoutingResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[PaymentListRoutesDelayedRoutingLinks], pydantic.Field(alias="_links")
    ] = None


class PaymentListRoutesDelayedRoutingResponseBody(Exception):
    r"""An error response object."""

    data: PaymentListRoutesDelayedRoutingResponseBodyData

    def __init__(self, data: PaymentListRoutesDelayedRoutingResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, PaymentListRoutesDelayedRoutingResponseBodyData
        )


class PaymentListRoutesAmountTypedDict(TypedDict):
    r"""The amount of the route. That amount that will be routed to the specified destination."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentListRoutesAmount(BaseModel):
    r"""The amount of the route. That amount that will be routed to the specified destination."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentListRoutesDestinationTypedDict(TypedDict):
    r"""The destination of the route."""

    type: NotRequired[str]
    r"""The type of destination. Currently only the destination type `organization` is supported.

    Possible values: `organization`
    """
    organization_id: NotRequired[str]
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be routed to."""


class PaymentListRoutesDestination(BaseModel):
    r"""The destination of the route."""

    type: Optional[str] = None
    r"""The type of destination. Currently only the destination type `organization` is supported.

    Possible values: `organization`
    """

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be routed to."""


class PaymentListRoutesDelayedRoutingSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesDelayedRoutingSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesDelayedRoutingResponseDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesDelayedRoutingResponseDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesDelayedRoutingResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[PaymentListRoutesDelayedRoutingSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[
        PaymentListRoutesDelayedRoutingResponseDocumentationTypedDict
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentListRoutesDelayedRoutingResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[PaymentListRoutesDelayedRoutingSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[PaymentListRoutesDelayedRoutingResponseDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RoutesTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this route. Mollie assigns this identifier at route creation time. Mollie will always refer to the route by this ID. Example: `crt_dyARQ3JzCgtPDhU2Pbq3J`."""
    payment_id: NotRequired[str]
    r"""The unique identifier of the payment. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""
    amount: NotRequired[PaymentListRoutesAmountTypedDict]
    r"""The amount of the route. That amount that will be routed to the specified destination."""
    description: NotRequired[str]
    r"""The description of the route. This description is shown in the reports."""
    destination: NotRequired[PaymentListRoutesDestinationTypedDict]
    r"""The destination of the route."""
    links: NotRequired[PaymentListRoutesDelayedRoutingResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class Routes(BaseModel):
    resource: Optional[str] = "route"
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this route. Mollie assigns this identifier at route creation time. Mollie will always refer to the route by this ID. Example: `crt_dyARQ3JzCgtPDhU2Pbq3J`."""

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None
    r"""The unique identifier of the payment. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""

    amount: Optional[PaymentListRoutesAmount] = None
    r"""The amount of the route. That amount that will be routed to the specified destination."""

    description: Optional[str] = None
    r"""The description of the route. This description is shown in the reports."""

    destination: Optional[PaymentListRoutesDestination] = None
    r"""The destination of the route."""

    links: Annotated[
        Optional[PaymentListRoutesDelayedRoutingResponseLinks],
        pydantic.Field(alias="_links"),
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class PaymentListRoutesEmbeddedTypedDict(TypedDict):
    routes: NotRequired[List[RoutesTypedDict]]
    r"""An array of route objects."""


class PaymentListRoutesEmbedded(BaseModel):
    routes: Optional[List[Routes]] = None
    r"""An array of route objects."""


class PaymentListRoutesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[PaymentListRoutesSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[PaymentListRoutesPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[PaymentListRoutesNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[PaymentListRoutesDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentListRoutesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[PaymentListRoutesSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""The URL to the current set of items."""

    previous: OptionalNullable[PaymentListRoutesPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[PaymentListRoutesNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[PaymentListRoutesDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentListRoutesResponseBodyTypedDict(TypedDict):
    r"""A list of route objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[PaymentListRoutesEmbeddedTypedDict]
    links: NotRequired[PaymentListRoutesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class PaymentListRoutesResponseBody(BaseModel):
    r"""A list of route objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[PaymentListRoutesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[PaymentListRoutesLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
