"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from mollie_api_python_alpha import models, utils
from mollie_api_python_alpha._hooks import HookContext
from mollie_api_python_alpha.types import OptionalNullable, UNSET
from mollie_api_python_alpha.utils import get_security_from_env
from typing import Any, List, Mapping, Optional, Union


class Orders(BaseSDK):
    def create(
        self,
        *,
        embed: OptionalNullable[str] = UNSET,
        request_body: Optional[
            Union[models.CreateOrderRequestBody, models.CreateOrderRequestBodyTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Create order

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        When creating an order, a payment will automatically be created to allow your customer to pay for the order. You can then redirect your customer to the URL in the `_links.checkout` property from the response, similar to the Payments API.

        Unlike the Payments API, if a payment fails, expires, or is canceled, you can create a new payment under the same order using the [Create order payment endpoint](create-order-payment). This is only possible for orders that still have the `created` status.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param embed: This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.  * `payments`: Include all payments created for this order.
        :param request_body:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateOrderRequest(
            embed=embed,
            request_body=utils.get_pydantic_model(
                request_body, Optional[models.CreateOrderRequestBody]
            ),
        )

        req = self._build_request(
            method="POST",
            path="/orders",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CreateOrderRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create-order",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CreateOrderResponseBodyData
            )
            raise models.CreateOrderResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_async(
        self,
        *,
        embed: OptionalNullable[str] = UNSET,
        request_body: Optional[
            Union[models.CreateOrderRequestBody, models.CreateOrderRequestBodyTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Create order

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        When creating an order, a payment will automatically be created to allow your customer to pay for the order. You can then redirect your customer to the URL in the `_links.checkout` property from the response, similar to the Payments API.

        Unlike the Payments API, if a payment fails, expires, or is canceled, you can create a new payment under the same order using the [Create order payment endpoint](create-order-payment). This is only possible for orders that still have the `created` status.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param embed: This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.  * `payments`: Include all payments created for this order.
        :param request_body:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateOrderRequest(
            embed=embed,
            request_body=utils.get_pydantic_model(
                request_body, Optional[models.CreateOrderRequestBody]
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/orders",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CreateOrderRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create-order",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CreateOrderResponseBodyData
            )
            raise models.CreateOrderResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def list(
        self,
        *,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        profile_id: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListOrdersResponseBody:
        r"""List orders

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Retrieve all orders.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.read**](/reference/authentication)

        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve orders for.  Most API credentials are linked to a single profile. In these cases the `profileId` is already implied.  To retrieve all orders across the organization, use an organization-level API credential and omit the `profileId` parameter.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListOrdersRequest(
            from_=from_,
            limit=limit,
            sort=sort,
            profile_id=profile_id,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/orders",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list-orders",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.ListOrdersResponseBody)
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListOrdersOrdersResponseBodyData
            )
            raise models.ListOrdersOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_async(
        self,
        *,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        profile_id: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListOrdersResponseBody:
        r"""List orders

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Retrieve all orders.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.read**](/reference/authentication)

        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param profile_id: The identifier referring to the [profile](get-profile) you wish to retrieve orders for.  Most API credentials are linked to a single profile. In these cases the `profileId` is already implied.  To retrieve all orders across the organization, use an organization-level API credential and omit the `profileId` parameter.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListOrdersRequest(
            from_=from_,
            limit=limit,
            sort=sort,
            profile_id=profile_id,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/orders",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list-orders",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.ListOrdersResponseBody)
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListOrdersOrdersResponseBodyData
            )
            raise models.ListOrdersOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get(
        self,
        *,
        id: str,
        embed: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetOrderResponseBody:
        r"""Get order

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Retrieve a single order object by its ID.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.read**](/reference/authentication)

        :param id: Provide the ID of the item you want to perform this operation on.
        :param embed: This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.  * `payments`: Include all payments created for this order. * `refunds`: Include all refunds created for this order. * `shipments`: Include all shipments created for this order.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetOrderRequest(
            id=id,
            embed=embed,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/orders/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="get-order",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.GetOrderResponseBody)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.GetOrderOrdersResponseBodyData
            )
            raise models.GetOrderOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_async(
        self,
        *,
        id: str,
        embed: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetOrderResponseBody:
        r"""Get order

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Retrieve a single order object by its ID.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.read**](/reference/authentication)

        :param id: Provide the ID of the item you want to perform this operation on.
        :param embed: This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.  * `payments`: Include all payments created for this order. * `refunds`: Include all refunds created for this order. * `shipments`: Include all shipments created for this order.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetOrderRequest(
            id=id,
            embed=embed,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/orders/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="get-order",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.GetOrderResponseBody)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.GetOrderOrdersResponseBodyData
            )
            raise models.GetOrderOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def update(
        self,
        *,
        id: str,
        order_number: OptionalNullable[str] = UNSET,
        redirect_url: OptionalNullable[str] = UNSET,
        cancel_url: OptionalNullable[str] = UNSET,
        webhook_url: OptionalNullable[str] = UNSET,
        billing_address: OptionalNullable[
            Union[
                models.UpdateOrderBillingAddress,
                models.UpdateOrderBillingAddressTypedDict,
            ]
        ] = UNSET,
        shipping_address: OptionalNullable[
            Union[
                models.UpdateOrderShippingAddress,
                models.UpdateOrderShippingAddressTypedDict,
            ]
        ] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Update order

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Certain details of an existing order can be updated.

        For an in-depth explanation of each parameter, see [Create order](create-order).

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param id: Provide the ID of the item you want to perform this operation on.
        :param order_number:
        :param redirect_url: Can be updated while the order is not yet finalized.
        :param cancel_url: Can be updated while the order is not yet finalized.
        :param webhook_url:
        :param billing_address: If a payment method has already been selected, the original shipping address may have already been forwarded to the payment method provider.
        :param shipping_address: If a payment method has already been selected, the original billing address may have already been forwarded to the payment method provider.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateOrderRequest(
            id=id,
            request_body=models.UpdateOrderRequestBody(
                order_number=order_number,
                redirect_url=redirect_url,
                cancel_url=cancel_url,
                webhook_url=webhook_url,
                billing_address=utils.get_pydantic_model(
                    billing_address, OptionalNullable[models.UpdateOrderBillingAddress]
                ),
                shipping_address=utils.get_pydantic_model(
                    shipping_address,
                    OptionalNullable[models.UpdateOrderShippingAddress],
                ),
                testmode=testmode,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/orders/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.UpdateOrderRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="update-order",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.UpdateOrderResponseBodyData
            )
            raise models.UpdateOrderResponseBody(data=response_data)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.UpdateOrderOrdersResponseBodyData
            )
            raise models.UpdateOrderOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def update_async(
        self,
        *,
        id: str,
        order_number: OptionalNullable[str] = UNSET,
        redirect_url: OptionalNullable[str] = UNSET,
        cancel_url: OptionalNullable[str] = UNSET,
        webhook_url: OptionalNullable[str] = UNSET,
        billing_address: OptionalNullable[
            Union[
                models.UpdateOrderBillingAddress,
                models.UpdateOrderBillingAddressTypedDict,
            ]
        ] = UNSET,
        shipping_address: OptionalNullable[
            Union[
                models.UpdateOrderShippingAddress,
                models.UpdateOrderShippingAddressTypedDict,
            ]
        ] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Update order

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Certain details of an existing order can be updated.

        For an in-depth explanation of each parameter, see [Create order](create-order).

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param id: Provide the ID of the item you want to perform this operation on.
        :param order_number:
        :param redirect_url: Can be updated while the order is not yet finalized.
        :param cancel_url: Can be updated while the order is not yet finalized.
        :param webhook_url:
        :param billing_address: If a payment method has already been selected, the original shipping address may have already been forwarded to the payment method provider.
        :param shipping_address: If a payment method has already been selected, the original billing address may have already been forwarded to the payment method provider.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateOrderRequest(
            id=id,
            request_body=models.UpdateOrderRequestBody(
                order_number=order_number,
                redirect_url=redirect_url,
                cancel_url=cancel_url,
                webhook_url=webhook_url,
                billing_address=utils.get_pydantic_model(
                    billing_address, OptionalNullable[models.UpdateOrderBillingAddress]
                ),
                shipping_address=utils.get_pydantic_model(
                    shipping_address,
                    OptionalNullable[models.UpdateOrderShippingAddress],
                ),
                testmode=testmode,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/orders/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.UpdateOrderRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="update-order",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.UpdateOrderResponseBodyData
            )
            raise models.UpdateOrderResponseBody(data=response_data)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.UpdateOrderOrdersResponseBodyData
            )
            raise models.UpdateOrderOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def cancel(
        self,
        *,
        id: str,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Cancel order

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        An open order may be canceled if it does not have any open payments yet, and while its status is either `created`, `authorized`, or `shipping`.

        If the order was already authorized, the authorization will be released.

        For an order with status `shipping`, only the order lines that were still pending will be canceled if possible. If a payment method was used that does not support authorizations, cancelation is no longer possible. You will have to issue a refund instead.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param id: Provide the ID of the item you want to perform this operation on.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CancelOrderRequest(
            id=id,
            testmode=testmode,
        )

        req = self._build_request(
            method="DELETE",
            path="/orders/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="cancel-order",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CancelOrderResponseBodyData
            )
            raise models.CancelOrderResponseBody(data=response_data)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CancelOrderOrdersResponseBodyData
            )
            raise models.CancelOrderOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def cancel_async(
        self,
        *,
        id: str,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Cancel order

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        An open order may be canceled if it does not have any open payments yet, and while its status is either `created`, `authorized`, or `shipping`.

        If the order was already authorized, the authorization will be released.

        For an order with status `shipping`, only the order lines that were still pending will be canceled if possible. If a payment method was used that does not support authorizations, cancelation is no longer possible. You will have to issue a refund instead.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param id: Provide the ID of the item you want to perform this operation on.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CancelOrderRequest(
            id=id,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/orders/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="cancel-order",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CancelOrderResponseBodyData
            )
            raise models.CancelOrderResponseBody(data=response_data)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CancelOrderOrdersResponseBodyData
            )
            raise models.CancelOrderOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def manage_lines(
        self,
        *,
        order_id: str,
        operations: Union[List[models.Operations], List[models.OperationsTypedDict]],
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Manage order lines

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Use this endpoint to update, cancel, or add one or more order lines of a `created`, `pending`, or `authorized` order.

        For an already authorized order, updating the order lines will trigger an additional authorization request to the payment method provider.

        For example, your customer placed an order that contains two order lines:

        * Order line A contains two items and amounts to €100.00.
        * Order line B contains a discount of 10% applicable to the items in order line A, which amounts to -€10.00.

        The order total is €90.00.

        You only have one item of type A left, and therefore contact your customer to find another solution. The customer opts to replace one of order line A's items with item C. Item C costs €40.00, however, discount B does not apply to item C.

        Using this endpoint, you can create a request to update the order lines, where:

        * Order line A is updated to quantity 1.
        * Order line B is updated to discount amount -€5.00.
        * Order line C is added with amount €40.00.

        The updated order totals €85.00.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param order_id: Provide the ID of the related order.
        :param operations: List of operations to be performed on the order's line items.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ManageOrderLinesRequest(
            order_id=order_id,
            request_body=models.ManageOrderLinesRequestBody(
                operations=utils.get_pydantic_model(
                    operations, List[models.Operations]
                ),
                testmode=testmode,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/orders/{orderId}/lines",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.ManageOrderLinesRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="manage-order-lines",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ManageOrderLinesResponseBodyData
            )
            raise models.ManageOrderLinesResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def manage_lines_async(
        self,
        *,
        order_id: str,
        operations: Union[List[models.Operations], List[models.OperationsTypedDict]],
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Manage order lines

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Use this endpoint to update, cancel, or add one or more order lines of a `created`, `pending`, or `authorized` order.

        For an already authorized order, updating the order lines will trigger an additional authorization request to the payment method provider.

        For example, your customer placed an order that contains two order lines:

        * Order line A contains two items and amounts to €100.00.
        * Order line B contains a discount of 10% applicable to the items in order line A, which amounts to -€10.00.

        The order total is €90.00.

        You only have one item of type A left, and therefore contact your customer to find another solution. The customer opts to replace one of order line A's items with item C. Item C costs €40.00, however, discount B does not apply to item C.

        Using this endpoint, you can create a request to update the order lines, where:

        * Order line A is updated to quantity 1.
        * Order line B is updated to discount amount -€5.00.
        * Order line C is added with amount €40.00.

        The updated order totals €85.00.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param order_id: Provide the ID of the related order.
        :param operations: List of operations to be performed on the order's line items.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ManageOrderLinesRequest(
            order_id=order_id,
            request_body=models.ManageOrderLinesRequestBody(
                operations=utils.get_pydantic_model(
                    operations, List[models.Operations]
                ),
                testmode=testmode,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/orders/{orderId}/lines",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.ManageOrderLinesRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="manage-order-lines",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ManageOrderLinesResponseBodyData
            )
            raise models.ManageOrderLinesResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def cancel_lines(
        self,
        *,
        order_id: str,
        lines: Union[
            List[models.CancelOrderLinesLines],
            List[models.CancelOrderLinesLinesTypedDict],
        ],
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Cancel order lines

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Cancel one or more order lines that were previously authorized. To cancel the entire order, please refer to the [Cancel order](cancel-order) endpoint instead.

        Canceling or partially canceling an order line will immediately release the authorization held for that amount. You should cancel an order line if you do not intend to (fully) ship it.

        If the order line was already authorized, the authorization will be released.

        For an order line with status `shipping`, the authorization for the quantity that is still pending will be released.

        Afterwards, the order line will be marked `completed`.

        If the order line is `paid` or already `completed`, you can create a refund using the [Create order refund](create-order-refund) endpoint instead.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param order_id: Provide the ID of the related order.
        :param lines:
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CancelOrderLinesRequest(
            order_id=order_id,
            request_body=models.CancelOrderLinesRequestBody(
                lines=utils.get_pydantic_model(
                    lines, List[models.CancelOrderLinesLines]
                ),
                testmode=testmode,
            ),
        )

        req = self._build_request(
            method="DELETE",
            path="/orders/{orderId}/lines",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CancelOrderLinesRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="cancel-order-lines",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CancelOrderLinesResponseBodyData
            )
            raise models.CancelOrderLinesResponseBody(data=response_data)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CancelOrderLinesOrdersResponseBodyData
            )
            raise models.CancelOrderLinesOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def cancel_lines_async(
        self,
        *,
        order_id: str,
        lines: Union[
            List[models.CancelOrderLinesLines],
            List[models.CancelOrderLinesLinesTypedDict],
        ],
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Cancel order lines

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Cancel one or more order lines that were previously authorized. To cancel the entire order, please refer to the [Cancel order](cancel-order) endpoint instead.

        Canceling or partially canceling an order line will immediately release the authorization held for that amount. You should cancel an order line if you do not intend to (fully) ship it.

        If the order line was already authorized, the authorization will be released.

        For an order line with status `shipping`, the authorization for the quantity that is still pending will be released.

        Afterwards, the order line will be marked `completed`.

        If the order line is `paid` or already `completed`, you can create a refund using the [Create order refund](create-order-refund) endpoint instead.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param order_id: Provide the ID of the related order.
        :param lines:
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CancelOrderLinesRequest(
            order_id=order_id,
            request_body=models.CancelOrderLinesRequestBody(
                lines=utils.get_pydantic_model(
                    lines, List[models.CancelOrderLinesLines]
                ),
                testmode=testmode,
            ),
        )

        req = self._build_request_async(
            method="DELETE",
            path="/orders/{orderId}/lines",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CancelOrderLinesRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="cancel-order-lines",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CancelOrderLinesResponseBodyData
            )
            raise models.CancelOrderLinesResponseBody(data=response_data)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CancelOrderLinesOrdersResponseBodyData
            )
            raise models.CancelOrderLinesOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def update_line(
        self,
        *,
        order_id: str,
        id: str,
        name: OptionalNullable[str] = UNSET,
        image_url: OptionalNullable[str] = UNSET,
        product_url: OptionalNullable[str] = UNSET,
        sku: OptionalNullable[str] = UNSET,
        metadata: OptionalNullable[str] = UNSET,
        quantity: OptionalNullable[int] = UNSET,
        unit_price: OptionalNullable[
            Union[
                models.UpdateOrderLineUnitPrice,
                models.UpdateOrderLineUnitPriceTypedDict,
            ]
        ] = UNSET,
        discount_amount: OptionalNullable[
            Union[
                models.UpdateOrderLineDiscountAmount,
                models.UpdateOrderLineDiscountAmountTypedDict,
            ]
        ] = UNSET,
        total_amount: OptionalNullable[
            Union[
                models.UpdateOrderLineTotalAmount,
                models.UpdateOrderLineTotalAmountTypedDict,
            ]
        ] = UNSET,
        vat_amount: OptionalNullable[
            Union[
                models.UpdateOrderLineVatAmount,
                models.UpdateOrderLineVatAmountTypedDict,
            ]
        ] = UNSET,
        vat_rate: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Update order line

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Update an order line belonging to an order. Only lines with status `created`, `pending`, or `authorized` can be updated.

        This endpoint is useful for cases where specific details of an order line are changed. For example, if a customer changes a red shirt for a blue one of the same model. In this case only specific properties of the order line need to be updated, such as the `name`, the `imageUrl`, and perhaps the `amount`.

        To swap out an order line for an entirely new order line, use the [Manage order lines](manage-order-lines) endpoint instead.

        For an in-depth explanation of each parameter, refer to the `lines` parameter of the [Create order](create-order) endpoint.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param order_id: Provide the ID of the related order.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param name:
        :param image_url:
        :param product_url:
        :param sku:
        :param metadata:
        :param quantity: Required when a `unitPrice`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request.
        :param unit_price: Required when a `quantity`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request.
        :param discount_amount: In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field.
        :param total_amount: Required when a `quantity`, `unitPrice`, `discountAmount`, `vatAmount`, or `vatRate` is also provided in the same request.
        :param vat_amount: Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatRate` is also provided in the same request.
        :param vat_rate: Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatAmount` is also provided in the same request.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateOrderLineRequest(
            order_id=order_id,
            id=id,
            request_body=models.UpdateOrderLineRequestBody(
                name=name,
                image_url=image_url,
                product_url=product_url,
                sku=sku,
                metadata=metadata,
                quantity=quantity,
                unit_price=utils.get_pydantic_model(
                    unit_price, OptionalNullable[models.UpdateOrderLineUnitPrice]
                ),
                discount_amount=utils.get_pydantic_model(
                    discount_amount,
                    OptionalNullable[models.UpdateOrderLineDiscountAmount],
                ),
                total_amount=utils.get_pydantic_model(
                    total_amount, OptionalNullable[models.UpdateOrderLineTotalAmount]
                ),
                vat_amount=utils.get_pydantic_model(
                    vat_amount, OptionalNullable[models.UpdateOrderLineVatAmount]
                ),
                vat_rate=vat_rate,
                testmode=testmode,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/orders/{orderId}/lines/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.UpdateOrderLineRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="update-order-line",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.UpdateOrderLineResponseBodyData
            )
            raise models.UpdateOrderLineResponseBody(data=response_data)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.UpdateOrderLineOrdersResponseBodyData
            )
            raise models.UpdateOrderLineOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def update_line_async(
        self,
        *,
        order_id: str,
        id: str,
        name: OptionalNullable[str] = UNSET,
        image_url: OptionalNullable[str] = UNSET,
        product_url: OptionalNullable[str] = UNSET,
        sku: OptionalNullable[str] = UNSET,
        metadata: OptionalNullable[str] = UNSET,
        quantity: OptionalNullable[int] = UNSET,
        unit_price: OptionalNullable[
            Union[
                models.UpdateOrderLineUnitPrice,
                models.UpdateOrderLineUnitPriceTypedDict,
            ]
        ] = UNSET,
        discount_amount: OptionalNullable[
            Union[
                models.UpdateOrderLineDiscountAmount,
                models.UpdateOrderLineDiscountAmountTypedDict,
            ]
        ] = UNSET,
        total_amount: OptionalNullable[
            Union[
                models.UpdateOrderLineTotalAmount,
                models.UpdateOrderLineTotalAmountTypedDict,
            ]
        ] = UNSET,
        vat_amount: OptionalNullable[
            Union[
                models.UpdateOrderLineVatAmount,
                models.UpdateOrderLineVatAmountTypedDict,
            ]
        ] = UNSET,
        vat_rate: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = False,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Update order line

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        Update an order line belonging to an order. Only lines with status `created`, `pending`, or `authorized` can be updated.

        This endpoint is useful for cases where specific details of an order line are changed. For example, if a customer changes a red shirt for a blue one of the same model. In this case only specific properties of the order line need to be updated, such as the `name`, the `imageUrl`, and perhaps the `amount`.

        To swap out an order line for an entirely new order line, use the [Manage order lines](manage-order-lines) endpoint instead.

        For an in-depth explanation of each parameter, refer to the `lines` parameter of the [Create order](create-order) endpoint.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **orders.write**](/reference/authentication)

        :param order_id: Provide the ID of the related order.
        :param id: Provide the ID of the item you want to perform this operation on.
        :param name:
        :param image_url:
        :param product_url:
        :param sku:
        :param metadata:
        :param quantity: Required when a `unitPrice`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request.
        :param unit_price: Required when a `quantity`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request.
        :param discount_amount: In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field.
        :param total_amount: Required when a `quantity`, `unitPrice`, `discountAmount`, `vatAmount`, or `vatRate` is also provided in the same request.
        :param vat_amount: Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatRate` is also provided in the same request.
        :param vat_rate: Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatAmount` is also provided in the same request.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateOrderLineRequest(
            order_id=order_id,
            id=id,
            request_body=models.UpdateOrderLineRequestBody(
                name=name,
                image_url=image_url,
                product_url=product_url,
                sku=sku,
                metadata=metadata,
                quantity=quantity,
                unit_price=utils.get_pydantic_model(
                    unit_price, OptionalNullable[models.UpdateOrderLineUnitPrice]
                ),
                discount_amount=utils.get_pydantic_model(
                    discount_amount,
                    OptionalNullable[models.UpdateOrderLineDiscountAmount],
                ),
                total_amount=utils.get_pydantic_model(
                    total_amount, OptionalNullable[models.UpdateOrderLineTotalAmount]
                ),
                vat_amount=utils.get_pydantic_model(
                    vat_amount, OptionalNullable[models.UpdateOrderLineVatAmount]
                ),
                vat_rate=vat_rate,
                testmode=testmode,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/orders/{orderId}/lines/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.UpdateOrderLineRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="update-order-line",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.UpdateOrderLineResponseBodyData
            )
            raise models.UpdateOrderLineResponseBody(data=response_data)
        if utils.match_response(http_res, "422", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.UpdateOrderLineOrdersResponseBodyData
            )
            raise models.UpdateOrderLineOrdersResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def create_payment(
        self,
        *,
        order_id: str,
        request_body: Optional[Any] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Create order payment

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        An order has an automatically created payment that your customer can use to pay for the order. When the payment expires you can create a new payment for the order using this endpoint. A maximum of 25 payments can be created for an order.

        A new payment can only be created while the status of the order is `created`, and when the status of the existing payment is either `expired`, `canceled` or `failed`.

        The endpoint accepts virtually all parameters accepted by the regular [Create payment](create-payment) endpoint. Please refer to that endpoint for the full documentation of all parameters.

        The payment inherits certain properties, such as the `amount` and `webhookUrl`, directly from the order. These cannot be changed via this endpoint.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **payments.write**](/reference/authentication)

        :param order_id: Provide the ID of the related order.
        :param request_body:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateOrderPaymentRequest(
            order_id=order_id,
            request_body=request_body,
        )

        req = self._build_request(
            method="POST",
            path="/orders/{orderId}/payments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, True, "json", Optional[Any]
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create-order-payment",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CreateOrderPaymentResponseBodyData
            )
            raise models.CreateOrderPaymentResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_payment_async(
        self,
        *,
        order_id: str,
        request_body: Optional[Any] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Create order payment

        **⚠️ We no longer recommend implementing the Orders API. Please refer to the Payments API instead. We are actively working on adding support for Klarna, Billie, in3 and Vouchers to the Payments API later this year.**

        An order has an automatically created payment that your customer can use to pay for the order. When the payment expires you can create a new payment for the order using this endpoint. A maximum of 25 payments can be created for an order.

        A new payment can only be created while the status of the order is `created`, and when the status of the existing payment is either `expired`, `canceled` or `failed`.

        The endpoint accepts virtually all parameters accepted by the regular [Create payment](create-payment) endpoint. Please refer to that endpoint for the full documentation of all parameters.

        The payment inherits certain properties, such as the `amount` and `webhookUrl`, directly from the order. These cannot be changed via this endpoint.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **payments.write**](/reference/authentication)

        :param order_id: Provide the ID of the related order.
        :param request_body:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateOrderPaymentRequest(
            order_id=order_id,
            request_body=request_body,
        )

        req = self._build_request_async(
            method="POST",
            path="/orders/{orderId}/payments",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body, False, True, "json", Optional[Any]
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create-order-payment",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CreateOrderPaymentResponseBodyData
            )
            raise models.CreateOrderPaymentResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
