# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute Key | Entity   | Purpose                                                                     | |:--------------|:---------|:----------------------------------------------------------------------------| | `ICON_NAME`   | Location | The attribute value is written to the web_location_geopoint.icon_name field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.12.2609
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Union
from typing_extensions import Annotated
from vrt_lss_studio.models.location_cargos_limit import LocationCargosLimit
from vrt_lss_studio.models.location_limit_statistics import LocationLimitStatistics
from vrt_lss_studio.models.location_transports_limit import LocationTransportsLimit
from typing import Optional, Set
from typing_extensions import Self

class LocationStatistics(BaseModel):
    """
    Statistics for a specific trip. 
    """ # noqa: E501
    location_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Location key.")
    location_limits_penalty: Union[Annotated[float, Field(le=1000000000, strict=True, ge=0)], Annotated[int, Field(le=1000000000, strict=True, ge=0)]] = Field(description="Amount of fines for violating location's capacity limit.")
    total_cargos_statistics: LocationCargosLimit
    total_transports_statistics: LocationTransportsLimit
    limits_statistics: Annotated[List[LocationLimitStatistics], Field(min_length=0, max_length=100)] = Field(description="Location capacity limit statistics.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["location_key", "location_limits_penalty", "total_cargos_statistics", "total_transports_statistics", "limits_statistics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LocationStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of total_cargos_statistics
        if self.total_cargos_statistics:
            _dict['total_cargos_statistics'] = self.total_cargos_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_transports_statistics
        if self.total_transports_statistics:
            _dict['total_transports_statistics'] = self.total_transports_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in limits_statistics (list)
        _items = []
        if self.limits_statistics:
            for _item in self.limits_statistics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['limits_statistics'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LocationStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "location_key": obj.get("location_key"),
            "location_limits_penalty": obj.get("location_limits_penalty"),
            "total_cargos_statistics": LocationCargosLimit.from_dict(obj["total_cargos_statistics"]) if obj.get("total_cargos_statistics") is not None else None,
            "total_transports_statistics": LocationTransportsLimit.from_dict(obj["total_transports_statistics"]) if obj.get("total_transports_statistics") is not None else None,
            "limits_statistics": [LocationLimitStatistics.from_dict(_item) for _item in obj["limits_statistics"]] if obj.get("limits_statistics") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


