# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute Key | Entity   | Purpose                                                                     | |:--------------|:---------|:----------------------------------------------------------------------------| | `ICON_NAME`   | Location | The attribute value is written to the web_location_geopoint.icon_name field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.12.2609
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from vrt_lss_studio.models.basic_state import BasicState
from vrt_lss_studio.models.basic_time_window import BasicTimeWindow
from vrt_lss_studio.models.table_customfields import TableCustomfields
from typing import Optional, Set
from typing_extensions import Self

class TableOrderFields(BaseModel):
    """
    Order and demand fields for table.
    """ # noqa: E501
    essence_type: Optional[StrictStr] = Field(default='ORDER', description="Essence type.")
    essence_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    enabled: Optional[StrictBool] = Field(default=True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(default=True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    state: Optional[BasicState] = BasicState.UNPLANNED
    type: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    hard_time_window: Optional[BasicTimeWindow] = None
    soft_time_window: Optional[BasicTimeWindow] = None
    general_drop_time_window: Optional[BasicTimeWindow] = None
    general_pickup_time_window: Optional[BasicTimeWindow] = None
    general_work_time_window: Optional[BasicTimeWindow] = None
    reward: Optional[Union[Annotated[float, Field(le=10000000000, strict=True, ge=0)], Annotated[int, Field(le=2147483647, strict=True, ge=0)]]] = Field(default=0, description="The total reward for orders fulfillment.")
    mass: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Weight in kilograms.")
    volume: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Volume in cubic meters.")
    capacity_a: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Additional capacity parameter (A) for measuring cargoes and boxes in alternative units. For example, to account for cargo in pieces (this parameter is equal to one for a cargo and the maximum number of cargo to hold for a box). ")
    capacity_b: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Additional capacity parameter (B) for measuring cargoes and boxes in alternative units. ")
    capacity_c: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Additional capacity parameter (C) for measuring cargoes and boxes in alternative units. ")
    order_features: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    order_restrictions: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    performer_restrictions: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    performer_blacklist: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    width: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Width in meters, used to check the transport box capacity.")
    height: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Height in meters, used to check the transport box capacity.")
    length: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Length in meters, used to check the transport box capacity.")
    rotation: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    box_restrictions: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    cargo_features: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    cargo_restrictions: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="String table field.  For the parent entity, a comma-separated list of values is specified. ")
    demands_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="Demands count.")
    trip_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=128)]] = Field(default='', description="Name, information field.")
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=128)]] = Field(default='', description="Name, information field.")
    attributes: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1000000)]] = Field(default='', description="Attributes.")
    customfields: Optional[TableCustomfields] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["essence_type", "essence_key", "enabled", "pristine", "state", "type", "hard_time_window", "soft_time_window", "general_drop_time_window", "general_pickup_time_window", "general_work_time_window", "reward", "mass", "volume", "capacity_a", "capacity_b", "capacity_c", "order_features", "order_restrictions", "performer_restrictions", "performer_blacklist", "width", "height", "length", "rotation", "box_restrictions", "cargo_features", "cargo_restrictions", "demands_count", "trip_key", "trip_name", "name", "attributes", "customfields"]

    @field_validator('essence_type')
    def essence_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ORDER', 'DEMAND']):
            raise ValueError("must be one of enum values ('ORDER', 'DEMAND')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableOrderFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "pristine",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of hard_time_window
        if self.hard_time_window:
            _dict['hard_time_window'] = self.hard_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of soft_time_window
        if self.soft_time_window:
            _dict['soft_time_window'] = self.soft_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of general_drop_time_window
        if self.general_drop_time_window:
            _dict['general_drop_time_window'] = self.general_drop_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of general_pickup_time_window
        if self.general_pickup_time_window:
            _dict['general_pickup_time_window'] = self.general_pickup_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of general_work_time_window
        if self.general_work_time_window:
            _dict['general_work_time_window'] = self.general_work_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customfields
        if self.customfields:
            _dict['customfields'] = self.customfields.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if essence_key (nullable) is None
        # and model_fields_set contains the field
        if self.essence_key is None and "essence_key" in self.model_fields_set:
            _dict['essence_key'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if hard_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.hard_time_window is None and "hard_time_window" in self.model_fields_set:
            _dict['hard_time_window'] = None

        # set to None if soft_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.soft_time_window is None and "soft_time_window" in self.model_fields_set:
            _dict['soft_time_window'] = None

        # set to None if general_drop_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.general_drop_time_window is None and "general_drop_time_window" in self.model_fields_set:
            _dict['general_drop_time_window'] = None

        # set to None if general_pickup_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.general_pickup_time_window is None and "general_pickup_time_window" in self.model_fields_set:
            _dict['general_pickup_time_window'] = None

        # set to None if general_work_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.general_work_time_window is None and "general_work_time_window" in self.model_fields_set:
            _dict['general_work_time_window'] = None

        # set to None if order_features (nullable) is None
        # and model_fields_set contains the field
        if self.order_features is None and "order_features" in self.model_fields_set:
            _dict['order_features'] = None

        # set to None if order_restrictions (nullable) is None
        # and model_fields_set contains the field
        if self.order_restrictions is None and "order_restrictions" in self.model_fields_set:
            _dict['order_restrictions'] = None

        # set to None if performer_restrictions (nullable) is None
        # and model_fields_set contains the field
        if self.performer_restrictions is None and "performer_restrictions" in self.model_fields_set:
            _dict['performer_restrictions'] = None

        # set to None if performer_blacklist (nullable) is None
        # and model_fields_set contains the field
        if self.performer_blacklist is None and "performer_blacklist" in self.model_fields_set:
            _dict['performer_blacklist'] = None

        # set to None if rotation (nullable) is None
        # and model_fields_set contains the field
        if self.rotation is None and "rotation" in self.model_fields_set:
            _dict['rotation'] = None

        # set to None if box_restrictions (nullable) is None
        # and model_fields_set contains the field
        if self.box_restrictions is None and "box_restrictions" in self.model_fields_set:
            _dict['box_restrictions'] = None

        # set to None if cargo_features (nullable) is None
        # and model_fields_set contains the field
        if self.cargo_features is None and "cargo_features" in self.model_fields_set:
            _dict['cargo_features'] = None

        # set to None if cargo_restrictions (nullable) is None
        # and model_fields_set contains the field
        if self.cargo_restrictions is None and "cargo_restrictions" in self.model_fields_set:
            _dict['cargo_restrictions'] = None

        # set to None if trip_key (nullable) is None
        # and model_fields_set contains the field
        if self.trip_key is None and "trip_key" in self.model_fields_set:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableOrderFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'ORDER',
            "essence_key": obj.get("essence_key"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "state": obj.get("state"),
            "type": obj.get("type"),
            "hard_time_window": BasicTimeWindow.from_dict(obj["hard_time_window"]) if obj.get("hard_time_window") is not None else None,
            "soft_time_window": BasicTimeWindow.from_dict(obj["soft_time_window"]) if obj.get("soft_time_window") is not None else None,
            "general_drop_time_window": BasicTimeWindow.from_dict(obj["general_drop_time_window"]) if obj.get("general_drop_time_window") is not None else None,
            "general_pickup_time_window": BasicTimeWindow.from_dict(obj["general_pickup_time_window"]) if obj.get("general_pickup_time_window") is not None else None,
            "general_work_time_window": BasicTimeWindow.from_dict(obj["general_work_time_window"]) if obj.get("general_work_time_window") is not None else None,
            "reward": obj.get("reward") if obj.get("reward") is not None else 0,
            "mass": obj.get("mass") if obj.get("mass") is not None else 0,
            "volume": obj.get("volume") if obj.get("volume") is not None else 0,
            "capacity_a": obj.get("capacity_a") if obj.get("capacity_a") is not None else 0,
            "capacity_b": obj.get("capacity_b") if obj.get("capacity_b") is not None else 0,
            "capacity_c": obj.get("capacity_c") if obj.get("capacity_c") is not None else 0,
            "order_features": obj.get("order_features"),
            "order_restrictions": obj.get("order_restrictions"),
            "performer_restrictions": obj.get("performer_restrictions"),
            "performer_blacklist": obj.get("performer_blacklist"),
            "width": obj.get("width") if obj.get("width") is not None else 0,
            "height": obj.get("height") if obj.get("height") is not None else 0,
            "length": obj.get("length") if obj.get("length") is not None else 0,
            "rotation": obj.get("rotation"),
            "box_restrictions": obj.get("box_restrictions"),
            "cargo_features": obj.get("cargo_features"),
            "cargo_restrictions": obj.get("cargo_restrictions"),
            "demands_count": obj.get("demands_count") if obj.get("demands_count") is not None else 0,
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "name": obj.get("name") if obj.get("name") is not None else '',
            "attributes": obj.get("attributes") if obj.get("attributes") is not None else '',
            "customfields": TableCustomfields.from_dict(obj["customfields"]) if obj.get("customfields") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


