# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Reserved attributes  These attribute keys are reserved for specific business logic:  | Attribute Key | Entity   | Purpose                                                                     | |:--------------|:---------|:----------------------------------------------------------------------------| | `ICON_NAME`   | Location | The attribute value is written to the web_location_geopoint.icon_name field |  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.12.2609
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.trip_assumptions import TripAssumptions
from vrt_lss_studio.models.trip_expectations import TripExpectations
from vrt_lss_studio.models.trip_penalties import TripPenalties
from typing import Optional, Set
from typing_extensions import Self

class TripsSettings(BaseModel):
    """
    Trip creation settings.
    """ # noqa: E501
    configuration: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=256)]] = Field(default='default', description="Name of the planning configuration. The configuration determines the result goal and quality.     [List of available](#section/Description/Planning-configuration) planning configurations.")
    expectations: Optional[TripExpectations] = None
    assumptions: Optional[TripAssumptions] = None
    penalties: Optional[TripPenalties] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["configuration", "expectations", "assumptions", "penalties"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TripsSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of expectations
        if self.expectations:
            _dict['expectations'] = self.expectations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of assumptions
        if self.assumptions:
            _dict['assumptions'] = self.assumptions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of penalties
        if self.penalties:
            _dict['penalties'] = self.penalties.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TripsSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "configuration": obj.get("configuration") if obj.get("configuration") is not None else 'default',
            "expectations": TripExpectations.from_dict(obj["expectations"]) if obj.get("expectations") is not None else None,
            "assumptions": TripAssumptions.from_dict(obj["assumptions"]) if obj.get("assumptions") is not None else None,
            "penalties": TripPenalties.from_dict(obj["penalties"]) if obj.get("penalties") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


