"""empty message

Revision ID: f4aaf1bdf8c0
Revises: 
Create Date: 2018-03-17 00:07:16.470038

"""
from alembic import op
import sqlalchemy as sa

import impetuous.data

# revision identifiers, used by Alembic.
revision = 'f4aaf1bdf8c0'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('entry',
    sa.Column('id', impetuous.data.UUID(), nullable=False),
    sa.Column('rev', impetuous.data.UUID(), nullable=False),
    sa.Column('text', sa.String(), nullable=False),
    sa.Column('comment', sa.String(), nullable=False),
    sa.Column('start', impetuous.data.UTCDateTime(), nullable=False),
    sa.Column('end', impetuous.data.UTCDateTime(), nullable=True),
    sa.CheckConstraint('end > start', name='ends after start'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index('idx_entry_start', 'entry', ['start'], unique=True)
    op.create_table('submission',
    sa.Column('id', impetuous.data.UUID(), nullable=False),
    sa.Column('rev', impetuous.data.UUID(), nullable=False),
    sa.Column('entry', impetuous.data.UUID(), nullable=False),
    sa.Column('ext', sa.String(), nullable=False),
    sa.Column('key', sa.String(), nullable=False),
    sa.Column('result', impetuous.data.YamlDoc(), nullable=False),
    sa.ForeignKeyConstraint(['entry'], ['entry.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index('idx_submission_entry_ext', 'submission', ['entry', 'ext', 'key'], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('idx_submission_entry_ext', table_name='submission')
    op.drop_table('submission')
    op.drop_index('idx_entry_start', table_name='entry')
    op.drop_table('entry')
    # ### end Alembic commands ###
