# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings
import functools

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field

from circle.web3.developer_controlled_wallets.models.sign_delegate_action_request import SignDelegateActionRequest
from circle.web3.developer_controlled_wallets.models.sign_delegate_action_response import SignDelegateActionResponse
from circle.web3.developer_controlled_wallets.models.sign_message_request import SignMessageRequest
from circle.web3.developer_controlled_wallets.models.sign_transaction_request import SignTransactionRequest
from circle.web3.developer_controlled_wallets.models.sign_transaction_response import SignTransactionResponse
from circle.web3.developer_controlled_wallets.models.sign_typed_data_request import SignTypedDataRequest
from circle.web3.developer_controlled_wallets.models.signature_response import SignatureResponse

from circle.web3.developer_controlled_wallets.api_client import ApiClient
from circle.web3.developer_controlled_wallets.api_response import ApiResponse
from circle.web3.developer_controlled_wallets.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


def auto_fill(func):
    functools.wraps(func)

    def wrapper(*args, **kwargs):
        api = args[0]
        for arg in args:
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        for name, arg in kwargs.items():
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        return func(*args, **kwargs)

    return wrapper


class SigningApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @auto_fill
    @validate_arguments
    def sign_delegate_action(self, sign_delegate_action_request : Annotated[SignDelegateActionRequest, Field(..., description="Schema for the request payload to sign a delegate action.")], **kwargs) -> SignDelegateActionResponse:  # noqa: E501
        """Sign delegate action  # noqa: E501

        Sign a delegate action from a specific developer-controlled wallet.  NOTE: This endpoint is only available for NEAR and NEAR-TESTNET.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_delegate_action(sign_delegate_action_request, async_req=True)
        >>> result = thread.get()

        :param sign_delegate_action_request: Schema for the request payload to sign a delegate action. (required)
        :type sign_delegate_action_request: SignDelegateActionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignDelegateActionResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the sign_delegate_action_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.sign_delegate_action_with_http_info(sign_delegate_action_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def sign_delegate_action_with_http_info(self, sign_delegate_action_request : Annotated[SignDelegateActionRequest, Field(..., description="Schema for the request payload to sign a delegate action.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Sign delegate action  # noqa: E501

        Sign a delegate action from a specific developer-controlled wallet.  NOTE: This endpoint is only available for NEAR and NEAR-TESTNET.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_delegate_action_with_http_info(sign_delegate_action_request, async_req=True)
        >>> result = thread.get()

        :param sign_delegate_action_request: Schema for the request payload to sign a delegate action. (required)
        :type sign_delegate_action_request: SignDelegateActionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SignDelegateActionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'sign_delegate_action_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sign_delegate_action" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['sign_delegate_action_request'] is not None:
            _body_params = _params['sign_delegate_action_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SignDelegateActionResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/sign/delegateAction', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def sign_message(self, sign_message_request : Annotated[SignMessageRequest, Field(..., description="Schema for the request payload to sign a message.")], **kwargs) -> SignatureResponse:  # noqa: E501
        """Sign message  # noqa: E501

        Sign a message from a specified developer-controlled wallet. This endpoint supports message signing for both Ethereum-based blockchains (using EIP-191) and Solana (using Ed25519 signatures). Note that Smart Contract Accounts (SCA) are specific to Ethereum and EVM-compatible chains. The difference between Ethereum's EOA and SCA can be found in the [account types guide](https://developers.circle.com/w3s/docs/programmable-wallets-account-types). You can also check the list of Ethereum Dapps that support SCA: https://eip1271.io/.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_message(sign_message_request, async_req=True)
        >>> result = thread.get()

        :param sign_message_request: Schema for the request payload to sign a message. (required)
        :type sign_message_request: SignMessageRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignatureResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the sign_message_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.sign_message_with_http_info(sign_message_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def sign_message_with_http_info(self, sign_message_request : Annotated[SignMessageRequest, Field(..., description="Schema for the request payload to sign a message.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Sign message  # noqa: E501

        Sign a message from a specified developer-controlled wallet. This endpoint supports message signing for both Ethereum-based blockchains (using EIP-191) and Solana (using Ed25519 signatures). Note that Smart Contract Accounts (SCA) are specific to Ethereum and EVM-compatible chains. The difference between Ethereum's EOA and SCA can be found in the [account types guide](https://developers.circle.com/w3s/docs/programmable-wallets-account-types). You can also check the list of Ethereum Dapps that support SCA: https://eip1271.io/.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_message_with_http_info(sign_message_request, async_req=True)
        >>> result = thread.get()

        :param sign_message_request: Schema for the request payload to sign a message. (required)
        :type sign_message_request: SignMessageRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SignatureResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'sign_message_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sign_message" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['sign_message_request'] is not None:
            _body_params = _params['sign_message_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SignatureResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/sign/message', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def sign_transaction(self, sign_transaction_request : Annotated[SignTransactionRequest, Field(..., description="Schema for the request payload to sign a transaction.")], **kwargs) -> SignTransactionResponse:  # noqa: E501
        """Sign transaction  # noqa: E501

        Sign a transaction from a specific developer-controlled wallet.  NOTE: This endpoint is only available for the following chains: `SOL`, `SOL-DEVNET`, `NEAR`, `NEAR-TESTNET`, `EVM`, `EVM-TESTNET`. Each chain defines its own standard, please refer to [Signing APIs doc](https://learn.circle.com/w3s/signing-apis).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_transaction(sign_transaction_request, async_req=True)
        >>> result = thread.get()

        :param sign_transaction_request: Schema for the request payload to sign a transaction. (required)
        :type sign_transaction_request: SignTransactionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignTransactionResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the sign_transaction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.sign_transaction_with_http_info(sign_transaction_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def sign_transaction_with_http_info(self, sign_transaction_request : Annotated[SignTransactionRequest, Field(..., description="Schema for the request payload to sign a transaction.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Sign transaction  # noqa: E501

        Sign a transaction from a specific developer-controlled wallet.  NOTE: This endpoint is only available for the following chains: `SOL`, `SOL-DEVNET`, `NEAR`, `NEAR-TESTNET`, `EVM`, `EVM-TESTNET`. Each chain defines its own standard, please refer to [Signing APIs doc](https://learn.circle.com/w3s/signing-apis).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_transaction_with_http_info(sign_transaction_request, async_req=True)
        >>> result = thread.get()

        :param sign_transaction_request: Schema for the request payload to sign a transaction. (required)
        :type sign_transaction_request: SignTransactionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SignTransactionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'sign_transaction_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sign_transaction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['sign_transaction_request'] is not None:
            _body_params = _params['sign_transaction_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SignTransactionResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/sign/transaction', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def sign_typed_data(self, sign_typed_data_request : Annotated[SignTypedDataRequest, Field(..., description="Schema for the request payload to sign typed data.")], **kwargs) -> SignatureResponse:  # noqa: E501
        """Sign typed data  # noqa: E501

        Sign the EIP-712 typed structured data from a specified developer-controlled wallet. This endpoint only supports Ethereum and EVM-compatible blockchains. Please note that not all Dapps currently support Smart Contract Accounts (SCA); the difference between Ethereum's EOA and SCA can be found in the [account types guide](https://developers.circle.com/w3s/docs/programmable-wallets-account-types). You can also check the list of Ethereum Dapps that support SCA: https://eip1271.io/.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_typed_data(sign_typed_data_request, async_req=True)
        >>> result = thread.get()

        :param sign_typed_data_request: Schema for the request payload to sign typed data. (required)
        :type sign_typed_data_request: SignTypedDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignatureResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the sign_typed_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.sign_typed_data_with_http_info(sign_typed_data_request, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def sign_typed_data_with_http_info(self, sign_typed_data_request : Annotated[SignTypedDataRequest, Field(..., description="Schema for the request payload to sign typed data.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Sign typed data  # noqa: E501

        Sign the EIP-712 typed structured data from a specified developer-controlled wallet. This endpoint only supports Ethereum and EVM-compatible blockchains. Please note that not all Dapps currently support Smart Contract Accounts (SCA); the difference between Ethereum's EOA and SCA can be found in the [account types guide](https://developers.circle.com/w3s/docs/programmable-wallets-account-types). You can also check the list of Ethereum Dapps that support SCA: https://eip1271.io/.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_typed_data_with_http_info(sign_typed_data_request, async_req=True)
        >>> result = thread.get()

        :param sign_typed_data_request: Schema for the request payload to sign typed data. (required)
        :type sign_typed_data_request: SignTypedDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SignatureResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'sign_typed_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sign_typed_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['sign_typed_data_request'] is not None:
            _body_params = _params['sign_typed_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SignatureResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/sign/typedData', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
