# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings
import functools

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictBool, StrictStr, conint

from typing import Optional

from circle.web3.developer_controlled_wallets.models.backfill_wallet_request import BackfillWalletRequest
from circle.web3.developer_controlled_wallets.models.balances import Balances
from circle.web3.developer_controlled_wallets.models.blockchain import Blockchain
from circle.web3.developer_controlled_wallets.models.create_wallet_request import CreateWalletRequest
from circle.web3.developer_controlled_wallets.models.nfts import Nfts
from circle.web3.developer_controlled_wallets.models.sca_core import ScaCore
from circle.web3.developer_controlled_wallets.models.token_standard import TokenStandard
from circle.web3.developer_controlled_wallets.models.update_wallet_request import UpdateWalletRequest
from circle.web3.developer_controlled_wallets.models.wallet_response import WalletResponse
from circle.web3.developer_controlled_wallets.models.wallets import Wallets
from circle.web3.developer_controlled_wallets.models.wallets_with_balances import WalletsWithBalances

from circle.web3.developer_controlled_wallets.api_client import ApiClient
from circle.web3.developer_controlled_wallets.api_response import ApiResponse
from circle.web3.developer_controlled_wallets.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


def auto_fill(func):
    functools.wraps(func)

    def wrapper(*args, **kwargs):
        api = args[0]
        for arg in args:
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        for name, arg in kwargs.items():
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        return func(*args, **kwargs)

    return wrapper


class WalletsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @auto_fill
    @validate_arguments
    def backfill_wallet(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], backfill_wallet_request : Annotated[BackfillWalletRequest, Field(..., description="Defines the request payload schema for backfilling a new wallet.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> WalletResponse:  # noqa: E501
        """Backfill a wallet  # noqa: E501

        Backfills an Externally Owned Account (EOA) wallet using the specified wallet address and blockchain. This operation is supported only for EVM-based blockchains.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.backfill_wallet(id, backfill_wallet_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param backfill_wallet_request: Defines the request payload schema for backfilling a new wallet. (required)
        :type backfill_wallet_request: BackfillWalletRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WalletResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the backfill_wallet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.backfill_wallet_with_http_info(id, backfill_wallet_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def backfill_wallet_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], backfill_wallet_request : Annotated[BackfillWalletRequest, Field(..., description="Defines the request payload schema for backfilling a new wallet.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Backfill a wallet  # noqa: E501

        Backfills an Externally Owned Account (EOA) wallet using the specified wallet address and blockchain. This operation is supported only for EVM-based blockchains.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.backfill_wallet_with_http_info(id, backfill_wallet_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param backfill_wallet_request: Defines the request payload schema for backfilling a new wallet. (required)
        :type backfill_wallet_request: BackfillWalletRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WalletResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'backfill_wallet_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method backfill_wallet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['backfill_wallet_request'] is not None:
            _body_params = _params['backfill_wallet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WalletResponse",
            '201': "WalletResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/wallets/{id}/backfill', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def create_wallet(self, create_wallet_request : Annotated[CreateWalletRequest, Field(..., description="Schema for the request payload to create a new wallet.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> Wallets:  # noqa: E501
        """Create wallets  # noqa: E501

        Generates a new developer-controlled wallet or batch of wallets within a wallet set, specifying blockchain and wallet name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wallet(create_wallet_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_wallet_request: Schema for the request payload to create a new wallet. (required)
        :type create_wallet_request: CreateWalletRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Wallets
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_wallet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_wallet_with_http_info(create_wallet_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_wallet_with_http_info(self, create_wallet_request : Annotated[CreateWalletRequest, Field(..., description="Schema for the request payload to create a new wallet.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create wallets  # noqa: E501

        Generates a new developer-controlled wallet or batch of wallets within a wallet set, specifying blockchain and wallet name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wallet_with_http_info(create_wallet_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_wallet_request: Schema for the request payload to create a new wallet. (required)
        :type create_wallet_request: CreateWalletRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Wallets, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_wallet_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_wallet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_wallet_request'] is not None:
            _body_params = _params['create_wallet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Wallets",
            '201': "Wallets",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/wallets', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def get_wallet(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> WalletResponse:  # noqa: E501
        """Retrieve a wallet  # noqa: E501

        Retrieve an existing wallet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallet(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WalletResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_wallet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_wallet_with_http_info(id, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_wallet_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Retrieve a wallet  # noqa: E501

        Retrieve an existing wallet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallet_with_http_info(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WalletResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wallet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WalletResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/wallets/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def get_wallets(self, address : Annotated[Optional[StrictStr], Field(description="Filter by the blockchain address of the wallet.")] = None, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, sca_core : Annotated[Optional[ScaCore], Field(description="Filters results by the SCA version.")] = None, wallet_set_id : Annotated[Optional[StrictStr], Field(description="Filter by the wallet set.")] = None, ref_id : Annotated[Optional[StrictStr], Field(description="Filter by the reference identifier.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> Wallets:  # noqa: E501
        """List wallets  # noqa: E501

        Retrieves a list of all wallets that fit the specified parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallets(address, blockchain, sca_core, wallet_set_id, ref_id, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param address: Filter by the blockchain address of the wallet.
        :type address: str
        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param sca_core: Filters results by the SCA version.
        :type sca_core: ScaCore
        :param wallet_set_id: Filter by the wallet set.
        :type wallet_set_id: str
        :param ref_id: Filter by the reference identifier.
        :type ref_id: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Wallets
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_wallets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_wallets_with_http_info(address, blockchain, sca_core, wallet_set_id, ref_id, var_from, to, page_before, page_after, page_size, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_wallets_with_http_info(self, address : Annotated[Optional[StrictStr], Field(description="Filter by the blockchain address of the wallet.")] = None, blockchain : Annotated[Optional[Blockchain], Field(description="Filter by blockchain.")] = None, sca_core : Annotated[Optional[ScaCore], Field(description="Filters results by the SCA version.")] = None, wallet_set_id : Annotated[Optional[StrictStr], Field(description="Filter by the wallet set.")] = None, ref_id : Annotated[Optional[StrictStr], Field(description="Filter by the reference identifier.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List wallets  # noqa: E501

        Retrieves a list of all wallets that fit the specified parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallets_with_http_info(address, blockchain, sca_core, wallet_set_id, ref_id, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param address: Filter by the blockchain address of the wallet.
        :type address: str
        :param blockchain: Filter by blockchain.
        :type blockchain: Blockchain
        :param sca_core: Filters results by the SCA version.
        :type sca_core: ScaCore
        :param wallet_set_id: Filter by the wallet set.
        :type wallet_set_id: str
        :param ref_id: Filter by the reference identifier.
        :type ref_id: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Wallets, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'address',
            'blockchain',
            'sca_core',
            'wallet_set_id',
            'ref_id',
            'var_from',
            'to',
            'page_before',
            'page_after',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wallets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('address') is not None:  # noqa: E501
            _query_params.append(('address', _params['address']))

        if _params.get('blockchain') is not None:  # noqa: E501
            _query_params.append(('blockchain', _params['blockchain'].value))

        if _params.get('sca_core') is not None:  # noqa: E501
            _query_params.append(('scaCore', _params['sca_core'].value))

        if _params.get('wallet_set_id') is not None:  # noqa: E501
            _query_params.append(('walletSetId', _params['wallet_set_id']))

        if _params.get('ref_id') is not None:  # noqa: E501
            _query_params.append(('refId', _params['ref_id']))

        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Wallets",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/wallets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def get_wallets_with_balances(self, blockchain : Annotated[Blockchain, Field(..., description="Filter by blockchain.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, address : Annotated[Optional[StrictStr], Field(description="Filter by the blockchain address of the wallet.")] = None, sca_core : Annotated[Optional[ScaCore], Field(description="Filters results by the SCA version.")] = None, wallet_set_id : Annotated[Optional[StrictStr], Field(description="Filter by the wallet set.")] = None, ref_id : Annotated[Optional[StrictStr], Field(description="Filter by the reference identifier.")] = None, amount__gte : Annotated[Optional[StrictStr], Field(description="Filters wallets with a balance greater than or equal to the specified amount. If `tokenAddress` is provided, the filter applies to the specified token; otherwise, it applies to the native token.")] = None, token_address : Annotated[Optional[StrictStr], Field(description="Filter by token address.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> WalletsWithBalances:  # noqa: E501
        """List wallets with balances  # noqa: E501

        Retrieves a list of wallets that match the specified parameters, including native token balances and, if specified, USDC/EURC balances. Balances update automatically with transfers or using the [Get token balance for a wallet](https://developers.circle.com/api-reference/w3s/developer-controlled-wallets/list-wallet-balance) endpoint for accuracy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallets_with_balances(blockchain, x_request_id, address, sca_core, wallet_set_id, ref_id, amount__gte, token_address, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain. (required)
        :type blockchain: Blockchain
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param address: Filter by the blockchain address of the wallet.
        :type address: str
        :param sca_core: Filters results by the SCA version.
        :type sca_core: ScaCore
        :param wallet_set_id: Filter by the wallet set.
        :type wallet_set_id: str
        :param ref_id: Filter by the reference identifier.
        :type ref_id: str
        :param amount__gte: Filters wallets with a balance greater than or equal to the specified amount. If `tokenAddress` is provided, the filter applies to the specified token; otherwise, it applies to the native token.
        :type amount__gte: str
        :param token_address: Filter by token address.
        :type token_address: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WalletsWithBalances
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_wallets_with_balances_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_wallets_with_balances_with_http_info(blockchain, x_request_id, address, sca_core, wallet_set_id, ref_id, amount__gte, token_address, var_from, to, page_before, page_after, page_size, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_wallets_with_balances_with_http_info(self, blockchain : Annotated[Blockchain, Field(..., description="Filter by blockchain.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, address : Annotated[Optional[StrictStr], Field(description="Filter by the blockchain address of the wallet.")] = None, sca_core : Annotated[Optional[ScaCore], Field(description="Filters results by the SCA version.")] = None, wallet_set_id : Annotated[Optional[StrictStr], Field(description="Filter by the wallet set.")] = None, ref_id : Annotated[Optional[StrictStr], Field(description="Filter by the reference identifier.")] = None, amount__gte : Annotated[Optional[StrictStr], Field(description="Filters wallets with a balance greater than or equal to the specified amount. If `tokenAddress` is provided, the filter applies to the specified token; otherwise, it applies to the native token.")] = None, token_address : Annotated[Optional[StrictStr], Field(description="Filter by token address.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List wallets with balances  # noqa: E501

        Retrieves a list of wallets that match the specified parameters, including native token balances and, if specified, USDC/EURC balances. Balances update automatically with transfers or using the [Get token balance for a wallet](https://developers.circle.com/api-reference/w3s/developer-controlled-wallets/list-wallet-balance) endpoint for accuracy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallets_with_balances_with_http_info(blockchain, x_request_id, address, sca_core, wallet_set_id, ref_id, amount__gte, token_address, var_from, to, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param blockchain: Filter by blockchain. (required)
        :type blockchain: Blockchain
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param address: Filter by the blockchain address of the wallet.
        :type address: str
        :param sca_core: Filters results by the SCA version.
        :type sca_core: ScaCore
        :param wallet_set_id: Filter by the wallet set.
        :type wallet_set_id: str
        :param ref_id: Filter by the reference identifier.
        :type ref_id: str
        :param amount__gte: Filters wallets with a balance greater than or equal to the specified amount. If `tokenAddress` is provided, the filter applies to the specified token; otherwise, it applies to the native token.
        :type amount__gte: str
        :param token_address: Filter by token address.
        :type token_address: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WalletsWithBalances, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'blockchain',
            'x_request_id',
            'address',
            'sca_core',
            'wallet_set_id',
            'ref_id',
            'amount__gte',
            'token_address',
            'var_from',
            'to',
            'page_before',
            'page_after',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wallets_with_balances" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('blockchain') is not None:  # noqa: E501
            _query_params.append(('blockchain', _params['blockchain'].value))

        if _params.get('address') is not None:  # noqa: E501
            _query_params.append(('address', _params['address']))

        if _params.get('sca_core') is not None:  # noqa: E501
            _query_params.append(('scaCore', _params['sca_core'].value))

        if _params.get('wallet_set_id') is not None:  # noqa: E501
            _query_params.append(('walletSetId', _params['wallet_set_id']))

        if _params.get('ref_id') is not None:  # noqa: E501
            _query_params.append(('refId', _params['ref_id']))

        if _params.get('amount__gte') is not None:  # noqa: E501
            _query_params.append(('amount__gte', _params['amount__gte']))

        if _params.get('token_address') is not None:  # noqa: E501
            _query_params.append(('tokenAddress', _params['token_address']))

        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WalletsWithBalances",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/wallets/balances', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def list_wallet_balance(self, id : Annotated[StrictStr, Field(..., description="Wallet ID")], include_all : Annotated[Optional[StrictBool], Field(description="Return all recourses with monitored and non-monitored tokens.")] = None, name : Annotated[Optional[StrictStr], Field(description="Filter by token name.")] = None, token_address : Annotated[Optional[StrictStr], Field(description="Filter by token address.")] = None, standard : Annotated[Optional[TokenStandard], Field(description="Filter by the token standard. ERC20/ERC721/ERC1155 are the standards for EVM chains, Fungible/FungibleAsset/NonFungible/NonFungibleEdition/ProgrammableNonFungible/ProgrammableNonFungibleEdition are the standards for the Solana chain.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> Balances:  # noqa: E501
        """Get token balance for a wallet  # noqa: E501

        Fetches the digital asset balance for a single developer-controlled wallet using its unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_wallet_balance(id, include_all, name, token_address, standard, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param id: Wallet ID (required)
        :type id: str
        :param include_all: Return all recourses with monitored and non-monitored tokens.
        :type include_all: bool
        :param name: Filter by token name.
        :type name: str
        :param token_address: Filter by token address.
        :type token_address: str
        :param standard: Filter by the token standard. ERC20/ERC721/ERC1155 are the standards for EVM chains, Fungible/FungibleAsset/NonFungible/NonFungibleEdition/ProgrammableNonFungible/ProgrammableNonFungibleEdition are the standards for the Solana chain.
        :type standard: TokenStandard
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Balances
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_wallet_balance_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_wallet_balance_with_http_info(id, include_all, name, token_address, standard, page_before, page_after, page_size, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def list_wallet_balance_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Wallet ID")], include_all : Annotated[Optional[StrictBool], Field(description="Return all recourses with monitored and non-monitored tokens.")] = None, name : Annotated[Optional[StrictStr], Field(description="Filter by token name.")] = None, token_address : Annotated[Optional[StrictStr], Field(description="Filter by token address.")] = None, standard : Annotated[Optional[TokenStandard], Field(description="Filter by the token standard. ERC20/ERC721/ERC1155 are the standards for EVM chains, Fungible/FungibleAsset/NonFungible/NonFungibleEdition/ProgrammableNonFungible/ProgrammableNonFungibleEdition are the standards for the Solana chain.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get token balance for a wallet  # noqa: E501

        Fetches the digital asset balance for a single developer-controlled wallet using its unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_wallet_balance_with_http_info(id, include_all, name, token_address, standard, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param id: Wallet ID (required)
        :type id: str
        :param include_all: Return all recourses with monitored and non-monitored tokens.
        :type include_all: bool
        :param name: Filter by token name.
        :type name: str
        :param token_address: Filter by token address.
        :type token_address: str
        :param standard: Filter by the token standard. ERC20/ERC721/ERC1155 are the standards for EVM chains, Fungible/FungibleAsset/NonFungible/NonFungibleEdition/ProgrammableNonFungible/ProgrammableNonFungibleEdition are the standards for the Solana chain.
        :type standard: TokenStandard
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Balances, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'include_all',
            'name',
            'token_address',
            'standard',
            'page_before',
            'page_after',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_wallet_balance" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('include_all') is not None:  # noqa: E501
            _query_params.append(('includeAll', _params['include_all']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('token_address') is not None:  # noqa: E501
            _query_params.append(('tokenAddress', _params['token_address']))

        if _params.get('standard') is not None:  # noqa: E501
            _query_params.append(('standard', _params['standard'].value))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Balances",
            '400': "Error",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/wallets/{id}/balances', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def list_wallet_nfts(self, id : Annotated[StrictStr, Field(..., description="Wallet ID")], include_all : Annotated[Optional[StrictBool], Field(description="Return all recourses with monitored and non-monitored tokens.")] = None, name : Annotated[Optional[StrictStr], Field(description="Filter by token name.")] = None, token_address : Annotated[Optional[StrictStr], Field(description="Filter by token address.")] = None, standard : Annotated[Optional[TokenStandard], Field(description="Filter by the token standard. ERC20/ERC721/ERC1155 are the standards for EVM chains, Fungible/FungibleAsset/NonFungible/NonFungibleEdition/ProgrammableNonFungible/ProgrammableNonFungibleEdition are the standards for the Solana chain.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> Nfts:  # noqa: E501
        """Get NFTs for a wallet  # noqa: E501

        Fetches the info for all NFTs stored in a single developer-controlled wallet, using the wallets unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_wallet_nfts(id, include_all, name, token_address, standard, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param id: Wallet ID (required)
        :type id: str
        :param include_all: Return all recourses with monitored and non-monitored tokens.
        :type include_all: bool
        :param name: Filter by token name.
        :type name: str
        :param token_address: Filter by token address.
        :type token_address: str
        :param standard: Filter by the token standard. ERC20/ERC721/ERC1155 are the standards for EVM chains, Fungible/FungibleAsset/NonFungible/NonFungibleEdition/ProgrammableNonFungible/ProgrammableNonFungibleEdition are the standards for the Solana chain.
        :type standard: TokenStandard
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Nfts
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_wallet_nfts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_wallet_nfts_with_http_info(id, include_all, name, token_address, standard, page_before, page_after, page_size, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def list_wallet_nfts_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Wallet ID")], include_all : Annotated[Optional[StrictBool], Field(description="Return all recourses with monitored and non-monitored tokens.")] = None, name : Annotated[Optional[StrictStr], Field(description="Filter by token name.")] = None, token_address : Annotated[Optional[StrictStr], Field(description="Filter by token address.")] = None, standard : Annotated[Optional[TokenStandard], Field(description="Filter by the token standard. ERC20/ERC721/ERC1155 are the standards for EVM chains, Fungible/FungibleAsset/NonFungible/NonFungibleEdition/ProgrammableNonFungible/ProgrammableNonFungibleEdition are the standards for the Solana chain.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get NFTs for a wallet  # noqa: E501

        Fetches the info for all NFTs stored in a single developer-controlled wallet, using the wallets unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_wallet_nfts_with_http_info(id, include_all, name, token_address, standard, page_before, page_after, page_size, async_req=True)
        >>> result = thread.get()

        :param id: Wallet ID (required)
        :type id: str
        :param include_all: Return all recourses with monitored and non-monitored tokens.
        :type include_all: bool
        :param name: Filter by token name.
        :type name: str
        :param token_address: Filter by token address.
        :type token_address: str
        :param standard: Filter by the token standard. ERC20/ERC721/ERC1155 are the standards for EVM chains, Fungible/FungibleAsset/NonFungible/NonFungibleEdition/ProgrammableNonFungible/ProgrammableNonFungibleEdition are the standards for the Solana chain.
        :type standard: TokenStandard
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Nfts, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'include_all',
            'name',
            'token_address',
            'standard',
            'page_before',
            'page_after',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_wallet_nfts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('include_all') is not None:  # noqa: E501
            _query_params.append(('includeAll', _params['include_all']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('token_address') is not None:  # noqa: E501
            _query_params.append(('tokenAddress', _params['token_address']))

        if _params.get('standard') is not None:  # noqa: E501
            _query_params.append(('standard', _params['standard'].value))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Nfts",
            '400': "Error",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/wallets/{id}/nfts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def update_wallet(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], update_wallet_request : Annotated[UpdateWalletRequest, Field(..., description="Schema for the request payload to update an existing wallet.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> WalletResponse:  # noqa: E501
        """Update a wallet  # noqa: E501

        Updates info metadata of a wallet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_wallet(id, update_wallet_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param update_wallet_request: Schema for the request payload to update an existing wallet. (required)
        :type update_wallet_request: UpdateWalletRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WalletResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_wallet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_wallet_with_http_info(id, update_wallet_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def update_wallet_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], update_wallet_request : Annotated[UpdateWalletRequest, Field(..., description="Schema for the request payload to update an existing wallet.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update a wallet  # noqa: E501

        Updates info metadata of a wallet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_wallet_with_http_info(id, update_wallet_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param update_wallet_request: Schema for the request payload to update an existing wallet. (required)
        :type update_wallet_request: UpdateWalletRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WalletResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'update_wallet_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_wallet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_wallet_request'] is not None:
            _body_params = _params['update_wallet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WalletResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/wallets/{id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
