# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field, StrictStr
from circle.web3.developer_controlled_wallets.models.token import Token

class Balance(BaseModel):
    """
    Balance
    """
    amount: StrictStr = Field(..., description="Token balance for each token in the wallet.")
    token: Token = Field(...)
    update_date: datetime = Field(..., alias="updateDate", description="Date and time the resource was last updated, in ISO-8601 UTC format.")
    __properties = ["amount", "token", "updateDate"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Balance:
        """Create an instance of Balance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of token
        if self.token:
            _dict['token'] = self.token.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Balance:
        """Create an instance of Balance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Balance.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = Balance.parse_obj({
            "amount": obj.get("amount"),
            "token": Token.from_dict(obj.get("token")) if obj.get("token") is not None else None,
            "update_date": obj.get("updateDate")
        })
        return _obj


