# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from circle.web3.developer_controlled_wallets.models.abi_parameters_inner import AbiParametersInner
from circle.web3.developer_controlled_wallets.models.contract_execution_blockchain import ContractExecutionBlockchain

class EstimateContractExecutionTransactionFeeRequest(BaseModel):
    """
    EstimateContractExecutionTransactionFeeRequest
    """
    abi_function_signature: Optional[StrictStr] = Field(None, alias="abiFunctionSignature", description="The contract ABI function signature or `callData` field is required for interacting with the smart contract. The ABI function signature cannot be used simultaneously with `callData`. e.g. burn(uint256)")
    abi_parameters: Optional[conlist(AbiParametersInner)] = Field(None, alias="abiParameters", description="The contract ABI function signature parameters for executing the contract interaction. Supported parameter types include string, integer, boolean, and array. These parameters should be used exclusively with the abiFunctionSignature and cannot be used with `callData`.")
    call_data: Optional[StrictStr] = Field(None, alias="callData", description="The raw transaction data, must be an even-length hexadecimal string with the `0x` prefix, to be executed. It is important to note that the usage of `callData` is mutually exclusive with the `abiFunctionSignature` and `abiParameters`. Therefore, `callData` cannot be utilized simultaneously with either `abiFunctionSignature` or `abiParameters`.")
    amount: Optional[StrictStr] = Field(None, description="The amount of native token that will be sent to the contract abi execution. Optional field for payable api only, if not provided, no native token will be sent.")
    blockchain: Optional[ContractExecutionBlockchain] = None
    contract_address: StrictStr = Field(..., alias="contractAddress", description="The blockchain address of the contract to be executed.")
    source_address: Optional[StrictStr] = Field(None, alias="sourceAddress", description="Source address of the transaction. Required along with `blockchain` if `walletId` is not provided.  The `sourceAddress` and `walletId` fields are mutually exclusive. ")
    wallet_id: Optional[StrictStr] = Field(None, alias="walletId", description="Unique system generated identifier of the wallet. Required when `sourceAddress` and `blockchain` are not provided.  Mutually exclusive with `sourceAddress` and `blockchain`.  For contract deploys this wallet ID will be used as the source. ")
    __properties = ["abiFunctionSignature", "abiParameters", "callData", "amount", "blockchain", "contractAddress", "sourceAddress", "walletId"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EstimateContractExecutionTransactionFeeRequest:
        """Create an instance of EstimateContractExecutionTransactionFeeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in abi_parameters (list)
        _items = []
        if self.abi_parameters:
            for _item in self.abi_parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['abiParameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EstimateContractExecutionTransactionFeeRequest:
        """Create an instance of EstimateContractExecutionTransactionFeeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EstimateContractExecutionTransactionFeeRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = EstimateContractExecutionTransactionFeeRequest.parse_obj({
            "abi_function_signature": obj.get("abiFunctionSignature"),
            "abi_parameters": [AbiParametersInner.from_dict(_item) for _item in obj.get("abiParameters")] if obj.get("abiParameters") is not None else None,
            "call_data": obj.get("callData"),
            "amount": obj.get("amount"),
            "blockchain": obj.get("blockchain"),
            "contract_address": obj.get("contractAddress"),
            "source_address": obj.get("sourceAddress"),
            "wallet_id": obj.get("walletId")
        })
        return _obj


