# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from circle.web3.developer_controlled_wallets.models.transaction_fee import TransactionFee

class EstimateTransactionFeeData(BaseModel):
    """
    EstimateTransactionFeeData
    """
    high: Optional[TransactionFee] = None
    low: Optional[TransactionFee] = None
    medium: Optional[TransactionFee] = None
    call_gas_limit: Optional[StrictStr] = Field(None, alias="callGasLimit", description="One of ERC-4337 gas fields. The amount of gas to allocate for the main execution call. Only in smart contract account estimation response.")
    verification_gas_limit: Optional[StrictStr] = Field(None, alias="verificationGasLimit", description="One of ERC-4337 gas fields. The amount of gas to allocate for the verification step. Only in smart contract account estimation response.")
    pre_verification_gas: Optional[StrictStr] = Field(None, alias="preVerificationGas", description="One of ERC-4337 gas fields. The amount of gas to pay to compensate the bundler for pre-verification execution and call data. Only in smart contract account estimation response.")
    __properties = ["high", "low", "medium", "callGasLimit", "verificationGasLimit", "preVerificationGas"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EstimateTransactionFeeData:
        """Create an instance of EstimateTransactionFeeData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of high
        if self.high:
            _dict['high'] = self.high.to_dict()
        # override the default output from pydantic by calling `to_dict()` of low
        if self.low:
            _dict['low'] = self.low.to_dict()
        # override the default output from pydantic by calling `to_dict()` of medium
        if self.medium:
            _dict['medium'] = self.medium.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EstimateTransactionFeeData:
        """Create an instance of EstimateTransactionFeeData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EstimateTransactionFeeData.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = EstimateTransactionFeeData.parse_obj({
            "high": TransactionFee.from_dict(obj.get("high")) if obj.get("high") is not None else None,
            "low": TransactionFee.from_dict(obj.get("low")) if obj.get("low") is not None else None,
            "medium": TransactionFee.from_dict(obj.get("medium")) if obj.get("medium") is not None else None,
            "call_gas_limit": obj.get("callGasLimit"),
            "verification_gas_limit": obj.get("verificationGasLimit"),
            "pre_verification_gas": obj.get("preVerificationGas")
        })
        return _obj


