# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictBytes, StrictStr

class SignMessageRequest(BaseModel):
    """
    SignMessageRequest
    """
    wallet_id: StrictStr = Field(..., alias="walletId", description="System-generated unique identifier of the resource.")
    encoded_by_hex: Optional[StrictBool] = Field(None, alias="encodedByHex", description="Indicator of whether the input message is encoded by hex. If TRUE, then the message should be a hex string. By default, it is False.")
    message: StrictStr = Field(..., description="The user friendly message that needs to be signed. If it is a hex string, encodedByHex needs to be TRUE. The hex string should start with “0x” and have even length.")
    memo: Optional[StrictStr] = Field(None, description="The human readable explanation for this sign action. Useful for presenting with extra information.")
    entity_secret_ciphertext: Union[StrictBytes, StrictStr] = Field(..., alias="entitySecretCiphertext", description="A base64 string expression of the entity secret ciphertext. The entity secret should be encrypted by the entity public key. Circle mandates that the entity secret ciphertext is unique for each API request. ")
    __properties = ["walletId", "encodedByHex", "message", "memo", "entitySecretCiphertext"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SignMessageRequest:
        """Create an instance of SignMessageRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SignMessageRequest:
        """Create an instance of SignMessageRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SignMessageRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = SignMessageRequest.parse_obj({
            "wallet_id": obj.get("walletId"),
            "encoded_by_hex": obj.get("encodedByHex"),
            "message": obj.get("message"),
            "memo": obj.get("memo"),
            "entity_secret_ciphertext": obj.get("entitySecretCiphertext")
        })
        return _obj


