# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBytes, StrictStr

class SignTypedDataRequest(BaseModel):
    """
    SignTypedDataRequest
    """
    wallet_id: StrictStr = Field(..., alias="walletId", description="System-generated unique identifier of the resource.")
    data: StrictStr = Field(..., description="A string represents the typed structured data in EIP-712")
    memo: Optional[StrictStr] = Field(None, description="The human readable explanation for this sign action. Useful for presenting with extra information.")
    entity_secret_ciphertext: Union[StrictBytes, StrictStr] = Field(..., alias="entitySecretCiphertext", description="A base64 string expression of the entity secret ciphertext. The entity secret should be encrypted by the entity public key. Circle mandates that the entity secret ciphertext is unique for each API request. ")
    __properties = ["walletId", "data", "memo", "entitySecretCiphertext"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SignTypedDataRequest:
        """Create an instance of SignTypedDataRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SignTypedDataRequest:
        """Create an instance of SignTypedDataRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SignTypedDataRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = SignTypedDataRequest.parse_obj({
            "wallet_id": obj.get("walletId"),
            "data": obj.get("data"),
            "memo": obj.get("memo"),
            "entity_secret_ciphertext": obj.get("entitySecretCiphertext")
        })
        return _obj


