# Copyright 2019 The Magenta Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Run inference for onset conditioned model."""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from magenta.models.onsets_frames_transcription import configs
from magenta.models.onsets_frames_transcription import infer
import tensorflow as tf


def main(argv):
  del argv

  infer.run(configs.CONFIG_MAP)


def console_entry_point():
  tf.app.flags.mark_flags_as_required(['model_dir', 'examples_path'])

  tf.app.run(main)

if __name__ == '__main__':
  console_entry_point()
