# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AppDomain',
    'SecretAzureContainerRegistry',
    'SecretDigitalOceanContainerRegistry',
    'SecretDockerHubRegistry',
    'SecretGithubRegistry',
    'SecretGitlabRegistry',
    'SecretPrivateRegistry',
    'ServiceDefinition',
    'ServiceDefinitionDocker',
    'ServiceDefinitionEnv',
    'ServiceDefinitionGit',
    'ServiceDefinitionGitBuildpack',
    'ServiceDefinitionGitDockerfile',
    'ServiceDefinitionHealthCheck',
    'ServiceDefinitionHealthCheckHttp',
    'ServiceDefinitionHealthCheckHttpHeader',
    'ServiceDefinitionHealthCheckTcp',
    'ServiceDefinitionInstanceType',
    'ServiceDefinitionPort',
    'ServiceDefinitionRoute',
    'ServiceDefinitionScaling',
    'ServiceDefinitionScalingTarget',
    'ServiceDefinitionScalingTargetAverageCpus',
    'ServiceDefinitionScalingTargetAverageMem',
    'ServiceDefinitionScalingTargetRequestsPerSecond',
    'GetAppDomainResult',
    'GetSecretAzureContainerRegistryResult',
    'GetSecretDigitalOceanContainerRegistryResult',
    'GetSecretDockerHubRegistryResult',
    'GetSecretGithubRegistryResult',
    'GetSecretGitlabRegistryResult',
    'GetSecretPrivateRegistryResult',
]

@pulumi.output_type
class AppDomain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appName":
            suggest = "app_name"
        elif key == "createdAt":
            suggest = "created_at"
        elif key == "deploymentGroup":
            suggest = "deployment_group"
        elif key == "intendedCname":
            suggest = "intended_cname"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "updatedAt":
            suggest = "updated_at"
        elif key == "verifiedAt":
            suggest = "verified_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDomain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDomain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDomain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 app_name: Optional[str] = None,
                 created_at: Optional[str] = None,
                 deployment_group: Optional[str] = None,
                 id: Optional[str] = None,
                 intended_cname: Optional[str] = None,
                 messages: Optional[str] = None,
                 organization_id: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None,
                 updated_at: Optional[str] = None,
                 verified_at: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str name: The domain name
        :param str app_name: The app name the domain is assigned to
        :param str created_at: The date and time of when the domain was created
        :param str deployment_group: The deployment group assigned to the domain
        :param str id: The domain ID
        :param str intended_cname: The CNAME record to point the domain to
        :param str messages: The status messages of the domain
        :param str organization_id: The organization ID owning the domain
        :param str status: The status of the domain
        :param str type: The domain type
        :param str updated_at: The date and time of when the domain was last updated
        :param str verified_at: The date and time of when the domain was last verified
        :param str version: The version of the domain
        """
        pulumi.set(__self__, "name", name)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deployment_group is not None:
            pulumi.set(__self__, "deployment_group", deployment_group)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if intended_cname is not None:
            pulumi.set(__self__, "intended_cname", intended_cname)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if verified_at is not None:
            pulumi.set(__self__, "verified_at", verified_at)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The domain name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[str]:
        """
        The app name the domain is assigned to
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time of when the domain was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deploymentGroup")
    def deployment_group(self) -> Optional[str]:
        """
        The deployment group assigned to the domain
        """
        return pulumi.get(self, "deployment_group")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The domain ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intendedCname")
    def intended_cname(self) -> Optional[str]:
        """
        The CNAME record to point the domain to
        """
        return pulumi.get(self, "intended_cname")

    @property
    @pulumi.getter
    def messages(self) -> Optional[str]:
        """
        The status messages of the domain
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[str]:
        """
        The organization ID owning the domain
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the domain
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The domain type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The date and time of when the domain was last updated
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="verifiedAt")
    def verified_at(self) -> Optional[str]:
        """
        The date and time of when the domain was last verified
        """
        return pulumi.get(self, "verified_at")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the domain
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SecretAzureContainerRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryName":
            suggest = "registry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretAzureContainerRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretAzureContainerRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretAzureContainerRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 registry_name: str,
                 username: str):
        """
        :param str password: The registry password
        :param str registry_name: The registry name
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "registry_name", registry_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> str:
        """
        The registry name
        """
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretDigitalOceanContainerRegistry(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The registry password
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretDockerHubRegistry(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The registry password
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretGithubRegistry(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The registry password
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretGitlabRegistry(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The registry password
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretPrivateRegistry(dict):
    def __init__(__self__, *,
                 password: str,
                 url: str,
                 username: str):
        """
        :param str password: The registry password
        :param str url: The registry url
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The registry url
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceTypes":
            suggest = "instance_types"
        elif key == "healthChecks":
            suggest = "health_checks"
        elif key == "skipCache":
            suggest = "skip_cache"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_types: Sequence['outputs.ServiceDefinitionInstanceType'],
                 name: str,
                 ports: Sequence['outputs.ServiceDefinitionPort'],
                 regions: Sequence[str],
                 scalings: Sequence['outputs.ServiceDefinitionScaling'],
                 docker: Optional['outputs.ServiceDefinitionDocker'] = None,
                 envs: Optional[Sequence['outputs.ServiceDefinitionEnv']] = None,
                 git: Optional['outputs.ServiceDefinitionGit'] = None,
                 health_checks: Optional[Sequence['outputs.ServiceDefinitionHealthCheck']] = None,
                 routes: Optional[Sequence['outputs.ServiceDefinitionRoute']] = None,
                 skip_cache: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param str name: The service name
        :param Sequence[str] regions: The service deployment regions to deploy to
        :param bool skip_cache: If set to true, the service will be deployed without using the cache
        :param str type: The service type, either WEB or WORKER (default WEB)
        """
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "scalings", scalings)
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if skip_cache is not None:
            pulumi.set(__self__, "skip_cache", skip_cache)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Sequence['outputs.ServiceDefinitionInstanceType']:
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The service name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.ServiceDefinitionPort']:
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        """
        The service deployment regions to deploy to
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def scalings(self) -> Sequence['outputs.ServiceDefinitionScaling']:
        return pulumi.get(self, "scalings")

    @property
    @pulumi.getter
    def docker(self) -> Optional['outputs.ServiceDefinitionDocker']:
        return pulumi.get(self, "docker")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.ServiceDefinitionEnv']]:
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.ServiceDefinitionGit']:
        return pulumi.get(self, "git")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[Sequence['outputs.ServiceDefinitionHealthCheck']]:
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.ServiceDefinitionRoute']]:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="skipCache")
    def skip_cache(self) -> Optional[bool]:
        """
        If set to true, the service will be deployed without using the cache
        """
        return pulumi.get(self, "skip_cache")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The service type, either WEB or WORKER (default WEB)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceDefinitionDocker(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageRegistrySecret":
            suggest = "image_registry_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDefinitionDocker. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDefinitionDocker.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDefinitionDocker.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 command: Optional[str] = None,
                 entrypoints: Optional[Sequence[str]] = None,
                 image_registry_secret: Optional[str] = None,
                 privileged: Optional[bool] = None):
        """
        :param str image: The Docker image to use to support your service
        :param Sequence[str] args: The Docker args to use
        :param str command: The Docker command to use
        :param Sequence[str] entrypoints: The Docker entrypoint to use
        :param str image_registry_secret: The Koyeb secret containing the container registry credentials
        :param bool privileged: When enabled, the service container will run in privileged mode. This advanced feature is useful to get advanced system privileges.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if entrypoints is not None:
            pulumi.set(__self__, "entrypoints", entrypoints)
        if image_registry_secret is not None:
            pulumi.set(__self__, "image_registry_secret", image_registry_secret)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The Docker image to use to support your service
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        The Docker args to use
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[str]:
        """
        The Docker command to use
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def entrypoints(self) -> Optional[Sequence[str]]:
        """
        The Docker entrypoint to use
        """
        return pulumi.get(self, "entrypoints")

    @property
    @pulumi.getter(name="imageRegistrySecret")
    def image_registry_secret(self) -> Optional[str]:
        """
        The Koyeb secret containing the container registry credentials
        """
        return pulumi.get(self, "image_registry_secret")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[bool]:
        """
        When enabled, the service container will run in privileged mode. This advanced feature is useful to get advanced system privileges.
        """
        return pulumi.get(self, "privileged")


@pulumi.output_type
class ServiceDefinitionEnv(dict):
    def __init__(__self__, *,
                 key: str,
                 scopes: Optional[Sequence[str]] = None,
                 secret: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable
        :param Sequence[str] scopes: The regions the environment variable needs to be exposed
        :param str secret: The secret name to use as the value of the environment variable
        :param str value: The value of the environment variable
        """
        pulumi.set(__self__, "key", key)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the environment variable
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        The regions the environment variable needs to be exposed
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def secret(self) -> Optional[str]:
        """
        The secret name to use as the value of the environment variable
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceDefinitionGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noDeployOnPush":
            suggest = "no_deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDefinitionGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDefinitionGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDefinitionGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: str,
                 repository: str,
                 buildpack: Optional['outputs.ServiceDefinitionGitBuildpack'] = None,
                 dockerfile: Optional['outputs.ServiceDefinitionGitDockerfile'] = None,
                 no_deploy_on_push: Optional[bool] = None,
                 workdir: Optional[str] = None):
        """
        :param str branch: The GitHub branch to deploy
        :param str repository: The GitHub repository to deploy
        :param bool no_deploy_on_push: If set to true, no Koyeb deployments will be triggered when changes are pushed to the GitHub repository branch
        :param str workdir: The directory where your source code is located. If not set, the work directory defaults to the root of the repository.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "repository", repository)
        if buildpack is not None:
            pulumi.set(__self__, "buildpack", buildpack)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if no_deploy_on_push is not None:
            pulumi.set(__self__, "no_deploy_on_push", no_deploy_on_push)
        if workdir is not None:
            pulumi.set(__self__, "workdir", workdir)

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        The GitHub branch to deploy
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The GitHub repository to deploy
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def buildpack(self) -> Optional['outputs.ServiceDefinitionGitBuildpack']:
        return pulumi.get(self, "buildpack")

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional['outputs.ServiceDefinitionGitDockerfile']:
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter(name="noDeployOnPush")
    def no_deploy_on_push(self) -> Optional[bool]:
        """
        If set to true, no Koyeb deployments will be triggered when changes are pushed to the GitHub repository branch
        """
        return pulumi.get(self, "no_deploy_on_push")

    @property
    @pulumi.getter
    def workdir(self) -> Optional[str]:
        """
        The directory where your source code is located. If not set, the work directory defaults to the root of the repository.
        """
        return pulumi.get(self, "workdir")


@pulumi.output_type
class ServiceDefinitionGitBuildpack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "runCommand":
            suggest = "run_command"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDefinitionGitBuildpack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDefinitionGitBuildpack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDefinitionGitBuildpack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_command: Optional[str] = None,
                 privileged: Optional[bool] = None,
                 run_command: Optional[str] = None):
        """
        :param str build_command: The command to build your application during the build phase. If your application does not require a build command, leave this field empty
        :param bool privileged: When enabled, the service container will run in privileged mode. This advanced feature is useful to get advanced system privileges.
        :param str run_command: The command to run your application once the built is completed
        """
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        The command to build your application during the build phase. If your application does not require a build command, leave this field empty
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[bool]:
        """
        When enabled, the service container will run in privileged mode. This advanced feature is useful to get advanced system privileges.
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        The command to run your application once the built is completed
        """
        return pulumi.get(self, "run_command")


@pulumi.output_type
class ServiceDefinitionGitDockerfile(dict):
    def __init__(__self__, *,
                 args: Optional[Sequence[str]] = None,
                 command: Optional[str] = None,
                 dockerfile: Optional[str] = None,
                 entrypoints: Optional[Sequence[str]] = None,
                 privileged: Optional[bool] = None,
                 target: Optional[str] = None):
        """
        :param Sequence[str] args: The arguments to pass to the Docker command
        :param str command: Override the command to execute on the container
        :param str dockerfile: The location of your Dockerfile relative to the work directory. If not set, the work directory defaults to the root of the repository.
        :param Sequence[str] entrypoints: Override the default entrypoint to execute on the container
        :param bool privileged: When enabled, the service container will run in privileged mode. This advanced feature is useful to get advanced system privileges.
        :param str target: Target build stage: If your Dockerfile contains multi-stage builds, you can choose the target stage to build and deploy by entering its name
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if entrypoints is not None:
            pulumi.set(__self__, "entrypoints", entrypoints)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        The arguments to pass to the Docker command
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[str]:
        """
        Override the command to execute on the container
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[str]:
        """
        The location of your Dockerfile relative to the work directory. If not set, the work directory defaults to the root of the repository.
        """
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter
    def entrypoints(self) -> Optional[Sequence[str]]:
        """
        Override the default entrypoint to execute on the container
        """
        return pulumi.get(self, "entrypoints")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[bool]:
        """
        When enabled, the service container will run in privileged mode. This advanced feature is useful to get advanced system privileges.
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Target build stage: If your Dockerfile contains multi-stage builds, you can choose the target stage to build and deploy by entering its name
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ServiceDefinitionHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracePeriod":
            suggest = "grace_period"
        elif key == "restartLimit":
            suggest = "restart_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDefinitionHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDefinitionHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDefinitionHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grace_period: Optional[int] = None,
                 http: Optional['outputs.ServiceDefinitionHealthCheckHttp'] = None,
                 interval: Optional[int] = None,
                 restart_limit: Optional[int] = None,
                 tcp: Optional['outputs.ServiceDefinitionHealthCheckTcp'] = None,
                 timeout: Optional[int] = None):
        """
        :param int grace_period: The period in seconds to wait for the instance to become healthy, default is 5s
        :param int interval: The period in seconds between two health checks, default is 60s
        :param int restart_limit: The number of consecutive failures before attempting to restart the service, default is 3
        :param int timeout: The maximum time to wait in seconds before considering the check as a failure, default is 5s
        """
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if restart_limit is not None:
            pulumi.set(__self__, "restart_limit", restart_limit)
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[int]:
        """
        The period in seconds to wait for the instance to become healthy, default is 5s
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.ServiceDefinitionHealthCheckHttp']:
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The period in seconds between two health checks, default is 60s
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="restartLimit")
    def restart_limit(self) -> Optional[int]:
        """
        The number of consecutive failures before attempting to restart the service, default is 3
        """
        return pulumi.get(self, "restart_limit")

    @property
    @pulumi.getter
    def tcp(self) -> Optional['outputs.ServiceDefinitionHealthCheckTcp']:
        return pulumi.get(self, "tcp")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The maximum time to wait in seconds before considering the check as a failure, default is 5s
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ServiceDefinitionHealthCheckHttp(dict):
    def __init__(__self__, *,
                 path: str,
                 port: int,
                 headers: Optional[Sequence['outputs.ServiceDefinitionHealthCheckHttpHeader']] = None,
                 method: Optional[str] = None):
        """
        :param str path: The path to use to perform the HTTP health check
        :param int port: The port to use to perform the health check
        :param str method: An optional HTTP method to use to perform the health check, default is GET
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to use to perform the HTTP health check
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port to use to perform the health check
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ServiceDefinitionHealthCheckHttpHeader']]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        An optional HTTP method to use to perform the health check, default is GET
        """
        return pulumi.get(self, "method")


@pulumi.output_type
class ServiceDefinitionHealthCheckHttpHeader(dict):
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        :param str key: The name of the header
        :param str value: The value of the header
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the header
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the header
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceDefinitionHealthCheckTcp(dict):
    def __init__(__self__, *,
                 port: int):
        """
        :param int port: The port to use to perform the health check
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port to use to perform the health check
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceDefinitionInstanceType(dict):
    def __init__(__self__, *,
                 type: str,
                 scopes: Optional[Sequence[str]] = None):
        """
        :param str type: The instance type to use to support your service
        :param Sequence[str] scopes: The regions to use the instance type
        """
        pulumi.set(__self__, "type", type)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The instance type to use to support your service
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        The regions to use the instance type
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class ServiceDefinitionPort(dict):
    def __init__(__self__, *,
                 port: int,
                 protocol: str):
        """
        :param int port: The internal port on which this service's run command will listen
        :param str protocol: The protocol used by your service
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The internal port on which this service's run command will listen
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used by your service
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ServiceDefinitionRoute(dict):
    def __init__(__self__, *,
                 path: str,
                 port: int):
        """
        :param str path: Path specifies a route by HTTP path prefix. Paths must start with / and must be unique within the app
        :param int port: The internal port on which this service's run command will listen
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path specifies a route by HTTP path prefix. Paths must start with / and must be unique within the app
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The internal port on which this service's run command will listen
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceDefinitionScaling(dict):
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None,
                 scopes: Optional[Sequence[str]] = None,
                 targets: Optional[Sequence['outputs.ServiceDefinitionScalingTarget']] = None):
        """
        :param int max: The maximum number of instance to use to support your service
        :param int min: The minimal number of instances to use to support your service
        :param Sequence[str] scopes: The regions to apply the scaling configuration
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        The maximum number of instance to use to support your service
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        The minimal number of instances to use to support your service
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        The regions to apply the scaling configuration
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.ServiceDefinitionScalingTarget']]:
        return pulumi.get(self, "targets")


@pulumi.output_type
class ServiceDefinitionScalingTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageCpus":
            suggest = "average_cpus"
        elif key == "averageMems":
            suggest = "average_mems"
        elif key == "requestsPerSeconds":
            suggest = "requests_per_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDefinitionScalingTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDefinitionScalingTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDefinitionScalingTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average_cpus: Optional[Sequence['outputs.ServiceDefinitionScalingTargetAverageCpus']] = None,
                 average_mems: Optional[Sequence['outputs.ServiceDefinitionScalingTargetAverageMem']] = None,
                 requests_per_seconds: Optional[Sequence['outputs.ServiceDefinitionScalingTargetRequestsPerSecond']] = None):
        """
        :param Sequence['ServiceDefinitionScalingTargetAverageCpusArgs'] average_cpus: The CPU usage (expressed as a percentage) across all Instances of your Service within a region
        :param Sequence['ServiceDefinitionScalingTargetAverageMemArgs'] average_mems: The memory usage (expressed as a percentage) across all Instances of your Service within a region
        :param Sequence['ServiceDefinitionScalingTargetRequestsPerSecondArgs'] requests_per_seconds: The number of concurrent requests per second across all Instances of your Service within a region
        """
        if average_cpus is not None:
            pulumi.set(__self__, "average_cpus", average_cpus)
        if average_mems is not None:
            pulumi.set(__self__, "average_mems", average_mems)
        if requests_per_seconds is not None:
            pulumi.set(__self__, "requests_per_seconds", requests_per_seconds)

    @property
    @pulumi.getter(name="averageCpus")
    def average_cpus(self) -> Optional[Sequence['outputs.ServiceDefinitionScalingTargetAverageCpus']]:
        """
        The CPU usage (expressed as a percentage) across all Instances of your Service within a region
        """
        return pulumi.get(self, "average_cpus")

    @property
    @pulumi.getter(name="averageMems")
    def average_mems(self) -> Optional[Sequence['outputs.ServiceDefinitionScalingTargetAverageMem']]:
        """
        The memory usage (expressed as a percentage) across all Instances of your Service within a region
        """
        return pulumi.get(self, "average_mems")

    @property
    @pulumi.getter(name="requestsPerSeconds")
    def requests_per_seconds(self) -> Optional[Sequence['outputs.ServiceDefinitionScalingTargetRequestsPerSecond']]:
        """
        The number of concurrent requests per second across all Instances of your Service within a region
        """
        return pulumi.get(self, "requests_per_seconds")


@pulumi.output_type
class ServiceDefinitionScalingTargetAverageCpus(dict):
    def __init__(__self__, *,
                 value: int):
        """
        :param int value: The target value of the autoscaling target
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        The target value of the autoscaling target
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceDefinitionScalingTargetAverageMem(dict):
    def __init__(__self__, *,
                 value: int):
        """
        :param int value: The target value of the autoscaling target
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        The target value of the autoscaling target
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceDefinitionScalingTargetRequestsPerSecond(dict):
    def __init__(__self__, *,
                 value: int):
        """
        :param int value: The target value of the autoscaling target
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> int:
        """
        The target value of the autoscaling target
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppDomainResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 deployment_group: str,
                 id: str,
                 intended_cname: str,
                 messages: str,
                 name: str,
                 organization_id: str,
                 status: str,
                 type: str,
                 updated_at: str,
                 verified_at: str,
                 version: str,
                 app_name: Optional[str] = None):
        """
        :param str created_at: The date and time of when the domain was created
        :param str deployment_group: The deployment group assigned to the domain
        :param str id: The domain ID
        :param str intended_cname: The CNAME record to point the domain to
        :param str messages: The status messages of the domain
        :param str name: The domain name
        :param str organization_id: The organization ID owning the domain
        :param str status: The status of the domain
        :param str type: The domain type
        :param str updated_at: The date and time of when the domain was last updated
        :param str verified_at: The date and time of when the domain was last verified
        :param str version: The version of the domain
        :param str app_name: The app name the domain is assigned to
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "deployment_group", deployment_group)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "intended_cname", intended_cname)
        pulumi.set(__self__, "messages", messages)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "verified_at", verified_at)
        pulumi.set(__self__, "version", version)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date and time of when the domain was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deploymentGroup")
    def deployment_group(self) -> str:
        """
        The deployment group assigned to the domain
        """
        return pulumi.get(self, "deployment_group")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The domain ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intendedCname")
    def intended_cname(self) -> str:
        """
        The CNAME record to point the domain to
        """
        return pulumi.get(self, "intended_cname")

    @property
    @pulumi.getter
    def messages(self) -> str:
        """
        The status messages of the domain
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The domain name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization ID owning the domain
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the domain
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The domain type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The date and time of when the domain was last updated
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="verifiedAt")
    def verified_at(self) -> str:
        """
        The date and time of when the domain was last verified
        """
        return pulumi.get(self, "verified_at")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the domain
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[str]:
        """
        The app name the domain is assigned to
        """
        return pulumi.get(self, "app_name")


@pulumi.output_type
class GetSecretAzureContainerRegistryResult(dict):
    def __init__(__self__, *,
                 password: str,
                 registry_name: str,
                 username: str):
        """
        :param str password: The registry password
        :param str registry_name: The registry name
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "registry_name", registry_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> str:
        """
        The registry name
        """
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSecretDigitalOceanContainerRegistryResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The registry password
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSecretDockerHubRegistryResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The registry password
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSecretGithubRegistryResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The registry password
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSecretGitlabRegistryResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The registry password
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetSecretPrivateRegistryResult(dict):
    def __init__(__self__, *,
                 password: str,
                 url: str,
                 username: str):
        """
        :param str password: The registry password
        :param str url: The registry url
        :param str username: The registry username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The registry password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The registry url
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The registry username
        """
        return pulumi.get(self, "username")


