/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import io.ray.api.BaseActorHandle;
import io.ray.api.exception.RayIntentionalSystemExitException;
import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.ObjectId;
import io.ray.api.id.UniqueId;
import io.ray.api.options.ActorLifetime;
import io.ray.api.runtimecontext.ResourceValue;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.context.NativeWorkerContext;
import io.ray.runtime.functionmanager.FunctionManager;
import io.ray.runtime.gcs.GcsClient;
import io.ray.runtime.gcs.GcsClientOptions;
import io.ray.runtime.generated.Common;
import io.ray.runtime.generated.Gcs;
import io.ray.runtime.object.NativeObjectStore;
import io.ray.runtime.runner.RunManager;
import io.ray.runtime.task.NativeTaskExecutor;
import io.ray.runtime.task.NativeTaskSubmitter;
import io.ray.runtime.task.TaskExecutor;
import io.ray.runtime.util.JniUtils;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RayNativeRuntime
extends AbstractRayRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(RayNativeRuntime.class);
    private boolean startRayHead = false;
    private GcsClient gcsClient;
    private final ReadWriteLock shutdownLock = new ReentrantReadWriteLock();

    public RayNativeRuntime(RayConfig rayConfig) {
        super(rayConfig);
    }

    private void updateSessionDir() {
        String sessionDir = this.getGcsClient().getInternalKV("session", "session_dir");
        Preconditions.checkNotNull(sessionDir);
        this.rayConfig.setSessionDir(sessionDir);
    }

    @Override
    public void start() {
        try {
            if (this.rayConfig.workerMode == Common.WorkerType.DRIVER && this.rayConfig.getBootstrapAddress() == null) {
                this.startRayHead = true;
                RunManager.startRayHead(this.rayConfig);
            }
            Preconditions.checkNotNull(this.rayConfig.getBootstrapAddress());
            if (this.rayConfig.workerMode == Common.WorkerType.DRIVER) {
                String tmpDir = "/tmp/ray/".concat(String.valueOf(System.currentTimeMillis()));
                JniUtils.loadLibrary(tmpDir, "core_worker_library_java", true);
                this.updateSessionDir();
                Preconditions.checkNotNull(this.rayConfig.sessionDir);
            } else {
                Preconditions.checkNotNull(this.rayConfig.sessionDir);
                JniUtils.loadLibrary(this.rayConfig.sessionDir, "core_worker_library_java", true);
            }
            if (this.rayConfig.workerMode == Common.WorkerType.DRIVER) {
                Gcs.GcsNodeInfo nodeInfo = this.getGcsClient().getNodeToConnectForDriver(this.rayConfig.nodeIp);
                this.rayConfig.rayletSocketName = nodeInfo.getRayletSocketName();
                this.rayConfig.objectStoreSocketName = nodeInfo.getObjectStoreSocketName();
                this.rayConfig.nodeManagerPort = nodeInfo.getNodeManagerPort();
            }
            if (this.rayConfig.workerMode == Common.WorkerType.DRIVER && this.rayConfig.getJobId() == JobId.NIL) {
                this.rayConfig.setJobId(this.getGcsClient().nextJobId());
            }
            this.functionManager = new FunctionManager(this.rayConfig.codeSearchPath);
            byte[] serializedJobConfig = null;
            if (this.rayConfig.workerMode == Common.WorkerType.DRIVER) {
                Common.JobConfig.Builder jobConfigBuilder = Common.JobConfig.newBuilder().addAllJvmOptions(this.rayConfig.jvmOptionsForJavaWorker).addAllCodeSearchPath(this.rayConfig.codeSearchPath).setRayNamespace(this.rayConfig.namespace);
                jobConfigBuilder.setRuntimeEnvInfo(this.rayConfig.runtimeEnvImpl.GenerateRuntimeEnvInfo());
                jobConfigBuilder.setDefaultActorLifetime(this.rayConfig.defaultActorLifetime == ActorLifetime.DETACHED ? Common.JobConfig.ActorLifetime.DETACHED : Common.JobConfig.ActorLifetime.NON_DETACHED);
                serializedJobConfig = jobConfigBuilder.build().toByteArray();
            }
            RayNativeRuntime.nativeInitialize(this.rayConfig.workerMode.getNumber(), this.rayConfig.nodeIp, this.rayConfig.getNodeManagerPort(), this.rayConfig.workerMode == Common.WorkerType.DRIVER ? System.getProperty("user.dir") : "", this.rayConfig.objectStoreSocketName, this.rayConfig.rayletSocketName, (this.rayConfig.workerMode == Common.WorkerType.DRIVER ? this.rayConfig.getJobId() : JobId.NIL).getBytes(), new GcsClientOptions(this.rayConfig), this.rayConfig.logDir, serializedJobConfig, this.rayConfig.getStartupToken(), this.rayConfig.runtimeEnvHash);
            this.taskExecutor = new NativeTaskExecutor(this);
            this.workerContext = new NativeWorkerContext();
            this.objectStore = new NativeObjectStore(this.workerContext, this.shutdownLock);
            this.taskSubmitter = new NativeTaskSubmitter();
            LOGGER.debug("RayNativeRuntime started with store {}, raylet {}", (Object)this.rayConfig.objectStoreSocketName, (Object)this.rayConfig.rayletSocketName);
        }
        catch (Exception e) {
            if (this.startRayHead) {
                try {
                    RunManager.stopRay();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public void shutdown() {
        Lock writeLock = this.shutdownLock.writeLock();
        writeLock.lock();
        try {
            if (this.rayConfig.workerMode == Common.WorkerType.DRIVER) {
                RayNativeRuntime.nativeShutdown();
                if (this.startRayHead) {
                    this.startRayHead = false;
                    RunManager.stopRay();
                }
            }
            if (null != this.gcsClient) {
                this.gcsClient.destroy();
                this.gcsClient = null;
            }
            LOGGER.debug("RayNativeRuntime shutdown");
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public <T extends BaseActorHandle> Optional<T> getActor(String name, String namespace) {
        if (name.isEmpty()) {
            return Optional.empty();
        }
        byte[] actorIdBytes = RayNativeRuntime.nativeGetActorIdOfNamedActor(name, namespace);
        ActorId actorId = ActorId.fromBytes(actorIdBytes);
        if (actorId.isNil()) {
            return Optional.empty();
        }
        return Optional.of(this.getActorHandle(actorId));
    }

    @Override
    public void killActor(BaseActorHandle actor, boolean noRestart) {
        RayNativeRuntime.nativeKillActor(actor.getId().getBytes(), noRestart);
    }

    @Override
    List<ObjectId> getCurrentReturnIds(int numReturns, ActorId actorId) {
        List<byte[]> ret = RayNativeRuntime.nativeGetCurrentReturnIds(numReturns, actorId.getBytes());
        return ret.stream().map(ObjectId::new).collect(Collectors.toList());
    }

    @Override
    public void exitActor() {
        if (this.rayConfig.workerMode != Common.WorkerType.WORKER || this.runtimeContext.getCurrentActorId().isNil()) {
            throw new RuntimeException("This shouldn't be called on a non-actor worker.");
        }
        LOGGER.info("Actor {} is exiting.", (Object)this.runtimeContext.getCurrentActorId());
        throw new RayIntentionalSystemExitException(String.format("Actor %s is exiting.", this.runtimeContext.getCurrentActorId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GcsClient getGcsClient() {
        if (this.gcsClient == null) {
            RayNativeRuntime rayNativeRuntime = this;
            synchronized (rayNativeRuntime) {
                if (this.gcsClient == null) {
                    this.gcsClient = new GcsClient(this.rayConfig.getBootstrapAddress(), this.rayConfig.redisPassword);
                }
            }
        }
        return this.gcsClient;
    }

    @Override
    public void run() {
        Preconditions.checkState(this.rayConfig.workerMode == Common.WorkerType.WORKER);
        RayNativeRuntime.nativeRunTaskExecutor(this.taskExecutor);
    }

    @Override
    public Map<String, List<ResourceValue>> getAvailableResourceIds() {
        return RayNativeRuntime.nativeGetResourceIds();
    }

    @Override
    public String getNamespace() {
        return RayNativeRuntime.nativeGetNamespace();
    }

    @Override
    public UniqueId getCurrentNodeId() {
        return UniqueId.fromBytes(RayNativeRuntime.nativeGetCurrentNodeId());
    }

    private static native void nativeInitialize(int var0, String var1, int var2, String var3, String var4, String var5, byte[] var6, GcsClientOptions var7, String var8, byte[] var9, int var10, int var11);

    private static native void nativeRunTaskExecutor(TaskExecutor var0);

    private static native void nativeShutdown();

    private static native void nativeKillActor(byte[] var0, boolean var1);

    private static native byte[] nativeGetActorIdOfNamedActor(String var0, String var1);

    private static native Map<String, List<ResourceValue>> nativeGetResourceIds();

    private static native String nativeGetNamespace();

    private static native List<byte[]> nativeGetCurrentReturnIds(int var0, byte[] var1);

    private static native byte[] nativeGetCurrentNodeId();
}

