"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .locale_response import LocaleResponse
from .metadata import Metadata, MetadataTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityCustomerTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""The full name of the customer."""
    email: NotRequired[Nullable[str]]
    r"""The email address of the customer."""
    locale: NotRequired[Nullable[LocaleResponse]]
    r"""Allows you to preset the language to be used."""
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class EntityCustomer(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""The full name of the customer."""

    email: OptionalNullable[str] = UNSET
    r"""The email address of the customer."""

    locale: Annotated[
        OptionalNullable[LocaleResponse], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""Allows you to preset the language to be used."""

    metadata: OptionalNullable[Metadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "email", "locale", "metadata", "testmode"]
        nullable_fields = ["name", "email", "locale", "metadata", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
