# coding: utf-8

"""
    LocalStack REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 4.8.1
    Contact: info@localstack.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from localstack.sdk.models.cloud_watch_metrics_metrics_inner_d_inner import CloudWatchMetricsMetricsInnerDInner
from localstack.sdk.models.cloud_watch_metrics_metrics_inner_t import CloudWatchMetricsMetricsInnerT
from localstack.sdk.models.cloud_watch_metrics_metrics_inner_v import CloudWatchMetricsMetricsInnerV
from typing import Optional, Set
from typing_extensions import Self

class CloudWatchMetricsMetricsInner(BaseModel):
    """
    CloudWatchMetricsMetricsInner
    """ # noqa: E501
    account: StrictStr = Field(description="Account ID")
    d: List[CloudWatchMetricsMetricsInnerDInner] = Field(description="Dimensions")
    n: StrictStr = Field(description="Metric name")
    ns: StrictStr = Field(description="Namespace")
    region: StrictStr = Field(description="Region name")
    t: CloudWatchMetricsMetricsInnerT
    v: CloudWatchMetricsMetricsInnerV
    __properties: ClassVar[List[str]] = ["account", "d", "n", "ns", "region", "t", "v"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CloudWatchMetricsMetricsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in d (list)
        _items = []
        if self.d:
            for _item_d in self.d:
                if _item_d:
                    _items.append(_item_d.to_dict())
            _dict['d'] = _items
        # override the default output from pydantic by calling `to_dict()` of t
        if self.t:
            _dict['t'] = self.t.to_dict()
        # override the default output from pydantic by calling `to_dict()` of v
        if self.v:
            _dict['v'] = self.v.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CloudWatchMetricsMetricsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "account": obj.get("account"),
            "d": [CloudWatchMetricsMetricsInnerDInner.from_dict(_item) for _item in obj["d"]] if obj.get("d") is not None else None,
            "n": obj.get("n"),
            "ns": obj.get("ns"),
            "region": obj.get("region"),
            "t": CloudWatchMetricsMetricsInnerT.from_dict(obj["t"]) if obj.get("t") is not None else None,
            "v": CloudWatchMetricsMetricsInnerV.from_dict(obj["v"]) if obj.get("v") is not None else None
        })
        return _obj


