/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.builder;

import edu.iris.Fissures.seed.builder.BuilderFilter;
import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.BlocketteFactory;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedBlocketteRankMap;
import edu.iris.Fissures.seed.container.SeedDictionaryReferenceMap;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.BuilderException;
import java.io.Serializable;
import java.util.Vector;

public class SeedObjectBuilder
extends ObjectBuilder {
    private byte[] prevRecord;
    private byte[] nextRecord;
    private float seedVersion = 2.3f;
    private boolean swapFlag = false;
    private int[] sequenceTracker = new int[]{0, 0, 0, 0, 0, 0, 0};
    private int dataBlocketteOffset = 0;
    private Blockette recycleBlockette = null;

    public SeedObjectBuilder() {
        this.buildContainer = new SeedObjectContainer();
        this.builderType = "SEED";
    }

    public SeedObjectBuilder(String string) throws BuilderException {
        try {
            this.buildContainer = new SeedObjectContainer(string);
            this.builderType = "SEED";
        }
        catch (Exception exception) {
            throw new BuilderException("Exception encountered: " + exception);
        }
    }

    public int build(byte[] byArray) throws Exception {
        if (byArray.length == 0) {
            throw new BuilderException("zero length record data in build() call");
        }
        byte[] byArray2 = byArray;
        int n = 0;
        Blockette blockette = null;
        switch (this.recordType) {
            case 'A': 
            case 'S': 
            case 'T': 
            case 'V': {
                if (this.prevRecord != null && this.continuationFlag) {
                    byArray2 = new byte[this.prevRecord.length + byArray.length];
                    System.arraycopy(this.prevRecord, 0, byArray2, 0, this.prevRecord.length);
                    System.arraycopy(byArray, 0, byArray2, this.prevRecord.length, byArray.length);
                }
                if (this.recycleBlockette != null) {
                    this.recycleBlockette.initialize(byArray2, false, false, this.seedVersion);
                    blockette = this.recycleBlockette;
                } else {
                    blockette = BlocketteFactory.createBlockette(byArray2, false, false, this.seedVersion);
                }
                if (blockette == null) {
                    throw new BuilderException("Blockette Factory returned a null value");
                }
                int n2 = blockette.getType();
                if (n2 == 5 || n2 == 8 || n2 == 10) {
                    this.seedVersion = Float.parseFloat(blockette.toString(3));
                    blockette.initialize(byArray2, false, false, this.seedVersion);
                }
                if (blockette.isIncomplete()) {
                    this.prevRecord = new byte[byArray2.length];
                    System.arraycopy(byArray2, 0, this.prevRecord, 0, byArray2.length);
                    n = byArray2.length;
                    this.currentObject = null;
                    this.recycleBlockette = blockette;
                    break;
                }
                n = this.prevRecord == null ? blockette.getNumBytes() : blockette.getNumBytes() - this.prevRecord.length;
                this.prevRecord = null;
                this.currentObject = blockette;
                break;
            }
            case 'D': 
            case 'Q': 
            case 'R': {
                Object object;
                this.prevRecord = null;
                if (this.recordBeginFlag) {
                    this.dataBlocketteOffset = 0;
                    if (byArray2.length < 40) {
                        throw new BuilderException("data record is too short (" + byArray2.length + ")");
                    }
                    byte[] byArray3 = new byte[10];
                    System.arraycopy(byArray2, 12, byArray3, 0, 10);
                    Btime btime = new Btime(byArray3);
                    this.swapFlag = btime.getSwapFlag();
                    object = new byte[2];
                    if (this.swapFlag) {
                        object[0] = -25;
                        object[1] = 3;
                    } else {
                        object[0] = 3;
                        object[1] = -25;
                    }
                    byte[] byArray4 = new byte[8];
                    byArray4[0] = (byte)this.recordType;
                    this.continuationFlag = byArray4[1] == 42;
                    for (int i = 2; i < 8; ++i) {
                        byArray4[i] = 32;
                    }
                    Btime btime2 = new Btime();
                    byArray2 = new byte[byArray.length + 20];
                    System.arraycopy(object, 0, byArray2, 0, 2);
                    System.arraycopy(byArray4, 0, byArray2, 2, 8);
                    System.arraycopy(btime2.getByteTime(), 0, byArray2, 10, 10);
                    System.arraycopy(byArray, 0, byArray2, 20, byArray.length);
                    this.recordBeginFlag = false;
                }
                if (this.recycleBlockette != null) {
                    this.recycleBlockette.initialize(byArray2, this.swapFlag, true, this.seedVersion);
                    blockette = this.recycleBlockette;
                } else {
                    blockette = BlocketteFactory.createBlockette(byArray2, this.swapFlag, true, this.seedVersion);
                }
                if (blockette == null) {
                    throw new BuilderException("Blockette Factory returned a null value");
                }
                if (blockette.getType() == 999) {
                    int n3;
                    this.dataBlocketteOffset = Integer.parseInt(blockette.toString(18));
                    n = this.dataBlocketteOffset - 8;
                    if (this.dataBlocketteOffset == 0) {
                        n = byArray2.length;
                    }
                    if ((n3 = Integer.parseInt(blockette.toString(17))) > 48) {
                        int n4 = Integer.parseInt(blockette.toString(9));
                        object = new Waveform(byArray2, n3 + 12, n4, "UNKNOWN", this.swapFlag);
                        blockette.attachWaveform((Waveform)object);
                    }
                } else {
                    int n5 = Integer.parseInt(blockette.toString(2));
                    if (n5 > 0) {
                        n = n5 - this.dataBlocketteOffset;
                        if (n <= 0) {
                            throw new BuilderException("regressive data blockette offset " + n5 + " at byte offset " + this.dataBlocketteOffset);
                        }
                        this.dataBlocketteOffset = n5;
                    } else {
                        n = byArray2.length;
                    }
                }
                this.currentObject = blockette;
                break;
            }
            default: {
                throw new BuilderException("Unable to identify recordType" + this.recordType);
            }
        }
        this.filterBlockette();
        return n;
    }

    public int build(String string) throws Exception {
        if (string == null) {
            throw new BuilderException("blockette specification string in build() call is null");
        }
        int n = string.length();
        if (n == 0) {
            throw new BuilderException("zero length blockette specification string in build() call");
        }
        this.currentObject = BlocketteFactory.createBlockette(string);
        if (this.currentObject == null) {
            throw new BuilderException("Blockette Factory returned a null value");
        }
        this.filterBlockette();
        return n;
    }

    public int store() throws Exception {
        int n;
        int n2;
        if (this.currentObject == null) {
            return -1;
        }
        if (this.volumeNumber > 214) {
            throw new BuilderException("volumeNumber is too high.  must be value 000-214");
        }
        int n3 = this.volumeNumber * 1000 * 1000 * 10;
        int n4 = SeedBlocketteRankMap.getHeaderCode((Blockette)this.currentObject);
        int n5 = n4 * 1000 * 1000;
        if (n4 > 6) {
            throw new BuilderException("header category code for lookup ID exceeds 6");
        }
        int n6 = ((Blockette)this.currentObject).getType();
        int n7 = -1;
        if (n4 == 2) {
            n2 = SeedDictionaryReferenceMap.lookupDestFld(n6);
            n = Integer.parseInt(((Blockette)this.currentObject).toString(n2));
            n7 = n3 + n5 + n6 * 1000 * 10 + n;
        } else {
            n2 = this.getSequenceNum(n4);
            if (n2 > 999999) {
                throw new BuilderException("sequence number for lookup ID exceeds 999999");
            }
            n7 = n3 + n5 + n2;
        }
        ((Blockette)this.currentObject).setLookupId(n7);
        int[] nArray = SeedDictionaryReferenceMap.lookupSourceFld(n6);
        for (n = 0; nArray != null && n < nArray.length; ++n) {
            int[] nArray2 = SeedDictionaryReferenceMap.lookupDestBlk(n6, nArray[n]);
            for (int i = 0; nArray2 != null && i < nArray2.length; ++i) {
                int n8 = ((Blockette)this.currentObject).getFieldRepeat(nArray[n]);
                int n9 = 0;
                if (((Blockette)this.currentObject).getFieldType(nArray[n]).equals("L")) {
                    n8 = ((Blockette)this.currentObject).getFieldRepeat(n8);
                }
                n9 = n8 == 0 ? 1 : Integer.parseInt(((Blockette)this.currentObject).toString(n8));
                Vector vector = null;
                int[] nArray3 = null;
                Serializable serializable = null;
                for (int j = 0; j < n9; ++j) {
                    int n10;
                    if (((Blockette)this.currentObject).getFieldType(nArray[n]).equals("L")) {
                        vector = (Vector)((Blockette)this.currentObject).getFieldVal(nArray[n], j);
                        nArray3 = new int[vector.size()];
                        for (n10 = 0; n10 < vector.size(); ++n10) {
                            nArray3[n10] = Integer.parseInt(vector.get(n10).toString());
                        }
                    } else {
                        nArray3 = new int[]{Integer.parseInt(((Blockette)this.currentObject).toString(nArray[n], j))};
                    }
                    for (n10 = 0; n10 < nArray3.length; ++n10) {
                        int n11 = nArray3[n10];
                        int n12 = 0;
                        if (n11 > 0) {
                            int n13 = n3 + 2000000 + nArray2[i] * 1000 * 10 + n11;
                            n12 = ((Blockette)this.currentObject).addDictionaryLookup(n13);
                        }
                        if (nArray3.length > 1) {
                            vector.set(n10, new Integer(n12));
                            serializable = vector;
                            continue;
                        }
                        serializable = new Integer(n12);
                    }
                    ((Blockette)this.currentObject).setFieldVal(nArray[n], j, serializable);
                }
            }
        }
        this.buildContainer.add(this.currentObject);
        this.recycleBlockette = null;
        this.currentObject = null;
        return n7;
    }

    public void reset() {
        this.currentObject = null;
        this.prevRecord = null;
        this.nextRecord = null;
        this.seedVersion = 2.3f;
        this.swapFlag = false;
        for (int i = 0; i < this.sequenceTracker.length; ++i) {
            this.sequenceTracker[i] = 0;
        }
    }

    private boolean filterBlockette() throws Exception {
        int n = this.buildFilterVector.size();
        boolean bl = false;
        if (this.currentObject != null && n != 0) {
            BuilderFilter builderFilter;
            int n2;
            for (n2 = 0; n2 < n && !(bl = (builderFilter = (BuilderFilter)this.buildFilterVector.get(n2)).qualify(this.currentObject)); ++n2) {
            }
            n2 = ((SeedObjectContainer)this.buildContainer).getFiltered();
            int n3 = SeedBlocketteRankMap.getRank((Blockette)this.currentObject);
            if (n2 > 0 && n3 >= n2) {
                bl = false;
            }
            if (!bl) {
                ((SeedObjectContainer)this.buildContainer).setFiltered((Blockette)this.currentObject);
                this.recycleBlockette = (Blockette)this.currentObject;
                this.currentObject = null;
            } else if (n2 > 0) {
                ((SeedObjectContainer)this.buildContainer).setFiltered(0);
            }
        }
        return bl;
    }

    private int getSequenceNum(int n) throws BuilderException {
        if (n > 6) {
            throw new BuilderException("header code greater than 6");
        }
        int n2 = this.sequenceTracker[n];
        int n3 = n;
        this.sequenceTracker[n3] = this.sequenceTracker[n3] + 1;
        return n2;
    }
}

