/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import net.alomax.awt.AJLColor;

public class AJLButton
extends Component {
    protected String label = "";
    protected boolean repeat = false;
    protected boolean inButton = false;
    protected boolean mouseDown = false;
    protected boolean notifiedListener = false;
    protected ActionListener listener = null;
    protected TimeMonitor timeMonitor = null;
    protected Color controlText = AJLColor.controlText;
    protected Color control = AJLColor.control;
    protected Color controlHighlight = AJLColor.controlHighlight;
    protected Color controlShadow = AJLColor.controlShadow;
    protected Color controlButtonHighlight = this.controlHighlight;

    public AJLButton(String string) {
        this.setLabel(string);
        this.enableEvents(48L);
        this.setColors(AJLColor.controlText, AJLColor.control);
    }

    public AJLButton(ActionListener actionListener, KeyListener keyListener, String string) {
        this(string);
        this.addActionListener(actionListener);
        this.addKeyListener(keyListener);
    }

    public AJLButton(ActionListener actionListener, KeyListener keyListener, String string, boolean bl) {
        this(actionListener, keyListener, string);
        this.repeat = bl;
    }

    public void setColors(Color color, Color color2) {
        if (color != null) {
            this.controlText = color;
        }
        super.setForeground(this.controlText);
        if (color2 != null) {
            this.control = color2;
            this.controlButtonHighlight = AJLColor.lighter(AJLColor.lighter(AJLColor.lighter(color2)));
        }
        super.setBackground(this.control);
    }

    public void setColorsInverted() {
        this.setColors(AJLColor.control, AJLColor.controlText);
        this.repaint();
    }

    public void setColorsDefault() {
        this.setColors(AJLColor.controlText, AJLColor.control);
        this.repaint();
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listener = AWTEventMulticaster.add(this.listener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listener = AWTEventMulticaster.remove(this.listener, actionListener);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        graphics2.setFont(this.getFont());
        super.paint(graphics2);
        Dimension dimension = this.getSize();
        this.paintBackground(graphics2, dimension);
        this.paintLabel(graphics2, dimension);
        this.paintBorder(graphics2, dimension);
        graphics2.dispose();
    }

    public void paintBackground(Graphics graphics, Dimension dimension) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public void paintLabel(Graphics graphics, Dimension dimension) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = (dimension.width - fontMetrics.stringWidth(this.label)) / 2;
        int n2 = dimension.height / 2 + (fontMetrics.getAscent() + fontMetrics.getDescent()) / 2 - fontMetrics.getDescent();
        if (this.isEnabled()) {
            graphics.setColor(this.controlText);
            graphics.drawString(this.label, n, n2);
        } else {
            graphics.setColor(this.controlHighlight);
            graphics.drawString(this.label, n + 1, n2 + 1);
            graphics.setColor(this.controlShadow);
            graphics.drawString(this.label, n, n2);
        }
    }

    public void paintBorder(Graphics graphics, Dimension dimension) {
        if (this.isEnabled() && this.mouseDown) {
            graphics.setColor(this.controlHighlight);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(this.controlShadow);
            graphics.drawLine(0, 0, dimension.width - 2, 0);
            graphics.drawLine(0, 0, 0, dimension.height - 2);
        } else {
            graphics.setColor(this.controlHighlight);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(this.controlButtonHighlight);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 2);
            graphics.setColor(this.controlShadow);
            graphics.drawRect(0, 0, dimension.width - 2, dimension.height - 2);
        }
    }

    public void setEnabled(boolean bl) {
        if (super.isEnabled() != bl) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    protected void processActionEvent(ActionEvent actionEvent) {
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.mouseDown = true;
                    this.notifiedListener = false;
                    if (this.repeat) {
                        this.timeMonitor = new TimeMonitor(200L, 50L);
                        this.timeMonitor.start();
                    }
                    this.repaint();
                    break;
                }
                case 502: {
                    if (this.timeMonitor != null) {
                        this.timeMonitor.stopRunning = true;
                    }
                    this.timeMonitor = null;
                    if (!this.notifiedListener) {
                        this.notifyListener();
                    }
                    this.mouseDown = false;
                    this.repaint();
                    break;
                }
                case 505: {
                    if (this.timeMonitor != null) {
                        this.timeMonitor.stopRunning = true;
                    }
                    this.timeMonitor = null;
                    this.mouseDown = false;
                    this.repaint();
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void notifyListener() {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 1001, ""));
        }
        this.notifiedListener = true;
    }

    public Rectangle getDrawingRectangle() {
        Dimension dimension = this.getSize();
        return new Rectangle(2, 2, dimension.width - 4, dimension.height - 4);
    }

    public Dimension getPreferredSize() {
        String string = this.getLabel();
        if (string != null) {
            return this.getSize(string + "m");
        }
        return this.getSize("m");
    }

    public Dimension getMinimumSize() {
        String string = this.getLabel();
        if (string != null) {
            return this.getSize(string);
        }
        return this.getSize("m");
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected Dimension getSize(String string) {
        int n;
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = this.getFontMetrics(this.getFont());
        }
        catch (Exception exception) {
            return new Dimension(1, 1);
        }
        int n2 = n = 6 * (fontMetrics.getAscent() + fontMetrics.getDescent()) / 4;
        if (string != null) {
            n2 = fontMetrics.stringWidth(string);
        }
        return new Dimension(n2, n);
    }

    class TimeMonitor
    extends Thread {
        protected boolean stopRunning = false;
        private long sleepTime = 200L;
        private long initSleepTime = 400L;

        TimeMonitor(long l, long l2) {
            if (l > 0L) {
                this.initSleepTime = l;
            }
            if (l2 > 0L) {
                this.sleepTime = l2;
            }
        }

        public void run() {
            long l = this.initSleepTime;
            try {
                while (true) {
                    if (this.stopRunning) {
                        return;
                    }
                    if (this.sleepTime > 0L) {
                        TimeMonitor.sleep(l);
                    }
                    l = this.sleepTime;
                    if (this.stopRunning) {
                        return;
                    }
                    AJLButton.this.notifyListener();
                }
            }
            catch (Exception exception) {
                String string = this.getClass().getName() + ": " + exception;
                System.out.println(string);
                return;
            }
        }
    }
}

