/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics2d;

import JSci.awt.DefaultGraph2DModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.alomax.graphics2d.JLineGraphAJL;
import net.alomax.math.Cmplx;
import net.alomax.swing.AJLJNumberTextField;
import net.alomax.swing.ApplicationJComp;
import net.alomax.swing.JBasicFrame;
import net.alomax.swing.SwingText;

public class SpectralDisplay
extends JBasicFrame {
    protected static final int DISPLAY_MODE_LOGLOG = 0;
    protected static final int DISPLAY_MODE_LOGLIN = 1;
    protected static final int DISPLAY_MODE_LINLOG = 2;
    protected static final int DISPLAY_MODE_LINLIN = 3;
    protected static final int DISPLAY_MODE_EQUILOGLOG = 4;
    protected static final String[] modeNames = new String[]{"LogLog", "LogLin", "LinLog", "LinLin", "EquiLogLog"};
    protected static int displayModeDefault = 0;
    protected int displayMode = displayModeDefault;
    protected JComboBox displayModeList = null;
    protected static final int DISPLAY_TYPE_MAGNITUDE = 0;
    protected static final int DISPLAY_TYPE_PHASE = 1;
    protected static final int DISPLAY_TYPE_REAL = 2;
    protected static final int DISPLAY_TYPE_IMAGINARY = 3;
    protected static final int DISPLAY_TYPE_SPECTRAL_DENSITY = 4;
    protected static final String[] typeNames = new String[]{"Magnitude", "Phase", "Real", "Imaginary", "SpectralDensity"};
    protected static int displayTypeDefault = 0;
    protected int displayType = displayTypeDefault;
    protected JComboBox displayTypeList = null;
    protected static final Double AXIS_VALUE_NAN = new Double(Double.NaN);
    protected AJLJNumberTextField xMinTextField;
    protected AJLJNumberTextField xMaxTextField;
    protected AJLJNumberTextField yMinTextField;
    protected AJLJNumberTextField yMaxTextField;
    protected JLineGraphAJL frameGraph = null;
    protected ApplicationJComp parent = null;
    protected String title = "";
    protected String ampUnits = "";
    protected double dt = 1.0;
    protected Cmplx[] cx = new Cmplx[0];
    protected Color traceColor = Color.RED;
    protected Color foregroundColor = Color.WHITE;
    protected Color gridLineColor = Color.DARK_GRAY;
    protected Color backgroundColor = Color.BLACK;
    protected static final double INV_LOG_10 = 1.0 / Math.log(10.0);
    protected static final double TWO_PI = Math.PI * 2;

    public static int typeFor(String string) {
        string = string.toUpperCase();
        for (int i = 0; i < typeNames.length; ++i) {
            if (!typeNames[i].toUpperCase().startsWith(string)) continue;
            return i;
        }
        return 0;
    }

    public static int modeFor(String string) {
        string = string.toUpperCase();
        for (int i = 0; i < modeNames.length; ++i) {
            if (!modeNames[i].toUpperCase().startsWith(string)) continue;
            return i;
        }
        return 0;
    }

    public SpectralDisplay(ApplicationJComp applicationJComp, String string, String string2, double d, Cmplx[] cmplxArray, int n, int n2, Color color, Color color2, Color color3, Color color4, int n3, int n4, Image image) {
        super(applicationJComp, "SpectralDisplay - " + string, false, image);
        this.setVisible(false);
        this.parent = applicationJComp;
        this.title = string;
        this.ampUnits = new String(string2);
        this.dt = d;
        this.cx = new Cmplx[cmplxArray.length];
        System.arraycopy(cmplxArray, 0, this.cx, 0, cmplxArray.length);
        this.traceColor = color;
        this.gridLineColor = color3;
        this.foregroundColor = color2;
        this.backgroundColor = color4;
        if (n2 >= 0) {
            this.displayMode = n2;
        } else {
            try {
                this.displayMode = SpectralDisplay.modeFor(applicationJComp.getParameter("freq.spectral.mode"));
            }
            catch (Exception exception) {
                this.displayMode = displayModeDefault;
            }
        }
        if (n >= 0) {
            this.displayType = n;
        } else {
            try {
                this.displayType = SpectralDisplay.typeFor(applicationJComp.getParameter("freq.spectral.type"));
            }
            catch (Exception exception) {
                this.displayType = displayTypeDefault;
            }
        }
        JPanel jPanel = new JPanel(new FlowLayout());
        this.displayModeList = new JComboBox<String>(modeNames);
        this.displayModeList.setSelectedIndex(this.displayMode);
        this.displayModeList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                displayModeDefault = SpectralDisplay.this.displayMode = SpectralDisplay.modeFor((String)SpectralDisplay.this.displayModeList.getSelectedItem());
                SpectralDisplay.this.resetAxisRanges(false, true);
                SpectralDisplay.this.display();
            }
        });
        jPanel.add(new JLabel(" Mode:"));
        jPanel.add(this.displayModeList);
        this.displayTypeList = new JComboBox<String>(typeNames);
        this.displayTypeList.setSelectedIndex(this.displayType);
        this.displayTypeList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = SpectralDisplay.this.displayType;
                displayTypeDefault = SpectralDisplay.this.displayType = SpectralDisplay.typeFor((String)SpectralDisplay.this.displayTypeList.getSelectedItem());
                SpectralDisplay.this.resetAxisRanges((n + SpectralDisplay.this.displayType) % 2 != 0, true);
                SpectralDisplay.this.display();
            }
        });
        jPanel.add(new JLabel(" Type (Y-X):"));
        jPanel.add(this.displayTypeList);
        jPanel.add(new JSeparator(1));
        jPanel.add(new JLabel(" Axis Range Y:"));
        this.yMinTextField = new AJLJNumberTextField(AXIS_VALUE_NAN, 8);
        jPanel.add(this.yMinTextField);
        this.yMinTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.valueOf(SpectralDisplay.this.yMinTextField.getText());
                    SpectralDisplay.this.display();
                }
                catch (Exception exception) {
                    SpectralDisplay.this.parent.writeMessage(SwingText.ERROR + " " + SwingText.INVALID_VALUE + "Y axis minimum");
                }
            }
        });
        this.yMaxTextField = new AJLJNumberTextField(AXIS_VALUE_NAN, 8);
        jPanel.add(this.yMaxTextField);
        this.yMaxTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.valueOf(SpectralDisplay.this.yMaxTextField.getText());
                    SpectralDisplay.this.display();
                }
                catch (Exception exception) {
                    SpectralDisplay.this.parent.writeMessage(SwingText.ERROR + " " + SwingText.INVALID_VALUE + "Y axis maximum");
                }
            }
        });
        jPanel.add(new JLabel(" X:"));
        this.xMinTextField = new AJLJNumberTextField(AXIS_VALUE_NAN, 8);
        jPanel.add(this.xMinTextField);
        this.xMinTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.valueOf(SpectralDisplay.this.xMinTextField.getText());
                    SpectralDisplay.this.display();
                }
                catch (Exception exception) {
                    SpectralDisplay.this.parent.writeMessage(SwingText.ERROR + " " + SwingText.INVALID_VALUE + "X axis minimum");
                }
            }
        });
        this.xMaxTextField = new AJLJNumberTextField(AXIS_VALUE_NAN, 8);
        jPanel.add(this.xMaxTextField);
        this.xMaxTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.valueOf(SpectralDisplay.this.xMaxTextField.getText());
                    SpectralDisplay.this.display();
                }
                catch (Exception exception) {
                    SpectralDisplay.this.parent.writeMessage(SwingText.ERROR + " " + SwingText.INVALID_VALUE + "X axis maximum");
                }
            }
        });
        JButton jButton = new JButton(SwingText.RESET);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectralDisplay.this.xMinTextField.setValue(AXIS_VALUE_NAN);
                SpectralDisplay.this.xMaxTextField.setValue(AXIS_VALUE_NAN);
                SpectralDisplay.this.yMinTextField.setValue(AXIS_VALUE_NAN);
                SpectralDisplay.this.yMaxTextField.setValue(AXIS_VALUE_NAN);
                SpectralDisplay.this.display();
            }
        });
        jPanel.add(jButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "South");
        this.display();
        this.setDefaultSize(n3, n4);
        this.setVisible(true);
    }

    protected void resetAxisRanges(boolean bl, boolean bl2) {
        if (bl) {
            this.xMinTextField.setValue(AXIS_VALUE_NAN);
            this.xMaxTextField.setValue(AXIS_VALUE_NAN);
        }
        if (bl2) {
            this.yMinTextField.setValue(AXIS_VALUE_NAN);
            this.yMaxTextField.setValue(AXIS_VALUE_NAN);
        }
    }

    protected void display() {
        this.display(null, false);
    }

    public void display(Graphics graphics, boolean bl) {
        int n;
        double d;
        int n2;
        int n3 = this.cx.length;
        double d2 = 1.0 / ((double)n3 * this.dt);
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double[] dArray = new double[n3 / 2];
        double d5 = d2;
        if (this.displayMode == 2 || this.displayMode == 0 || this.displayMode == 4) {
            for (n2 = 0; n2 < n3 / 2; ++n2) {
                dArray[n2] = d = Math.log(d5) * INV_LOG_10;
                d3 = Math.min(d3, d);
                d4 = Math.max(d4, d);
                d5 += d2;
            }
        } else {
            for (n2 = 0; n2 < n3 / 2; ++n2) {
                dArray[n2] = d = d5;
                d3 = Math.min(d3, d);
                d4 = Math.max(d4, d);
                d5 += d2;
            }
        }
        try {
            double d6 = Double.valueOf(this.xMinTextField.getText());
            if (!Double.isNaN(d6)) {
                d3 = d6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            double d7 = Double.valueOf(this.xMaxTextField.getText());
            if (!Double.isNaN(d7)) {
                d4 = d7;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xMinTextField.setValue((double)((float)d3));
        this.xMaxTextField.setValue((double)((float)d4));
        DefaultGraph2DModel defaultGraph2DModel = new DefaultGraph2DModel();
        defaultGraph2DModel.setXAxis(dArray);
        defaultGraph2DModel.addSeries(dArray);
        JLineGraphAJL jLineGraphAJL = null;
        if (!bl && this.frameGraph != null) {
            this.getContentPane().remove(this.frameGraph);
        }
        jLineGraphAJL = new JLineGraphAJL(defaultGraph2DModel);
        if (bl) {
            jLineGraphAJL.setForeground(Color.BLACK);
            jLineGraphAJL.setGridLineColor(Color.GRAY);
            jLineGraphAJL.setBackground(Color.WHITE);
            jLineGraphAJL.setColor(0, Color.BLACK);
        } else {
            jLineGraphAJL.setForeground(this.foregroundColor);
            jLineGraphAJL.setGridLineColor(this.gridLineColor);
            jLineGraphAJL.setBackground(this.backgroundColor);
            jLineGraphAJL.setColor(0, this.traceColor);
            jLineGraphAJL.setDisplayCursorPosition(true);
        }
        jLineGraphAJL.setXScale(0);
        if (this.displayMode == 2 || this.displayMode == 0 || this.displayMode == 4) {
            jLineGraphAJL.setXAxisUnitsLabel("log(Hz)");
        } else {
            jLineGraphAJL.setXAxisUnitsLabel("Hz");
        }
        jLineGraphAJL.setAxisLines(true, true);
        jLineGraphAJL.setGridLines(true);
        String string = "";
        String string2 = "";
        double d8 = Double.MAX_VALUE;
        double d9 = -1.7976931348623157E308;
        double[] dArray2 = new double[n3 / 2];
        if (this.displayType == 0) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n] = this.cx[n + 1].mag();
                d8 = Math.min(d8, dArray2[n]);
                d9 = Math.max(d9, dArray2[n]);
            }
            string = "Spectral Magnitude";
            string2 = this.ampUnits;
        } else if (this.displayType == 1) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n] = this.cx[n + 1].phs() * 57.29577951308232;
                d8 = Math.min(d8, dArray2[n]);
                d9 = Math.max(d9, dArray2[n]);
            }
            string = "Spectral Phase";
            string2 = "deg";
        } else if (this.displayType == 2) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n] = this.cx[n + 1].r;
                d8 = Math.min(d8, dArray2[n]);
                d9 = Math.max(d9, dArray2[n]);
            }
            string = "Spectral Real";
            string2 = this.ampUnits;
        } else if (this.displayType == 3) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n] = this.cx[n + 1].i;
                d8 = Math.min(d8, dArray2[n]);
                d9 = Math.max(d9, dArray2[n]);
            }
            string = "Spectral Imag";
            string2 = this.ampUnits;
        } else if (this.displayType == 4) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n] = this.cx[n + 1].mag2() / (Math.PI * 2);
                d8 = Math.min(d8, dArray2[n]);
                d9 = Math.max(d9, dArray2[n]);
            }
            string = "Spectral Density";
            string2 = this.ampUnits + "**2";
        }
        jLineGraphAJL.setYScale(0);
        if (this.displayMode == 1 || this.displayMode == 0 || this.displayMode == 4) {
            d8 = Double.MAX_VALUE;
            d9 = -1.7976931348623157E308;
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n] = Math.log(dArray2[n]) * INV_LOG_10;
                d8 = Math.min(d8, dArray2[n]);
                d9 = Math.max(d9, dArray2[n]);
            }
            string2 = "log(" + string2 + ")";
        }
        try {
            double d10 = Double.valueOf(this.yMaxTextField.getText());
            if (!Double.isNaN(d10)) {
                d9 = d10;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.displayMode == 4) {
                d8 = d9 - (d4 - d3);
            } else {
                double d11 = Double.valueOf(this.yMinTextField.getText());
                if (!Double.isNaN(d11)) {
                    d8 = d11;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.yMinTextField.setValue((double)((float)d8));
        this.yMaxTextField.setValue((double)((float)d9));
        jLineGraphAJL.setXExtrema(d3, d4);
        jLineGraphAJL.setYExtrema(d8, d9);
        defaultGraph2DModel.changeSeries(0, dArray2);
        jLineGraphAJL.setTitle(string + "  -  " + this.title);
        jLineGraphAJL.setYAxisUnitsLabel(string2);
        if (bl) {
            jLineGraphAJL.print(graphics);
        } else {
            this.getContentPane().add((Component)jLineGraphAJL, "Center");
            this.setVisible(true);
            this.frameGraph = jLineGraphAJL;
        }
    }

    public void windowIsClosing() {
    }
}

