/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.alomax.util.BinaryType;

public class BinaryOutputStream
extends DataOutputStream {
    public int binaryType;

    public BinaryOutputStream(OutputStream outputStream, String string) {
        super(outputStream);
        this.binaryType = BinaryType.stringToBinaryType(string);
    }

    public BinaryOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.binaryType = BinaryType.intToBinaryType(n);
    }

    public final void writeShortB(short s) throws IOException {
        switch (this.binaryType) {
            case 1: {
                short s2 = s;
                this.writeShort((short)(s2 << 8 | s2 >>> 8));
                return;
            }
        }
        this.writeShort(s);
    }

    public final void writeIntB(int n) throws IOException {
        switch (this.binaryType) {
            case 1: {
                int n2 = n << 24 | n >> 8 << 24 >>> 8 | n >> 16 << 24 >>> 16 | n >>> 24;
                this.writeInt(n2);
                return;
            }
        }
        this.writeInt(n);
    }

    public final void writeFloatB(float f) throws IOException {
        switch (this.binaryType) {
            case 1: {
                this.writeIntB(Float.floatToIntBits(f));
                return;
            }
        }
        this.writeFloat(f);
    }
}

