/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import net.alomax.io.ASCIIFileOutputStream;

public class LogFile {
    protected String logFileName = "log.txt";
    protected ASCIIFileOutputStream afos = null;
    protected boolean persistent = false;

    public LogFile(String string) {
        this(string, false);
    }

    public LogFile(String string, boolean bl) {
        this.logFileName = string;
        this.persistent = bl;
    }

    public String getName() {
        return this.logFileName;
    }

    public int write(String string) {
        block9: {
            if (this.afos == null) {
                try {
                    File file = null;
                    if (this.persistent && (file = new File(this.logFileName)).exists()) {
                        File file2 = new File(this.logFileName + ".tmp");
                        file.renameTo(file2);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                        this.afos = new ASCIIFileOutputStream(this.logFileName);
                        int n = 0;
                        while ((n = bufferedInputStream.read()) >= 0) {
                            this.afos.write(n);
                        }
                        bufferedInputStream.close();
                        file2.delete();
                        break block9;
                    }
                    try {
                        new File(this.logFileName).getParentFile().mkdirs();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.afos = new ASCIIFileOutputStream(this.logFileName);
                }
                catch (Exception exception) {
                    System.err.println("ERROR: Opening log file: " + this.logFileName + ": " + exception);
                    exception.printStackTrace();
                    return -1;
                }
            }
        }
        try {
            this.afos.writeWord(string);
            this.afos.writeWord("\n");
            this.afos.flush();
        }
        catch (Exception exception) {
            System.err.println("ERROR: Writing to log file: " + this.logFileName + ": " + exception);
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int writeWithTimeStamp(String string) {
        return this.write("[" + new Date().toString() + "] " + string);
    }

    public int close() {
        if (this.afos != null) {
            try {
                this.afos.close();
            }
            catch (Exception exception) {
                System.err.println("ERROR: Closing log file: " + this.logFileName + ": " + exception);
                return -1;
            }
        }
        return 0;
    }
}

