/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import net.alomax.earthworm.Util;
import net.alomax.earthworm.WSPacket;
import net.alomax.earthworm.WSSiteChanNet;
import net.alomax.io.BinaryInputStream;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;

public class SeisDataEarthwormTrace
extends SeisData {
    private static final boolean DEBUG = false;
    public String formatName = null;
    public WSSiteChanNet wsSiteChanNet = null;
    protected float[] sample;
    protected String dataUnits = "counts";

    public SeisDataEarthwormTrace(String string) {
        this.formatName = string;
    }

    public void read(BinaryInputStream binaryInputStream) throws Exception {
        block13: {
            byte[] byArray;
            block11: {
                int n;
                block12: {
                    int n2;
                    byArray = this.extractReply(binaryInputStream);
                    if (!this.formatName.equalsIgnoreCase("EW_TRACEBUF")) break block11;
                    WSPacket wSPacket = new WSPacket(byArray, 5);
                    this.wsSiteChanNet = new WSSiteChanNet(wSPacket.scnList[0]);
                    if (this.wsSiteChanNet.datatype.startsWith("i")) {
                        binaryInputStream.setBinaryType(1);
                    } else {
                        binaryInputStream.setBinaryType(0);
                    }
                    if (!this.wsSiteChanNet.datatype.substring(1).equals("4")) break block12;
                    float[] fArray = new float[this.wsSiteChanNet.numBytesData / 4];
                    int n3 = 0;
                    for (int i = 0; i < this.wsSiteChanNet.numBytesData; i += n2 * 4) {
                        int n4;
                        binaryInputStream.readIntB();
                        n2 = binaryInputStream.readIntB();
                        for (n4 = 0; n4 < 56; ++n4) {
                            binaryInputStream.readUnsignedByte();
                        }
                        i += 64;
                        for (n4 = 0; n4 < n2; ++n4) {
                            fArray[n3++] = binaryInputStream.readIntB();
                        }
                    }
                    this.sample = new float[n3];
                    System.arraycopy(fArray, 0, this.sample, 0, n3);
                    break block13;
                }
                if (!this.wsSiteChanNet.datatype.substring(1).equals("2")) break block13;
                float[] fArray = new float[this.wsSiteChanNet.numBytesData / 2];
                int n5 = 0;
                for (int i = 0; i < this.wsSiteChanNet.numBytesData; i += n * 2) {
                    int n6;
                    binaryInputStream.readIntB();
                    n = binaryInputStream.readIntB();
                    for (n6 = 0; n6 < 56; ++n6) {
                        binaryInputStream.readUnsignedByte();
                    }
                    i += 64;
                    for (n6 = 0; n6 < n; ++n6) {
                        fArray[n5++] = binaryInputStream.readShortB();
                    }
                }
                this.sample = new float[n5];
                System.arraycopy(fArray, 0, this.sample, 0, n5);
                break block13;
            }
            if (this.formatName.equalsIgnoreCase("EW_ASCII")) {
                WSPacket wSPacket = new WSPacket(byArray, 4);
                this.wsSiteChanNet = new WSSiteChanNet(wSPacket.scnList[0]);
                byte[] byArray2 = new byte[binaryInputStream.available()];
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = (byte)binaryInputStream.read();
                }
                String[] stringArray = StringExt.parse(new String(byArray2, 0, byArray2.length), " \n");
                this.sample = new float[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.sample[i] = Float.parseFloat(stringArray[i]);
                }
            }
        }
    }

    public byte[] extractReply(BinaryInputStream binaryInputStream) throws IOException {
        byte[] byArray;
        byte[] byArray2 = new byte[1024];
        int n = 0;
        int n2 = 50;
        int n3 = 30000;
        int n4 = 0;
        while (true) {
            if (binaryInputStream.available() > 0) {
                int n5 = binaryInputStream.read();
                if (n5 >= 0) {
                    byArray2[n4++] = (byte)n5;
                    if (n4 == byArray2.length) {
                        byArray = new byte[2 * byArray2.length];
                        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                        byArray2 = byArray;
                    }
                    if (n5 != 10) continue;
                }
                break;
            }
            if (n > n3) {
                return null;
            }
            Util.sleep(n2);
            n += n2;
        }
        if (n4 <= 0) {
            return new byte[0];
        }
        byArray = new byte[n4];
        System.arraycopy(byArray2, 0, byArray, 0, n4);
        return byArray;
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        SeisDataEarthwormTrace seisDataEarthwormTrace = this;
        double d = 0.0;
        if (seisDataEarthwormTrace.wsSiteChanNet.sampleRate > 0.0) {
            d = 1.0 / seisDataEarthwormTrace.wsSiteChanNet.sampleRate;
        } else if (seisDataEarthwormTrace.sample.length > 1) {
            d = (seisDataEarthwormTrace.wsSiteChanNet.endtime - seisDataEarthwormTrace.wsSiteChanNet.starttime) / (double)seisDataEarthwormTrace.sample.length;
        }
        System.out.println("sampleInt, endtime, starttime, length : " + d + " " + seisDataEarthwormTrace.wsSiteChanNet.endtime + " " + seisDataEarthwormTrace.wsSiteChanNet.starttime + " " + seisDataEarthwormTrace.sample.length);
        System.out.println("endtime-starttime- : " + (seisDataEarthwormTrace.wsSiteChanNet.endtime - seisDataEarthwormTrace.wsSiteChanNet.starttime));
        this.timeSeries = new TimeSeriesFloat(seisDataEarthwormTrace.sample, d, 0.0, this.dataUnits, "sec");
        this.timeMin = 0.0;
        TimeInstant timeInstant = null;
        try {
            timeInstant = new TimeInstant(1000.0 * seisDataEarthwormTrace.wsSiteChanNet.starttime);
        }
        catch (Exception exception) {
            timeInstant = new TimeInstant(1900, 1, 1);
        }
        int n = timeInstant.getDoY();
        this.iyear = timeInstant.getYear();
        this.ijday = timeInstant.getDoY();
        this.ihour = timeInstant.getHours();
        this.imin = timeInstant.getMinutes();
        this.sec = timeInstant.getSeconds();
        this.channel.network = seisDataEarthwormTrace.wsSiteChanNet.network;
        this.channel.staName = seisDataEarthwormTrace.wsSiteChanNet.site;
        this.channel.chanName = seisDataEarthwormTrace.wsSiteChanNet.channel;
        this.evtName = " ";
    }
}

