/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.liveseis;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.IndicatorJPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.liveseis.LiveSeisDescriptor;
import net.alomax.seisgram2k.liveseis.LiveSeisManagerBase;
import net.alomax.seisgram2k.liveseis.TitanLiveSeisSegmentURL;

public class TitanLiveSeisManager
extends LiveSeisManagerBase {
    protected static final boolean VERBOSE = false;
    protected TitanLiveSeisSegmentURL[] titanLiveSeisSegmentURL = null;
    protected int initialSegCount = 0;

    public TitanLiveSeisManager(GatherPanel gatherPanel, URL uRL, LiveSeisDescriptor liveSeisDescriptor) {
        super(gatherPanel, uRL, liveSeisDescriptor);
    }

    protected String formatMessage(String string) {
        return "TitanLiveSeisManager(" + this.managerIndex + "): " + string;
    }

    public int init() throws Exception {
        this.initialized = false;
        this.titanLiveSeisSegmentURL = new TitanLiveSeisSegmentURL[this.numChannels];
        for (int i = 0; i < this.numChannels; ++i) {
            String string;
            this.titanLiveSeisSegmentURL[i] = new TitanLiveSeisSegmentURL(this, this.liveSeisDescriptor.segmentURLTemplate[i]);
            this.titanLiveSeisSegmentURL[i].setCurrentDataFileToLast();
            if (this.checkForStop()) {
                return -1;
            }
            String string2 = this.titanLiveSeisSegmentURL[i].generateURLNameMinute();
            this.initialSegCount = this.liveSeisDescriptor.numSegmentsDisplay - 1;
            boolean bl = false;
            int n = 0;
            while (this.initialSegCount > 0 && n < 100) {
                this.titanLiveSeisSegmentURL[i].decrementMinute();
                if (this.titanLiveSeisSegmentURL[i].getLastModified() > 0L) {
                    --this.initialSegCount;
                    bl = true;
                    continue;
                }
                if (!bl) {
                    ++n;
                    continue;
                }
                this.titanLiveSeisSegmentURL[i].incrementMinute();
                break;
            }
            if (this.initialSegCount > 0) {
                string = this.formatMessage("WARNING: Could not find all required data segment files.");
                this.client.writeMessage(string);
                System.out.println(string);
            }
            string = this.formatMessage("first seg: " + this.titanLiveSeisSegmentURL[i].generateURLNameMinute() + "  last seg: " + string2);
            this.client.writeMessage(string);
            System.out.println(string);
            if (!this.checkForStop()) continue;
            return -1;
        }
        this.initialized = true;
        return this.liveSeisDescriptor.numSegmentsDisplay;
    }

    protected int loadSegments() throws Exception {
        if (!this.initialized) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < this.numChannels; ++i) {
            n += TitanLiveSeisManager.readSegment(0, this.documentBase, this.liveSeisDescriptor, this.titanLiveSeisSegmentURL[i], this.client);
            this.titanLiveSeisSegmentURL[i].incrementSegment();
            if (this.checkForStop()) {
                return -1;
            }
            int n2 = 1;
            while (n2 < this.liveSeisDescriptor.numSegmentsDisplay - this.initialSegCount) {
                ++n2;
                int n3 = 0;
                while (n3++ < 4) {
                    if (this.checkForStop()) {
                        return -1;
                    }
                    try {
                        TitanLiveSeisManager.readSegment(1, this.documentBase, this.liveSeisDescriptor, this.titanLiveSeisSegmentURL[i], this.client);
                        this.titanLiveSeisSegmentURL[i].incrementSegment();
                        break;
                    }
                    catch (Exception exception) {
                        String string = "WARNING: Trying again(" + n3 + "): ERROR: " + exception;
                        this.client.writeMessage(string);
                        System.out.println(string);
                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) continue;
                        exception.printStackTrace();
                    }
                }
                if (!this.checkForStop()) continue;
                return -1;
            }
        }
        this.doPreDisplay();
        this.client.monitorSeismogramAppended();
        return n;
    }

    protected static synchronized int readSegment(int n, URL uRL, LiveSeisDescriptor liveSeisDescriptor, TitanLiveSeisSegmentURL titanLiveSeisSegmentURL, GatherPanel gatherPanel) throws Exception {
        Object[] objectArray = null;
        InputStream inputStream = null;
        int n2 = 0;
        while (true) {
            String string;
            try {
                String string2 = titanLiveSeisSegmentURL.generateURLNameMinute();
                string = "";
                string = n == 0 ? "Reading: " + string2 : "Appending: " + string2;
                gatherPanel.writeMessage(string);
                Vector vector = new Vector();
                vector = gatherPanel.getDataManager().readTitanVolume(titanLiveSeisSegmentURL.getSeismogramURL(), vector, false, false);
                objectArray = new Seismogram[vector.size()];
                if (vector.size() <= 0) break;
                vector.copyInto(objectArray);
            }
            catch (Exception exception) {
                if (n2++ < 4) {
                    string = "WARNING: Trying again(" + n2 + "): ERROR: " + exception;
                    gatherPanel.writeMessage(string);
                    System.out.println(string);
                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) continue;
                    exception.printStackTrace();
                    continue;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    Runtime.getRuntime().gc();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw exception;
            }
            break;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            Runtime.getRuntime().gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectArray == null) {
            return -1;
        }
        if (n == 0) {
            gatherPanel.addSeismograms((Seismogram[])objectArray);
        } else {
            int n3 = liveSeisDescriptor.numSegmentsDisplay;
            gatherPanel.appendSeismograms((Seismogram[])objectArray, objectArray.length, n3, liveSeisDescriptor.contiguous);
        }
        return objectArray.length;
    }

    protected synchronized int appendSegment(int n) throws Exception {
        return TitanLiveSeisManager.readSegment(1, this.documentBase, this.liveSeisDescriptor, this.titanLiveSeisSegmentURL[n], this.client);
    }

    public void run() {
        long l;
        double d = this.liveSeisDescriptor.waitTime;
        long l2 = (long)(950.0 * d);
        long l3 = l = (long)(50.0 * d);
        long l4 = 2L * l2;
        try {
            if (this.init() < 0) {
                return;
            }
            if (this.checkForStop()) {
                return;
            }
            if (this.loadSegments() < 0) {
                return;
            }
            if (this.checkForStop()) {
                return;
            }
            this.client.liveSeisInitFinished();
        }
        catch (Exception exception) {
            String string = this.formatMessage("ERROR: " + exception);
            this.writeMessageWithDateStamp(string);
            System.out.println(string);
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            return;
        }
        do {
            int n = 0;
            long l5 = System.currentTimeMillis();
            boolean bl = true;
            for (int i = 0; i < this.numChannels; ++i) {
                if (this.checkForStop()) {
                    return;
                }
                try {
                    if (this.titanLiveSeisSegmentURL[i].getLastModified() > 0L) {
                        this.client.unDoRemoveMean();
                        if (this.appendSegment(i) < 1) {
                            String string = this.formatMessage("ERROR: Reading or appending segment: " + this.titanLiveSeisSegmentURL[i].generateURLNameMinute());
                            this.writeMessageWithDateStamp(string);
                        }
                        this.titanLiveSeisSegmentURL[i].incrementSegment();
                        this.doPreDisplay();
                        this.client.monitorSeismogramAppended();
                        this.writeMessageWithDateStamp(this.formatMessage("Last successful segment update:"));
                        if (!this.checkForStop()) continue;
                        return;
                    }
                    bl = false;
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("TitanLiveSeisManager: (" + new Date().toString() + ") caught and ignoring an exception:");
                    System.out.println(exception);
                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) continue;
                    exception.printStackTrace();
                }
            }
            if (bl) {
                l3 = l;
                long l6 = l3 - (System.currentTimeMillis() - l5);
                if (l6 > 0L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(l6);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n = (int)((long)n + l6);
                }
                if (this.checkForStop()) {
                    return;
                }
            } else {
                if (l3 < l2) {
                    l3 += l;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n = (int)((long)n + l);
                if (this.checkForStop()) {
                    return;
                }
            }
            if ((long)n > l4) {
                String string = this.formatMessage("WARNING: Too much time before segment update.");
                this.writeMessageWithDateStamp(string);
                this.client.setIndicator(IndicatorJPanel.INDICATOR_ERROR);
                n = 0;
                continue;
            }
            this.client.setIndicator(IndicatorJPanel.INDICATOR_OFF);
        } while (!this.checkForStop());
    }
}

