/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.Smoothing;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainText;

public class SmoothingToolManager
extends JToolManager {
    protected String[] typeNames = new String[]{"BOXCAR", "TRIANGLE"};
    protected SeisGram2KFrame seisFrame = null;
    protected Smoothing smoothing;
    protected double windowHalfWidthTime = 1.0;
    private static final double SMOOTHING_WINDOW_MIN = Double.MIN_VALUE;
    private static final double SMOOTHING_WINDOW_MAX = Double.MAX_VALUE;
    protected AJLJButton buttonApplySmoothing;
    protected JTextField textFieldWindowHalfWidthTime;
    protected JComboBox choiceType;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public SmoothingToolManager(SeisGram2KFrame seisGram2KFrame) {
        String string;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.smoothing = new Smoothing(SeisGramText.getLocaleString(), 1, 999);
        try {
            string = null;
            string = seisGram2KFrame.getParameter("timedom.smooth.type");
            if (string != null) {
                this.smoothing.setType(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = seisGram2KFrame.getParameter("timedom.smooth.halfwidth");
            if (string != null) {
                this.setWindowHalfWidthTime(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        this.commandNames = new String[]{"smooth"};
        this.commandNamesShort = new String[]{"smo"};
    }

    public void updateLabel() {
        this.label = SeisGramText.SMOOTHING;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void setWindowHalfWidthTime(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_smoothing_half_width_value + ": " + d);
        }
        this.windowHalfWidthTime = d;
    }

    public void setWindowHalfWidthTime(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_smoothing_half_width_value + ": " + string);
        }
        this.setWindowHalfWidthTime(d);
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplySmoothing = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplySmoothing);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.HALF_WIDTH + " " + SeisGramText.SEC + ":", 4));
        this.textFieldWindowHalfWidthTime = SwingExt.newJTextField(this, this, String.valueOf(this.windowHalfWidthTime), 5);
        jToolBar.add(this.textFieldWindowHalfWidthTime);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.TYPE + ":", 4));
        this.choiceType = SwingExt.newChoice(this, this.typeNames);
        this.choiceType.setSelectedIndex(this.smoothing.getType());
        jToolBar.add(this.choiceType);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplySmoothing)) {
            boolean bl = false;
            try {
                this.setWindowHalfWidthTime(this.textFieldWindowHalfWidthTime.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldWindowHalfWidthTime.setText(String.valueOf(this.windowHalfWidthTime));
            try {
                this.smoothing.setType(this.choiceType.getSelectedIndex());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            if (bl) {
                return;
            }
            try {
                this.smoothing.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldWindowHalfWidthTime)) {
            try {
                this.setWindowHalfWidthTime(this.textFieldWindowHalfWidthTime.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldWindowHalfWidthTime.setText(String.valueOf(this.windowHalfWidthTime));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldWindowHalfWidthTime)) {
            try {
                this.smoothing.setType(this.choiceType.getSelectedIndex());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
        } else {
            return;
        }
    }

    protected void apply() throws TimeDomainException {
        try {
            double d = this.seisFrame.getActiveGatherSampleInt();
            int n = 1 + (int)(this.windowHalfWidthTime / d);
            this.smoothing.setWindowHalfWidth(n);
        }
        catch (Exception exception) {
            throw new TimeDomainException(SeisGramText.SMOOTHING + ": " + exception);
        }
        this.smoothing.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.smoothing, this.getCommandString());
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        block10: {
            if (!this.isCommandHandler(string)) {
                throw new JToolManagerException("Not command handler: " + string);
            }
            try {
                this.setWindowHalfWidthTime(this.windowHalfWidthTime);
            }
            catch (Exception exception) {
                throw new JToolManagerException(exception.getMessage());
            }
            String string2 = " ";
            this.argumentString = string;
            StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
            try {
                stringTokenizer.nextToken();
                if (this.variant < 0) break block10;
                boolean bl = true;
                block5: while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("ty")) {
                        string2 = stringTokenizer.nextToken();
                        for (int i = 0; i < this.typeNames.length; ++i) {
                            if (!string2.equalsIgnoreCase(this.typeNames[i])) continue;
                            this.smoothing.setType(i);
                            continue block5;
                        }
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("ha")) {
                        this.setWindowHalfWidthTime(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new JToolManagerException("Parsing or applying command", string, string2);
            }
            catch (TimeDomainException timeDomainException) {
                throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
            }
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " type " + this.typeNames[this.smoothing.type];
        string = string + " ha " + this.windowHalfWidthTime;
        return string;
    }
}

