/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.toolmanager.DurationAmplitudeToolManager;
import net.alomax.seisgram2k.toolmanager.EnergyDurationToolManager;
import net.alomax.seisgram2k.toolmanager.InstantPeriodToolManager;
import net.alomax.seisgram2k.toolmanager.SmoothingToolManager;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JCommandException;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.timedom.TimeDomainException;

public class TimeDomainToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected AJLJButton buttonSquare;
    protected AJLJButton buttonRemTrend;
    protected AJLJButton buttonNormalize;
    protected AJLJButton buttonChop;
    protected AJLJButton buttonGeomSpread;
    protected AJLJButton buttonSmoothing;
    protected AJLJButton buttonInstantPeriod;
    protected AJLJButton buttonEnergyDuration;
    protected AJLJButton buttonDurationAmplitude;
    protected EnergyDurationToolManager energyDurationManager = null;
    protected DurationAmplitudeToolManager durationAmplitudeManager = null;
    protected InstantPeriodToolManager instantPeriodManager = null;
    protected SmoothingToolManager smoothingManager = null;
    protected static final int SQUARE = 0;
    protected static final int NORM = 1;
    protected static final int CHOP = 2;
    protected static final int GEOM_SPREAD = 3;
    protected static final int REC_FILT = 4;
    protected static final int RTREND = 5;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public TimeDomainToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.commandNames = new String[]{"square", "normalize", "chop", "geomspread", "recursionfilter", "removetrend"};
        this.commandNamesShort = new String[]{"sqr", "norm", "chop", "gs", "recfilt", "rtrend"};
    }

    public void updateLabel() {
        this.label = SeisGramText.TIME_DOMAIN;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonRemTrend = new AJLJButton(this, this, SeisGramText.REMOVE_TREND);
        jToolBar.add(this.buttonRemTrend);
        this.buttonSmoothing = new AJLJButton(this, this, SeisGramText.SMOOTHING);
        jToolBar.add(this.buttonSmoothing);
        this.buttonSquare = new AJLJButton(this, this, SeisGramText.SQUARE);
        jToolBar.add(this.buttonSquare);
        this.buttonNormalize = new AJLJButton(this, this, SeisGramText.NORMALIZE);
        jToolBar.add(this.buttonNormalize);
        this.buttonChop = new AJLJButton(this, this, SeisGramText.CHOP);
        jToolBar.add(this.buttonChop);
        this.buttonGeomSpread = new AJLJButton(this, this, SeisGramText.GEOMETRICAL_SPREADING);
        jToolBar.add(this.buttonGeomSpread);
        this.buttonInstantPeriod = new AJLJButton(this, this, SeisGramText.INSTANT_PERIOD);
        jToolBar.add(this.buttonInstantPeriod);
        this.buttonEnergyDuration = new AJLJButton(this, this, SeisGramText.ENERGY_DURATION);
        jToolBar.add(this.buttonEnergyDuration);
        this.buttonDurationAmplitude = new AJLJButton(this, this, SeisGramText.DURATION_AMPLITUDE);
        jToolBar.add(this.buttonDurationAmplitude);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource().equals(this.buttonSquare)) {
                this.variant = 0;
            } else if (actionEvent.getSource().equals(this.buttonRemTrend)) {
                this.variant = 5;
            } else if (actionEvent.getSource().equals(this.buttonNormalize)) {
                this.variant = 1;
            } else if (actionEvent.getSource().equals(this.buttonChop)) {
                this.variant = 2;
            } else if (actionEvent.getSource().equals(this.buttonGeomSpread)) {
                this.variant = 3;
            } else {
                if (actionEvent.getSource().equals(this.buttonSmoothing)) {
                    if (this.smoothingManager == null) {
                        this.smoothingManager = new SmoothingToolManager(this.seisFrame);
                    }
                    this.seisFrame.initializeInteractionPanel(this.smoothingManager);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonInstantPeriod)) {
                    if (this.instantPeriodManager == null) {
                        this.instantPeriodManager = new InstantPeriodToolManager(this.seisFrame);
                    }
                    this.seisFrame.initializeInteractionPanel(this.instantPeriodManager);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonEnergyDuration)) {
                    if (this.energyDurationManager == null) {
                        this.energyDurationManager = new EnergyDurationToolManager(this.seisFrame);
                    }
                    this.seisFrame.initializeInteractionPanel(this.energyDurationManager);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonDurationAmplitude)) {
                    if (this.durationAmplitudeManager == null) {
                        this.durationAmplitudeManager = new DurationAmplitudeToolManager(this.seisFrame);
                    }
                    this.seisFrame.initializeInteractionPanel(this.durationAmplitudeManager);
                    return;
                }
                return;
            }
            this.apply();
        }
        catch (Exception exception) {
            this.seisFrame.writeMessage("ERROR: " + exception.toString());
        }
    }

    protected void apply() throws TimeDomainException, JCommandException {
        if (this.variant == 0) {
            this.seisFrame.applyCommand(this.getCommandString());
        } else if (this.variant == 5) {
            this.seisFrame.applyCommand(this.getCommandString());
        } else if (this.variant == 1) {
            this.seisFrame.applyCommand(this.getCommandString());
        } else if (this.variant == 2) {
            this.seisFrame.applyCommand(this.getCommandString());
        } else if (this.variant == 3) {
            this.seisFrame.applyCommand(this.getCommandString());
        } else if (this.variant == 4) {
            this.seisFrame.applyCommand(this.getCommandString());
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        if (this.smoothingManager == null) {
            this.smoothingManager = new SmoothingToolManager(this.seisFrame);
        }
        if (this.smoothingManager != null && this.smoothingManager.isCommandHandler(string)) {
            return true;
        }
        if (this.instantPeriodManager == null) {
            this.instantPeriodManager = new InstantPeriodToolManager(this.seisFrame);
        }
        if (this.instantPeriodManager != null && this.instantPeriodManager.isCommandHandler(string)) {
            return true;
        }
        if (this.energyDurationManager == null) {
            this.energyDurationManager = new EnergyDurationToolManager(this.seisFrame);
        }
        if (this.energyDurationManager != null && this.energyDurationManager.isCommandHandler(string)) {
            return true;
        }
        if (this.durationAmplitudeManager == null) {
            this.durationAmplitudeManager = new DurationAmplitudeToolManager(this.seisFrame);
        }
        return this.durationAmplitudeManager != null && this.durationAmplitudeManager.isCommandHandler(string);
    }

    public void applyCommand(String string) throws JCommandException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        if (this.smoothingManager != null && this.smoothingManager.isCommandHandler(string)) {
            this.smoothingManager.applyCommand(string);
            return;
        }
        if (this.instantPeriodManager != null && this.instantPeriodManager.isCommandHandler(string)) {
            this.instantPeriodManager.applyCommand(string);
            return;
        }
        if (this.energyDurationManager != null && this.energyDurationManager.isCommandHandler(string)) {
            this.energyDurationManager.applyCommand(string);
            return;
        }
        if (this.durationAmplitudeManager != null && this.durationAmplitudeManager.isCommandHandler(string)) {
            this.durationAmplitudeManager.applyCommand(string);
            return;
        }
        String string2 = " ";
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        return string;
    }
}

