/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.BasicPicker;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainText;

public class TestPicker
extends BasicPicker {
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    public double longTermWindow = 10.0;
    public double threshold1 = 10.0;
    public double threshold2 = 10.0;
    public double tUpEvent = 1.0;
    public double meanWindow = 2.0;
    public String errorMessage;
    private static final double THRESHOLD_MIN = Double.MIN_VALUE;
    private static final double THRESHOLD_MAX = Double.MAX_VALUE;
    private static final double TIME_MIN = -1.7976931348623157E308;
    private static final double TIME_MAX = Double.MAX_VALUE;

    public TestPicker(String string, double d, double d2, double d3, double d4, double d5, int n) {
        super(string, n);
        this.longTermWindow = d;
        this.threshold1 = d2;
        this.threshold2 = d3;
        this.tUpEvent = d4;
        this.meanWindow = d5;
    }

    public void setLongTermWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + d);
        }
        this.longTermWindow = d;
    }

    public void setLongTermWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + string);
        }
        this.setLongTermWindow(d);
    }

    public void setThreshold1(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + d);
        }
        this.threshold1 = d;
    }

    public void setThreshold1(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + string);
        }
        this.setThreshold1(d);
    }

    public void setThreshold2(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + d);
        }
        this.threshold2 = d;
    }

    public void setThreshold2(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + string);
        }
        this.setThreshold2(d);
    }

    public void setTUpEvent(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + d);
        }
        this.tUpEvent = d;
    }

    public void setTUpEvent(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + string);
        }
        this.setTUpEvent(d);
    }

    public void setMeanWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_meanWindow_value + ": " + d);
        }
        this.meanWindow = d;
    }

    public void setMeanWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_meanWindow_value + ": " + string);
        }
        this.setMeanWindow(d);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String string = "";
        int n = 0;
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_long_term_window_value;
            ++n;
        }
        if (this.threshold1 < Double.MIN_VALUE || this.threshold1 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold1_value;
            ++n;
        }
        if (this.threshold2 < Double.MIN_VALUE || this.threshold2 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold2_value;
            ++n;
        }
        if (this.tUpEvent < -1.7976931348623157E308 || this.tUpEvent > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_tUpEvent_value;
            ++n;
        }
        if (this.meanWindow < -1.7976931348623157E308 || this.meanWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_meanWindow_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public void updateFields(TimeSeries timeSeries) {
        super.updateFields(timeSeries);
    }

    public final float[] apply(double d, float[] fArray) {
        double d2 = 1.0;
        int n = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        double d5 = d / this.longTermWindow;
        double d6 = 1.0 - d5;
        int n3 = 1 + (int)(this.longTermWindow / d);
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = d / (100.0 * this.meanWindow);
        double d10 = 1.0 - d9;
        double d11 = 0.0;
        double d12 = 0.0;
        boolean bl = false;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        boolean bl2 = false;
        double d26 = 0.0;
        boolean bl3 = this.direction == -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = (int)(0.5 + this.tUpEvent / d) - 1;
        if (n6 < 1) {
            n6 = 1;
        }
        double d27 = (double)n6 * this.threshold2;
        double d28 = 0.0;
        double[] dArray = new double[n6];
        int n7 = -1;
        int n8 = (int)(this.meanWindow / d);
        boolean bl4 = false;
        boolean bl5 = false;
        int n9 = 0;
        boolean bl6 = false;
        d7 = bl3 ? (double)fArray[fArray.length - 1] : (double)fArray[0];
        if (this.resultType == 2 || this.resultType == 1) {
            fArray[fArray.length - 1] = 0.0f;
            fArray[0] = 0.0f;
        }
        for (int i = 1; i < fArray.length - 1; ++i) {
            int n10 = bl3 ? fArray.length - i - 1 : i;
            if (!bl2) {
                d8 = d7;
                d13 = d18;
                d14 = d21;
                d15 = d20;
            }
            double d29 = (double)fArray[n10] - d8;
            double d30 = d29 - d12;
            d12 = d29;
            double d31 = d30 * d30;
            double d32 = d29 * d29 + d31 * d13 / 2.0;
            if (Double.isInfinite(d32) || d32 > Math.sqrt(Double.MAX_VALUE)) {
                d32 = Math.sqrt(Double.MAX_VALUE);
                System.out.println("ACTIVE: Double.isInfinite(E2) || E2 > Math.sqrt(Double.MAX_VALUE");
            }
            d22 = d15 <= (double)1.4E-45f ? 0.0 : (d32 - d14) / d15;
            if (bl2 && (Double.isInfinite(d32 = d29 * d29 + d31 * d18 / 2.0) || d32 > Math.sqrt(Double.MAX_VALUE))) {
                d32 = Math.sqrt(Double.MAX_VALUE);
                System.out.println("Double.isInfinite(E2) || E2 > Math.sqrt(Double.MAX_VALUE");
            }
            d23 = (d22 + d24 + d25) / 3.0;
            d25 = d24;
            d24 = d22;
            if (d23 > d2) {
                if (n < 0) {
                    n = bl3 ? n10 + 1 : n10 - 1;
                    d4 = d3 = (double)fArray[n] - d8;
                    n2 = 0;
                }
            } else if (!bl2) {
                n = -1;
            }
            if (n >= 0 && !bl2) {
                d4 = Math.abs(d29 - d3) > Math.abs(d4) ? d29 - d3 : d4;
                n2 += d30 > 0.0 ? 1 : -1;
            }
            if (i > n3) {
                n7 = (n7 + 1) % n6;
                d28 -= dArray[n7];
                dArray[n7] = d22;
                if (bl2) {
                    if (n10 > n4 + 1) {
                        d28 += d22;
                    } else {
                        double d33 = d22 < this.threshold1 ? d22 : this.threshold1;
                        d28 += d33;
                        dArray[n7] = d33;
                    }
                    d26 += d22;
                    if (i <= n5) {
                        if (!bl5 && d28 >= d27) {
                            bl5 = true;
                        }
                    } else {
                        if (bl5) {
                            bl4 = true;
                        }
                        bl5 = false;
                        bl2 = false;
                    }
                } else if (d22 >= this.threshold1) {
                    bl2 = true;
                    d26 = d22;
                    n4 = n10;
                    n5 = i + n6;
                    d28 += this.threshold1;
                    dArray[n7] = this.threshold1;
                    n9 = n2 > 1 ? 1 : (n2 < -1 ? -1 : 0);
                } else {
                    d28 += d22;
                }
            }
            d16 = d16 * d6 + d29 * d29 * d5;
            if ((d17 = d17 * d6 + d31 * d5) > (double)1.4E-45f) {
                d18 = d16 / d17;
            } else {
                System.out.println("mean_dXdt2 < Float.MIN_VALUE");
            }
            d21 = d21 * d6 + d32 * d5;
            double d34 = d32 - d21;
            d19 = d19 * d6 + d34 * d34 * d5;
            d20 = Math.sqrt(d19);
            d7 = d7 * d10 + (double)fArray[n10] * d9;
            if (this.resultType == 2) {
                fArray[n10] = bl4 ? 1.0f : 0.0f;
            } else if (this.resultType == 1) {
                fArray[n10] = (float)d22;
            } else if (bl4) {
                PickData pickData = new PickData(n, n4, n9, Math.log(d26 / d27), "_CF");
                this.triggerPickData.add(pickData);
                n = -1;
            }
            bl4 = false;
        }
        return fArray;
    }
}

