/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.util;

import java.io.Serializable;
import java.util.SimpleTimeZone;
import net.alomax.util.AJLGregorianCalendar;
import net.alomax.util.NumberFormat;

public class Date2
implements Serializable {
    private static String className;
    protected static SimpleTimeZone timezone;
    protected static AJLGregorianCalendar calendar;
    public static final int YYYYMONTHDD = 0;
    public static final int YYYYMONTHDD_DOY = 1;
    public static final int YYYYMMDD = 2;
    public static final int YYYYMMDD_NO_SPACES = 3;
    static String[][] monthName;
    static int[][] monthNumDays;
    static final int en_US = 0;
    static final int fr_FR = 1;
    static final int it_IT = 2;
    private static int defaultLocale;
    protected int locale = defaultLocale;
    protected int year = -1;
    protected int month = -1;
    protected int date = -1;
    protected int dayOfYear = -1;

    public Date2() {
        this(1970, 0, 1);
    }

    public Date2(int n, int n2) {
        int n3;
        className = this.getClass().getName() + ": ";
        this.dayOfYear = n2;
        if (n <= 20) {
            System.out.println(className + "WARNING: Apparent invalid year in date: " + n + ": adding 2000 to year: " + (n + 2000));
            n += 2000;
        }
        if (n < 200) {
            System.out.println(className + "WARNING: Apparent invalid year in date: " + n + ": adding 1900 to year: " + (n + 1900));
            n += 1900;
        }
        int n4 = 0;
        if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
            n4 = 1;
        }
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < 12 && (n5 += monthNumDays[n4][n3]) < n2; ++n3) {
            n6 = n5;
        }
        if (n3 == 12) {
            System.out.println(className + "WARNING: Invalid day of year in date: " + n2);
        }
        this.year = n;
        this.month = n3;
        this.date = n2 - n6;
    }

    public Date2(int n, int n2, String string) {
        this(n, n2);
        this.setLocale(string);
    }

    public Date2(int n, int n2, int n3) {
        className = this.getClass().getName() + ": ";
        this.year = n;
        this.month = n2 - 1;
        this.date = n3;
        int n4 = 0;
        if (n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
            n4 = 1;
        }
        int n5 = 0;
        for (int i = 0; i < this.month; ++i) {
            n5 += monthNumDays[n4][i];
        }
        this.dayOfYear = n5 + this.date;
    }

    Date2(int n, int n2, int n3, String string) {
        this(n, n2, n3);
        this.setLocale(string);
    }

    public static Date2 create(long l) {
        calendar.clear();
        calendar.setTimeInMillis(l);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Date2(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static int str2intMonth(String string) {
        for (int i = 0; i < monthName[defaultLocale].length; ++i) {
            if (!monthName[defaultLocale][i].equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        return 0;
    }

    public boolean equals(Date2 date2) {
        if (this.date != date2.date) {
            return false;
        }
        if (this.month != date2.month) {
            return false;
        }
        return this.year == date2.year;
    }

    public static void setDefaultLocale(String string) {
        if (string == null) {
            return;
        }
        defaultLocale = string.toLowerCase().startsWith("fr") ? 1 : (string.equalsIgnoreCase("it_IT") ? 2 : 0);
    }

    public void setLocale(String string) {
        if (string == null) {
            this.locale = defaultLocale;
            return;
        }
        if (string.equalsIgnoreCase("fr_FR")) {
            this.locale = 1;
        } else if (string.equalsIgnoreCase("it_IT")) {
            this.locale = 2;
        }
    }

    public long getTime() {
        calendar.clear();
        calendar.set(this.year, this.month, this.date, 0, 0, 0);
        long l = calendar.getTimeInMillis();
        return l;
    }

    public int getYear() {
        return this.year;
    }

    public int getDoY() {
        return this.dayOfYear;
    }

    public int getMonth() {
        return this.month + 1;
    }

    public int getDate() {
        return this.date;
    }

    public String getChrMonth() {
        return monthName[this.locale][this.month];
    }

    public String toString2(int n) {
        String string;
        String string2 = "";
        if (n == 0) {
            string = this.getChrMonth();
        } else if (n == 1) {
            string = this.getChrMonth();
            string2 = " (" + NumberFormat.intString(this.getDoY(), 3) + ")";
        } else {
            string = n == 2 || n == 3 ? NumberFormat.intString(this.getMonth(), 2) : "???";
        }
        if (n == 3) {
            return new String(NumberFormat.intString(this.getYear(), 4) + string + NumberFormat.intString(this.getDate(), 2));
        }
        return new String(NumberFormat.intString(this.getYear(), 4) + " " + string + " " + NumberFormat.intString(this.getDate(), 2) + string2);
    }

    public String toDelimitedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NumberFormat.intString(this.year, 4)).append(string);
        stringBuffer.append(NumberFormat.intString(this.month + 1, 2)).append(string);
        stringBuffer.append(NumberFormat.intString(this.date, 2));
        return stringBuffer.toString();
    }

    static {
        timezone = new SimpleTimeZone(0, "GMT");
        calendar = new AJLGregorianCalendar(timezone);
        monthName = new String[][]{{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC", "???"}, {"JAN", "FEV", "MAR", "AVR", "MAI", "JUI", "JUL", "AOU", "SEP", "OCT", "NOV", "DEC", "???"}, {"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC", "???"}};
        monthNumDays = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}};
        defaultLocale = 0;
    }
}

