# Copyright 2018-2022 Akretion France (http://www.akretion.com/)
# @author: Alexis de Lattre <alexis.delattre@akretion.com>
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo import SUPERUSER_ID, api


def set_xml_format_in_pdf_invoice_to_facturx(cr, registry):
    env = api.Environment(cr, SUPERUSER_ID, {})
    companies = env["res.company"].search(
        [("xml_format_in_pdf_invoice", "in", (False, "none"))]
    )
    companies.write({"xml_format_in_pdf_invoice": "factur-x"})
