# coding: utf-8

# flake8: noqa

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.5
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.13.5"

# import apis into sdk package
from songtradr_api_client_python.api.api_keys_api import APIKeysApi
from songtradr_api_client_python.api.admin_users_controller_api import AdminUsersControllerApi
from songtradr_api_client_python.api.allowed_values_api import AllowedValuesApi
from songtradr_api_client_python.api.internal_api_api import InternalApiApi
from songtradr_api_client_python.api.party_api import PartyApi
from songtradr_api_client_python.api.playlist_api import PlaylistApi
from songtradr_api_client_python.api.recording_api import RecordingApi
from songtradr_api_client_python.api.user_api import UserApi

# import ApiClient
from songtradr_api_client_python.api_response import ApiResponse
from songtradr_api_client_python.api_client import ApiClient
from songtradr_api_client_python.configuration import Configuration
from songtradr_api_client_python.exceptions import OpenApiException
from songtradr_api_client_python.exceptions import ApiTypeError
from songtradr_api_client_python.exceptions import ApiValueError
from songtradr_api_client_python.exceptions import ApiKeyError
from songtradr_api_client_python.exceptions import ApiAttributeError
from songtradr_api_client_python.exceptions import ApiException

# import models into sdk package
from songtradr_api_client_python.models.admin_api_create_user_dto import AdminApiCreateUserDTO
from songtradr_api_client_python.models.admin_api_update_user_dto import AdminApiUpdateUserDTO
from songtradr_api_client_python.models.admin_api_user_dto import AdminApiUserDTO
from songtradr_api_client_python.models.age_range import AgeRange
from songtradr_api_client_python.models.api_key_dto import ApiKeyDTO
from songtradr_api_client_python.models.beard import Beard
from songtradr_api_client_python.models.bounding_box import BoundingBox
from songtradr_api_client_python.models.category_medium_dto import CategoryMediumDTO
from songtradr_api_client_python.models.category_minimal_dto import CategoryMinimalDTO
from songtradr_api_client_python.models.config_access_dto import ConfigAccessDTO
from songtradr_api_client_python.models.config_identifier_dto import ConfigIdentifierDTO
from songtradr_api_client_python.models.context_value import ContextValue
from songtradr_api_client_python.models.contributor_type_dto import ContributorTypeDTO
from songtradr_api_client_python.models.create_api_key_dto import CreateApiKeyDTO
from songtradr_api_client_python.models.curate_playlist_dto import CuratePlaylistDTO
from songtradr_api_client_python.models.curate_playlist_response_dto import CuratePlaylistResponseDTO
from songtradr_api_client_python.models.dominant_color import DominantColor
from songtradr_api_client_python.models.emotion import Emotion
from songtradr_api_client_python.models.error_response import ErrorResponse
from songtradr_api_client_python.models.eye_direction import EyeDirection
from songtradr_api_client_python.models.eye_open import EyeOpen
from songtradr_api_client_python.models.eyeglasses import Eyeglasses
from songtradr_api_client_python.models.face_detail import FaceDetail
from songtradr_api_client_python.models.face_detection import FaceDetection
from songtradr_api_client_python.models.face_occluded import FaceOccluded
from songtradr_api_client_python.models.field_summary_dto import FieldSummaryDTO
from songtradr_api_client_python.models.file_dto import FileDTO
from songtradr_api_client_python.models.file_list_dto import FileListDTO
from songtradr_api_client_python.models.file_minimal_with_url_dto import FileMinimalWithUrlDTO
from songtradr_api_client_python.models.file_small_dto import FileSmallDTO
from songtradr_api_client_python.models.file_upload_dto import FileUploadDTO
from songtradr_api_client_python.models.file_w_ith_url_dto import FileWIthUrlDTO
from songtradr_api_client_python.models.files_summary_dto import FilesSummaryDTO
from songtradr_api_client_python.models.forgot_password_dto import ForgotPasswordDTO
from songtradr_api_client_python.models.gender import Gender
from songtradr_api_client_python.models.genre_dto import GenreDTO
from songtradr_api_client_python.models.genre_minimal_dto import GenreMinimalDTO
from songtradr_api_client_python.models.genres_summary_dto import GenresSummaryDTO
from songtradr_api_client_python.models.image_quality import ImageQuality
from songtradr_api_client_python.models.image_recognition_response import ImageRecognitionResponse
from songtradr_api_client_python.models.init_put_recording_audio_dto import InitPutRecordingAudioDTO
from songtradr_api_client_python.models.instance import Instance
from songtradr_api_client_python.models.jwt_token_dto import JwtTokenDTO
from songtradr_api_client_python.models.label import Label
from songtradr_api_client_python.models.label_alias import LabelAlias
from songtradr_api_client_python.models.label_category import LabelCategory
from songtradr_api_client_python.models.label_detection import LabelDetection
from songtradr_api_client_python.models.landmark import Landmark
from songtradr_api_client_python.models.login_dto import LoginDTO
from songtradr_api_client_python.models.mouth_open import MouthOpen
from songtradr_api_client_python.models.musical_features_dto import MusicalFeaturesDTO
from songtradr_api_client_python.models.mustache import Mustache
from songtradr_api_client_python.models.p_line_dto import PLineDTO
from songtradr_api_client_python.models.parent import Parent
from songtradr_api_client_python.models.party_large_dto import PartyLargeDTO
from songtradr_api_client_python.models.party_small_dto import PartySmallDTO
from songtradr_api_client_python.models.playlist_large_dto import PlaylistLargeDTO
from songtradr_api_client_python.models.pose import Pose
from songtradr_api_client_python.models.product_medium_dto import ProductMediumDTO
from songtradr_api_client_python.models.product_party_dto import ProductPartyDTO
from songtradr_api_client_python.models.recording_for_similarity_search_dto import RecordingForSimilaritySearchDTO
from songtradr_api_client_python.models.recording_genre_prediction_dto import RecordingGenrePredictionDTO
from songtradr_api_client_python.models.recording_large_dto import RecordingLargeDTO
from songtradr_api_client_python.models.recording_list_dto import RecordingListDTO
from songtradr_api_client_python.models.recording_medium_dto import RecordingMediumDTO
from songtradr_api_client_python.models.recording_minimal_with_musical_features_dto import RecordingMinimalWithMusicalFeaturesDTO
from songtradr_api_client_python.models.recording_minimal_with_taggrams_dto import RecordingMinimalWithTaggramsDTO
from songtradr_api_client_python.models.recording_minimal_with_tagstrengths_dto import RecordingMinimalWithTagstrengthsDTO
from songtradr_api_client_python.models.recording_party_dto import RecordingPartyDTO
from songtradr_api_client_python.models.recording_playlist_dto import RecordingPlaylistDTO
from songtradr_api_client_python.models.recording_small_dto import RecordingSmallDTO
from songtradr_api_client_python.models.recording_tag_small_dto import RecordingTagSmallDTO
from songtradr_api_client_python.models.save_file_dto import SaveFileDTO
from songtradr_api_client_python.models.save_file_recording_dto import SaveFileRecordingDTO
from songtradr_api_client_python.models.save_playlist_dto import SavePlaylistDTO
from songtradr_api_client_python.models.save_recording_genre_dto import SaveRecordingGenreDTO
from songtradr_api_client_python.models.save_recording_party_dto import SaveRecordingPartyDTO
from songtradr_api_client_python.models.save_recording_playlist_dto import SaveRecordingPlaylistDTO
from songtradr_api_client_python.models.save_recording_tag_dto import SaveRecordingTagDTO
from songtradr_api_client_python.models.save_referrer_dto import SaveReferrerDTO
from songtradr_api_client_python.models.save_taggrams_dto import SaveTaggramsDTO
from songtradr_api_client_python.models.save_user_dto import SaveUserDTO
from songtradr_api_client_python.models.search_filter_values_dto import SearchFilterValuesDTO
from songtradr_api_client_python.models.search_recording_granular_abstraction_dto import SearchRecordingGranularAbstractionDTO
from songtradr_api_client_python.models.search_recording_granular_dto import SearchRecordingGranularDTO
from songtradr_api_client_python.models.sign_up_dto import SignUpDTO
from songtradr_api_client_python.models.smile import Smile
from songtradr_api_client_python.models.sunglasses import Sunglasses
from songtradr_api_client_python.models.tag_dto import TagDTO
from songtradr_api_client_python.models.tag_small_dto import TagSmallDTO
from songtradr_api_client_python.models.taggram_dto import TaggramDTO
from songtradr_api_client_python.models.tags_summary_dto import TagsSummaryDTO
from songtradr_api_client_python.models.tagstrength_dto import TagstrengthDTO
from songtradr_api_client_python.models.title_dto import TitleDTO
from songtradr_api_client_python.models.token_request import TokenRequest
from songtradr_api_client_python.models.track_dto import TrackDTO
from songtradr_api_client_python.models.track_to_medium_product_dto import TrackToMediumProductDTO
from songtradr_api_client_python.models.update_password_dto import UpdatePasswordDTO
from songtradr_api_client_python.models.usage_dto import UsageDTO
from songtradr_api_client_python.models.user_dto import UserDTO
from songtradr_api_client_python.models.video_recognition_response import VideoRecognitionResponse
